/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.cpf.DVTCPFMacroModel;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclCommandArg;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class CPFSetInstanceCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currSope;
    protected DVTPFModel.CPFVersionType currVersion;
    protected String currParsedPfFile;

    public CPFSetInstanceCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currSope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getCPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currSope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        this.args[0].getArgLine();
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String scopeName = commandArgs.getCommandArg();
        if (scopeName == null) {
            return;
        }
        String modelName = commandArgs.getOptionValue("model");
        if (modelName != null) {
            this.applyMacroModel(scopeName, modelName, commandArgs);
        } else {
            ElementPath newScope = this.resolveScope(this.currSope, this.currTopDesign, scopeName, this.currHierarchySeparator, this.args);
            IRfDesignElement newTopDesign = this.computeDesignTop(newScope);
            if (newTopDesign == null) {
                DVTLogger.INSTANCE.logDebug("DVTCPFInterp - set_instance: computed top for path '" + newScope.toString(this.currHierarchySeparator) + " is null");
            } else {
                this.pfModel.addScope(newScope);
            }
            StringBuilder message = new StringBuilder("set_instance ").append(scopeName).append(" ... (with top " + (newTopDesign == null ? "null" : newTopDesign.getName()) + ")");
            DVTTclUtils.printToConsole("[PF (CPF)] " + message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
        }
    }

    private void applyMacroModel(String scopeName, String modelName, DVTCommandResult commandArgs) {
        String domainMappingString = commandArgs.getOptionValue("domain_mapping");
        if (domainMappingString == null) {
            return;
        }
        DVTCPFMacroModel macroModel = this.pfModel.getMacroModel(modelName);
        if (macroModel == null) {
            return;
        }
        macroModel.setInstanceName(String.valueOf(this.currSope.toString(this.currHierarchySeparator)) + this.currHierarchySeparator + scopeName);
        Matcher matcher = Pattern.compile("(\\{\\w+\\s+\\w+\\})").matcher(domainMappingString);
        while (matcher.find()) {
            String[] groups;
            String group = matcher.group(0);
            if (group == null || group.isEmpty() || (groups = (group = group.replaceAll("\\{", "").replaceAll("\\}", "")).split("\\s")) == null || groups.length != 2) continue;
            macroModel.addPdMapping(groups[1], groups[0]);
        }
    }

    private ElementPath resolveScope(ElementPath currentScope, IRfDesignElement currentTopDesign, String scopeName, String hierarchySeparator, DVTTclCommandArg[] objv) {
        if (scopeName == null || scopeName.isEmpty()) {
            return currentScope;
        }
        String currentTopName = currentTopDesign.getName();
        if (scopeName.equals(currentTopName)) {
            return ElementPath.from(currentTopName, hierarchySeparator);
        }
        if (objv.length == 2) {
            ElementPath copy = ElementPath.from(currentScope.toString(hierarchySeparator), hierarchySeparator);
            copy = ElementPath.join(copy, scopeName);
            return copy;
        }
        return currentScope;
    }
}

