/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class CPFSetVersionCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.CPFVersionType currVersion;
    protected String currParsedPfFile;

    public CPFSetVersionCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getCPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String versionName = commandArgs.getCommandArg();
        this.pfModel.setCpfVersion(this.getCPFVersionFromString(versionName));
        StringBuilder messageVer = new StringBuilder("set_cpf_version ").append(versionName);
        DVTTclUtils.printToConsole("[PF (CPF)] " + messageVer, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
    }
}

