/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFIsolationCellInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class CPFUpdateIsolationRulesCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public CPFUpdateIsolationRulesCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String isolationStrategiesNames = commandArgs.getOptionValue("names");
        if (isolationStrategiesNames == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "retention_name_list", "map_retention_cell");
            return;
        }
        HashSet<DVTPFIsolationStrategyInfo> isolationStrategies = new HashSet<DVTPFIsolationStrategyInfo>();
        String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, isolationStrategiesNames);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String isolationStrategy = stringArray[n2];
            DVTPFIsolationStrategyInfo isolationStrategyInfo = this.pfModel.getIsolationStrategyByName(isolationStrategy);
            if (isolationStrategyInfo == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_ISOLATION, this.pfModel, this.currParsedPfFile, errorLine, isolationStrategy);
            } else {
                isolationStrategies.add(isolationStrategyInfo);
            }
            ++n2;
        }
        if (isolationStrategies.isEmpty()) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_NO_VALID_ISOLATION_STRATEGY, this.pfModel, this.currParsedPfFile, errorLine, new String[0]);
            return;
        }
        HashSet<DVTPFIsolationCellInfo> specifiedLibCells = new HashSet<DVTPFIsolationCellInfo>();
        String useModel = commandArgs.getOptionValue("use_model");
        HashMap<String, String> mappedPorts = new HashMap<String, String>();
        String pinMappingOption = commandArgs.getOptionValue("pin_mapping");
        if (pinMappingOption != null) {
            Matcher matcher = BRACKETS_PATTERN.matcher(pinMappingOption);
            while (matcher.find()) {
                String pair = matcher.group(1);
                String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, pair);
                if (elements.length != 2) continue;
                mappedPorts.put(elements[0], elements[1]);
            }
        }
        String prefix = commandArgs.getOptionValue("prefix");
        String suffix = commandArgs.getOptionValue("suffix");
        String openSourcePinsOnly = commandArgs.getOptionValue("open_source_pins_only");
        String withinHierarchyInstance = commandArgs.getOptionValue("within_hierarchy");
        String locationOption = commandArgs.getOptionValue("location");
        for (DVTPFIsolationStrategyInfo strategy : isolationStrategies) {
            if (strategy.isNoIsolation()) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_NO_ISOLATION, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), strategy.getStrategyName());
                continue;
            }
            TreeSet<ElementPath> elements = strategy.getElements();
            for (ElementPath elementPath : elements) {
                strategy.mapIsolationCells(elementPath, specifiedLibCells);
            }
            if (useModel != null) {
                strategy.setUseModel();
            }
            strategy.setMappedPort(mappedPorts);
            if (suffix != null) {
                strategy.setNameSufix(suffix);
            }
            if (prefix != null) {
                strategy.setNamePrefix(prefix);
            }
            if (openSourcePinsOnly != null) {
                strategy.setOpenSourcePinsOnly();
            }
            if (withinHierarchyInstance != null) {
                strategy.setWithinHierarchyInstance(withinHierarchyInstance);
            }
            DVTPFIsolationStrategyInfo.CPFValidLocation location = strategy.isForceIsolation() ? DVTPFIsolationStrategyInfo.CPFValidLocation.SELF : DVTPFIsolationStrategyInfo.CPFValidLocation.TO;
            if (locationOption != null) {
                try {
                    location = DVTPFIsolationStrategyInfo.CPFValidLocation.valueOf(locationOption.toUpperCase());
                }
                catch (Exception exception) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, locationOption, "location");
                }
            }
            strategy.setCPFLocation(location);
        }
    }

    private void computeLibCells(Set<DVTPFIsolationCellInfo> specifiedLibCells, String libCells) {
        String[] cells = DVTStringUtil.split(WHITESPACE_PATTERN, libCells);
        if (cells == null || cells.length == 0) {
            return;
        }
        String[] stringArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            String libCell = stringArray[n2];
            if (!libCell.trim().isEmpty()) {
                DVTPFIsolationCellInfo isolationCellInfo = this.pfModel.getIsolationCellByName(libCell.trim());
                if (isolationCellInfo == null) {
                    isolationCellInfo = new DVTPFIsolationCellInfo(libCell, null, null);
                }
                specifiedLibCells.add(isolationCellInfo);
            }
            ++n2;
        }
    }
}

