/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.cpf.DVTCPFMacroModel;
import ro.amiq.dvt.power.format.cpf.DVTCPFSupplyNetInfo;
import ro.amiq.dvt.power.format.cpf.DVTCPFSupplyPortInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class CPFUpdatePowerDomainCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.CPFVersionType currVersion;
    protected String currParsedPfFile;

    public CPFUpdatePowerDomainCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String primaryGround;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getCPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String domainName = commandArgs.getOptionValue("name");
        if (domainName == null) {
            return;
        }
        DVTPFInfo pdInfoForPDName = null;
        DVTCPFMacroModel macroModel = this.pfModel.getMacroModel(this.pfModel.getCurrMacroModel());
        pdInfoForPDName = macroModel != null ? macroModel.getPFInfo(domainName) : this.pfModel.getPDInfoForPDName(domainName);
        if (pdInfoForPDName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, domainName);
            return;
        }
        String primaryPower = commandArgs.getOptionValue("internal_power_net");
        String string = primaryPower = primaryPower == null ? commandArgs.getOptionValue("primary_power_net") : primaryPower;
        if (primaryPower != null) {
            this.addSupplyInfo(domainName, primaryPower, pdInfoForPDName, false);
        }
        String string2 = primaryGround = (primaryGround = commandArgs.getOptionValue("internal_ground_net")) == null ? commandArgs.getOptionValue("primary_ground_net") : primaryGround;
        if (primaryGround != null) {
            this.addSupplyInfo(domainName, primaryGround, pdInfoForPDName, true);
        }
    }

    private void addSupplyInfo(String domainName, String netName, DVTPFInfo pdInfoForPDName, boolean isGround) {
        String direction;
        if (pdInfoForPDName == null) {
            return;
        }
        DVTPFSupplyNetInfo supplyNetInfo = this.pfModel.getSupplyNetInfo(netName);
        if (!(supplyNetInfo instanceof DVTCPFSupplyNetInfo)) {
            supplyNetInfo = new DVTCPFSupplyNetInfo(netName, isGround ? "ground" : "power");
            supplyNetInfo.addGoToInfo("Implicit net", -1, -1);
            this.pfModel.addSupplyNet(supplyNetInfo);
        }
        DVTPFSupplyPortInfo supplyPortInfo = this.pfModel.getSupplyPortInfo(netName);
        DVTCPFSupplyPortInfo newPort = null;
        String string = direction = isGround ? "out" : "in";
        if (supplyPortInfo == null) {
            newPort = new DVTCPFSupplyPortInfo(netName, netName, netName, direction, domainName);
            newPort.addGoToInfo("Implicit port", -1, -1);
            if (this.pfModel.getCurrMacroModel() == null) {
                this.pfModel.addExplicityCreatedSupplyPort(newPort);
            }
        } else {
            newPort = new DVTCPFSupplyPortInfo(supplyPortInfo.getNetName(), supplyPortInfo.getPortName(), supplyPortInfo.getNetName(), direction, domainName);
            newPort.setGotoInfos(supplyPortInfo.getGotoInfos());
        }
        if (this.pfModel.getCurrMacroModel() == null) {
            supplyNetInfo.connectToPort(newPort);
        }
        DVTCPFSupplyPortInfo primaySupplyPort = new DVTCPFSupplyPortInfo(newPort.getNetName(), newPort.getPortName(), newPort.getNetName(), direction, domainName);
        primaySupplyPort.setGotoInfos(newPort.getGotoInfos());
        if (isGround) {
            pdInfoForPDName.setPrimaryGroundSupply(primaySupplyPort);
        } else {
            pdInfoForPDName.setPrimaryPowerSupply(primaySupplyPort);
        }
    }
}

