/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionCellInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class CPFUpdateStateRetentionRulesCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public CPFUpdateStateRetentionRulesCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String retentionNameList = commandArgs.getOptionValue("names");
        if (retentionNameList == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "retention_name_list", "map_retention_cell");
            return;
        }
        HashSet<DVTPFRetentionRuleInfo> retentionRules = new HashSet<DVTPFRetentionRuleInfo>();
        String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, retentionNameList);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String retentionStrategy = stringArray[n2];
            DVTPFRetentionRuleInfo retentionRule = this.pfModel.getRetentionRuleByName(retentionStrategy);
            if (retentionRule == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_RETENTION, this.pfModel, this.currParsedPfFile, errorLine, retentionStrategy);
            } else {
                retentionRules.add(retentionRule);
            }
            ++n2;
        }
        if (retentionRules.isEmpty()) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_NO_VALID_RETENTION_RULE, this.pfModel, this.currParsedPfFile, errorLine, new String[0]);
            return;
        }
        HashSet<DVTPFRetentionCellInfo> retentionCells = new HashSet<DVTPFRetentionCellInfo>();
        String libCellsType = commandArgs.getOptionValue("lib_cell_type");
        if (libCellsType != null && this.pfModel.getRetentionCellsByType(libCellsType) == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNRESOLVED_PATH, this.pfModel, this.currParsedPfFile, errorLine, libCellsType);
            return;
        }
        String resetControl = commandArgs.getOptionValue("set_reset_control");
        String useModel = commandArgs.getOptionValue("use_model");
        HashMap<String, String> mappedPorts = new HashMap<String, String>();
        this.mapRetentionCells(retentionRules, retentionCells, resetControl, useModel, mappedPorts);
    }

    private void computeExtraCellInfo(DVTCommandResult commandArgs, Set<DVTPFRetentionCellInfo> retentionCells, String libCellsType, HashMap<String, String> mappedPorts) {
        HashSet<String> specifiedLibCells = new HashSet<String>();
        String cells = commandArgs.getOptionValue("cells");
        if (cells != null) {
            this.computeLibCells(specifiedLibCells, cells);
        }
        this.computeRetentionCells(specifiedLibCells, retentionCells, libCellsType);
        String pinMappingOption = commandArgs.getOptionValue("pin_mapping");
        if (pinMappingOption != null) {
            Matcher matcher = BRACKETS_PATTERN.matcher(pinMappingOption);
            while (matcher.find()) {
                String pair = matcher.group(1);
                String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, pair);
                if (elements.length != 2) continue;
                mappedPorts.put(elements[0], elements[1]);
            }
        }
    }

    private void computeRetentionCells(Set<String> specifiedLibCells, Set<DVTPFRetentionCellInfo> retentionCells, String libCellsType) {
        if (!specifiedLibCells.isEmpty()) {
            for (String libCell : specifiedLibCells) {
                DVTPFRetentionCellInfo retentionCellInfo = this.pfModel.getRetentionCellByName(libCell.trim());
                if (retentionCellInfo == null) {
                    retentionCellInfo = new DVTPFRetentionCellInfo(libCell, null, null);
                }
                retentionCells.add(retentionCellInfo);
            }
            return;
        }
        if (libCellsType == null) {
            return;
        }
        Set<DVTPFRetentionCellInfo> retentionCellsByType = this.pfModel.getRetentionCellsByType(libCellsType);
        if (retentionCellsByType == null || retentionCellsByType.isEmpty()) {
            return;
        }
        retentionCells.addAll(retentionCellsByType);
    }

    private void computeLibCells(Set<String> specifiedLibCells, String libCells) {
        String[] cells = DVTStringUtil.split(WHITESPACE_PATTERN, libCells);
        if (cells == null || cells.length == 0) {
            return;
        }
        String[] stringArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            String libCell = stringArray[n2];
            if (!libCell.trim().isEmpty()) {
                specifiedLibCells.add(libCell.trim());
            }
            ++n2;
        }
    }

    private void mapRetentionCells(Set<DVTPFRetentionRuleInfo> retentionRules, Set<DVTPFRetentionCellInfo> cellsOfInterest, String resetControl, String useModel, HashMap<String, String> mappedPorts) {
        if (retentionRules == null) {
            return;
        }
        for (DVTPFRetentionRuleInfo rule : retentionRules) {
            if (rule.isNoRetention()) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_MAPPING_OPTION, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), rule.getRuleName());
                continue;
            }
            if (rule.getElements() != null) continue;
        }
    }

    private void performMapping(Set<DVTPFRetentionCellInfo> cellsOfInterest, String resetControl, String useModel, HashMap<String, String> mappedPorts, DVTPFRetentionRuleInfo rule) {
        for (ElementPath elementPath : rule.getElements()) {
            rule.mapRetentionCells(elementPath, cellsOfInterest);
        }
        if (resetControl != null) {
            rule.setResetControl();
        }
        if (useModel != null) {
            rule.setUseModel();
        }
        rule.setMappedPort(mappedPorts);
    }
}

