/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.cpf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.cpf.DVTCPFSupplyNetInfo;
import ro.amiq.dvt.power.format.cpf.DVTCPFSupplyPortInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;

public class DVTCPFMacroModel {
    private String macroModelName;
    private String instanceName;
    private String currParsedFile;
    private int errorLine;
    private Map<String, DVTPFInfo> pfInfos;
    private Map<String, List<String>> pdMapping;

    public DVTCPFMacroModel(String macroModelName, String currParsedFile, int errorLine) {
        this.macroModelName = macroModelName;
        this.errorLine = errorLine;
        this.currParsedFile = currParsedFile;
        this.pdMapping = new HashMap<String, List<String>>();
        this.pfInfos = new HashMap<String, DVTPFInfo>();
    }

    public void addPFInfo(DVTPFInfo pfInfo) {
        if (pfInfo == null) {
            return;
        }
        String pdName = pfInfo.getPowerDomainName();
        if (pdName == null) {
            return;
        }
        this.pfInfos.put(pdName, pfInfo);
    }

    public void addPdMapping(String domainName, String mappedDomainName) {
        if (!this.pdMapping.containsKey(domainName)) {
            this.pdMapping.put(domainName, new ArrayList());
        }
        this.pdMapping.get(domainName).add(mappedDomainName);
    }

    public String getMacroModelName() {
        return this.macroModelName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public DVTPFInfo getPFInfo(String name) {
        return this.pfInfos.get(name);
    }

    public void resolveMacroModel(DVTPFModel pfModel) {
        for (Map.Entry<String, List<String>> entry : this.pdMapping.entrySet()) {
            String parentPDName = entry.getKey();
            DVTPFInfo parentPDInfo = pfModel.getPDInfoForPDName(parentPDName);
            if (parentPDInfo == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, pfModel, this.currParsedFile, this.errorLine, parentPDName);
                continue;
            }
            DVTPFSupplyPortInfo parentGround = parentPDInfo.getPrimaryGroundSupply();
            DVTPFSupplyPortInfo parentPower = parentPDInfo.getPrimaryPowerSupply();
            for (String childPdName : entry.getValue()) {
                DVTPFInfo childPDInfo = this.pfInfos.get(childPdName);
                if (childPDInfo == null) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, pfModel, this.currParsedFile, this.errorLine, childPdName);
                    continue;
                }
                DVTPFSupplyPortInfo childGround = childPDInfo.getPrimaryGroundSupply();
                DVTPFSupplyPortInfo childPower = childPDInfo.getPrimaryPowerSupply();
                if ((parentGround == null || parentPower == null) && childGround != null && childPower != null) {
                    parentGround = new DVTCPFSupplyPortInfo(childGround.getNetName(), childGround.getPortName(), childGround.getNetName(), childGround.getDirection(), parentPDName);
                    parentGround.setGotoInfos(childGround.getGotoInfos());
                    parentPower = new DVTCPFSupplyPortInfo(childPower.getNetName(), childPower.getPortName(), childGround.getNetName(), childPower.getDirection(), parentPDName);
                    parentPower.setGotoInfos(childPower.getGotoInfos());
                    this.connectPortToExistingNet(parentGround, pfModel, true);
                    this.connectPortToExistingNet(parentPower, pfModel, false);
                    parentPDInfo.setPrimaryGroundSupply(parentGround);
                    parentPDInfo.setPrimaryPowerSupply(parentPower);
                }
                List<String> domains = pfModel.getDomainsForBaseDomain(childPdName);
                pfModel.getBaseDomains().remove(childPdName);
                pfModel.addToBaseDomain(parentPDName, domains);
                this.pfInfos.remove(childPdName);
                String childPDLabel = String.valueOf(childPdName) + " -model " + this.getMacroModelName() + " -instance " + this.getInstanceName();
                parentPDInfo.addMappedCPFPdLabel(childPDLabel);
            }
        }
        for (Map.Entry<String, Object> entry : this.pfInfos.entrySet()) {
            String pdName = entry.getKey();
            DVTPFInfo pfInfo = (DVTPFInfo)entry.getValue();
            String baseDomain = pfModel.removeFromBaseDomain(pdName);
            String mappingForBaseDomain = this.getMappingForDomain(baseDomain, pfModel);
            if (mappingForBaseDomain != null) {
                baseDomain = mappingForBaseDomain;
            }
            pfInfo.setName(String.valueOf(pdName) + " -model " + this.getMacroModelName() + " -instance " + this.instanceName);
            if (baseDomain != null) {
                pfModel.addToBaseDomain(baseDomain, pfInfo.getPowerDomainName());
            }
            pfModel.addPfInfo(pfInfo.getPowerDomainName(), pfInfo);
        }
    }

    private String getMappingForDomain(String baseDomain, DVTPFModel pfModel) {
        if (baseDomain == null) {
            return null;
        }
        if (pfModel.getPDInfoForPDName(baseDomain) != null) {
            return null;
        }
        for (Map.Entry<String, List<String>> entry : this.pdMapping.entrySet()) {
            String domain = entry.getKey();
            if (!entry.getValue().contains(baseDomain)) continue;
            return domain;
        }
        return null;
    }

    private void connectPortToExistingNet(DVTPFSupplyPortInfo port, DVTPFModel pfModel, boolean isGround) {
        String direction;
        String netName = port.getNetName();
        String domainName = port.getDomainName();
        DVTPFSupplyNetInfo supplyNetInfo = pfModel.getSupplyNetInfo(netName);
        if (!(supplyNetInfo instanceof DVTCPFSupplyNetInfo)) {
            supplyNetInfo = new DVTCPFSupplyNetInfo(netName, isGround ? "ground" : "power");
            supplyNetInfo.addGoToInfo("Implicit net", -1, -1);
            pfModel.addSupplyNet(supplyNetInfo);
        }
        DVTPFSupplyPortInfo supplyPortInfo = pfModel.getSupplyPortInfo(netName);
        DVTCPFSupplyPortInfo newPort = null;
        String string = direction = isGround ? "out" : "in";
        if (supplyPortInfo == null) {
            newPort = new DVTCPFSupplyPortInfo(netName, netName, netName, direction, domainName);
            newPort.addGoToInfo("Implicit port", -1, -1);
            pfModel.addExplicityCreatedSupplyPort(newPort);
        } else {
            newPort = new DVTCPFSupplyPortInfo(supplyPortInfo.getNetName(), supplyPortInfo.getPortName(), supplyPortInfo.getNetName(), direction, supplyPortInfo.getDomainName());
            newPort.setGotoInfos(supplyPortInfo.getGotoInfos());
        }
        supplyNetInfo.connectToPort(port);
    }
}

