/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.PfType;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySet;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySetFunction;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class UPFCreatePowerDomainCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.UPFVersionType currVersion;
    protected String currParsedPfFile;

    public UPFCreatePowerDomainCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String supplySetInfo;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        PfType upf = PfType.UPF;
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String powerDomainName = commandArgs.getCommandArg();
        String elements = commandArgs.getOptionValue("elements");
        String excludeElements = commandArgs.getOptionValue("exclude_elements");
        boolean includeScope = this.transformCommandOptionInBoolean("include_scope", commandArgs);
        if (powerDomainName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "name", "create_power_domain");
            return;
        }
        if (EnumSet.of(DVTPFModel.UPFVersionType.v1_0, DVTPFModel.UPFVersionType.v2_0, DVTPFModel.UPFVersionType.v2_1).contains(this.currVersion)) {
            String scopeString = commandArgs.getOptionValue("scope");
            ElementPath scopePath = ElementPath.from(scopeString, this.currHierarchySeparator);
            ElementPath elementPath = this.currScope = this.currScope.isPrefixOf(scopePath = DVTPFUtils.removeGenBracketsFromPath(scopePath)) || this.currScope.equals(scopePath) ? scopePath : ElementPath.join(this.currScope, Arrays.asList(scopePath.getSegments()));
        }
        if (elements == null || elements.isEmpty()) {
            if (EnumSet.of(DVTPFModel.UPFVersionType.v1_0, DVTPFModel.UPFVersionType.v2_0, DVTPFModel.UPFVersionType.v2_1, DVTPFModel.UPFVersionType.v2_2).contains(this.currVersion)) {
                elements = ".";
            } else {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "-elements", "create_power_domain");
            }
        }
        StringBuilder message = new StringBuilder("create_power_domain ").append(powerDomainName).append(" ...");
        DVTTclUtils.printToConsole("[PF (UPF)] " + message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
        if (elements != null && !elements.isEmpty()) {
            this.resolveElements(this.currTopDesign, powerDomainName, elements, this.currScope, upf);
        } else if (EnumSet.of(DVTPFModel.UPFVersionType.v1_0, DVTPFModel.UPFVersionType.v2_0, DVTPFModel.UPFVersionType.v2_1).contains(this.currVersion) && includeScope) {
            this.resolveElements(this.currTopDesign, powerDomainName, ".", this.currScope, upf);
        }
        if (excludeElements != null && !excludeElements.isEmpty()) {
            this.resolveExcludeElements(this.currTopDesign, excludeElements, this.currScope);
        }
        if ((supplySetInfo = commandArgs.getOptionValue("supply")) != null) {
            this.addSupplySet(supplySetInfo, powerDomainName, errorLine);
        }
    }

    private void addSupplySet(String supplySetInfo, String pdName, int errorLine) {
        DVTPFInfo pfInfo = this.pfModel.getPDInfoForPDName(pdName);
        if (pfInfo == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
            return;
        }
        String[] supplySetInfoArray = supplySetInfo.split("\\s");
        if (supplySetInfoArray == null || supplySetInfoArray.length != 2) {
            return;
        }
        String supplySetHandle = supplySetInfoArray[0];
        String supplySetRef = supplySetInfoArray[1];
        if (supplySetHandle == null || supplySetRef == null) {
            return;
        }
        DVTUPFSupplySet supplySet = this.pfModel.getSupplySet(supplySetRef);
        if (supplySet == null) {
            return;
        }
        List<DVTUPFSupplySetFunction> functions = supplySet.getFunctions();
        for (DVTUPFSupplySetFunction function : functions) {
            String functionName = function.getName();
            String netName = function.getNetName();
            if ("power".equals(functionName) && "ground".equals(functionName)) continue;
            DVTPFUtils.addSupplyPort(netName, pfInfo, this.pfModel, "ground".equals(functionName));
        }
    }
}

