/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFPowerSwitchInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyNetInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyPortInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class UPFCreatePowerSwitchCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.UPFVersionType currVersion;
    protected String currParsedPfFile;

    public UPFCreatePowerSwitchCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String ackPortName;
        String[] ackPortList;
        String ackNetName;
        DVTUPFSupplyPortInfo ackPort;
        String inputPortName;
        String[] inputPortList;
        String inputNetName;
        DVTUPFSupplyPortInfo inputPort;
        String outputPortName;
        String[] outputPortList;
        String outputNetName;
        DVTUPFSupplyPortInfo outputPort;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String switchName = commandArgs.getCommandArg();
        DVTUPFPowerSwitchInfo powerSwitchInfo = new DVTUPFPowerSwitchInfo(switchName, this.currParsedPfFile, errorLine, this.args[this.args.length - 1].getArgLine());
        String pdName = commandArgs.getOptionValue("domain");
        if (pdName != null && this.pfModel.getPDInfoForPDName(pdName) == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
        }
        if ((outputPort = this.createPort(outputNetName = this.getInfoFromString(outputPortList = this.getPortList("output_supply_port", commandArgs), false), String.valueOf(outputPortName = this.getInfoFromString(outputPortList, true)) + "\n(output supply)", "out", switchName, DVTPFUtils.getArgLine(this.args, "-output_supply_port"))) != null) {
            powerSwitchInfo.setOutputPort(outputPort);
        }
        if ((inputPort = this.createPort(inputNetName = this.getInfoFromString(inputPortList = this.getPortList("input_supply_port", commandArgs), false), String.valueOf(inputPortName = this.getInfoFromString(inputPortList, true)) + "\n(input supply)", "in", switchName, DVTPFUtils.getArgLine(this.args, "-input_supply_port"))) != null) {
            powerSwitchInfo.setInputPort(inputPort);
        }
        String[] controlPortList = this.getPortList("control_port", commandArgs);
        String controlNetName = String.valueOf(this.currScope.toString(this.currHierarchySeparator)) + this.currHierarchySeparator + this.getInfoFromString(controlPortList, false);
        String controlPortName = this.getInfoFromString(controlPortList, true);
        DVTUPFSupplyPortInfo controlPort = this.createPort(null, String.valueOf(controlPortName) + " - " + controlNetName + "\n(control)", "in", switchName, DVTPFUtils.getArgLine(this.args, "-control_port"));
        if (controlPort != null) {
            String labelFormat = String.valueOf(controlPortName) + " - {0}\n(control)";
            powerSwitchInfo.setControlPort(controlPort);
            this.addControlSignalGotoInfo(this.currTopDesign, controlNetName, this.currHierarchySeparator, controlPort, labelFormat);
        }
        if ((ackPort = this.createPort(ackNetName = this.getInfoFromString(ackPortList = this.getPortList("ack_port", commandArgs), false), String.valueOf(ackPortName = this.getInfoFromString(ackPortList, true)) + "\n(ack)", "in", switchName, DVTPFUtils.getArgLine(this.args, "-ack_port"))) != null) {
            powerSwitchInfo.setAckPort(ackPort);
        }
        this.pfModel.addPowerSwitch(powerSwitchInfo);
    }

    private DVTUPFSupplyPortInfo createPort(String netName, String portName, String direction, String domainName, int line) {
        DVTUPFSupplyPortInfo newSupplyPort = null;
        if (netName == null) {
            DVTUPFSupplyPortInfo portInfo = new DVTUPFSupplyPortInfo(netName, portName, portName, direction, domainName);
            portInfo.addGoToInfo(this.currParsedPfFile, line, line);
            return portInfo;
        }
        DVTPFSupplyNetInfo supplyNetInfo = this.pfModel.getSupplyNetInfo(netName);
        if (!(supplyNetInfo instanceof DVTUPFSupplyNetInfo)) {
            return null;
        }
        DVTPFSupplyPortInfo portConnectionForNetName = this.pfModel.getPortConnectionForNetName(netName, domainName);
        if (portConnectionForNetName == null) {
            newSupplyPort = new DVTUPFSupplyPortInfo(netName, portName, portName, direction, domainName);
            newSupplyPort.addGoToInfo(this.currParsedPfFile, line, line);
        } else {
            newSupplyPort = new DVTUPFSupplyPortInfo(netName, portConnectionForNetName.getPortName(), portName, direction, domainName);
            newSupplyPort.addGoToInfo(this.currParsedPfFile, line, line);
        }
        ((DVTUPFSupplyNetInfo)supplyNetInfo).connectToPort(newSupplyPort);
        return newSupplyPort;
    }
}

