/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyNetInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyPortInfo;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class UPFCreateSupplyNetCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.UPFVersionType currVersion;
    protected String currParsedPfFile;

    public UPFCreateSupplyNetCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String netName = commandArgs.getCommandArg();
        String domainName = commandArgs.getOptionValue("domain");
        boolean isReuse = this.transformCommandOptionInBoolean("reuse", commandArgs);
        String resolveStrategy = commandArgs.getOptionValue("resolve");
        DVTPFSupplyNetInfo supplyNetInfo = this.pfModel.getSupplyNetInfo(netName);
        if (supplyNetInfo == null) {
            supplyNetInfo = new DVTUPFSupplyNetInfo(netName, resolveStrategy, isReuse);
            this.pfModel.addSupplyNet(supplyNetInfo);
        }
        if (!(supplyNetInfo instanceof DVTUPFSupplyNetInfo)) {
            return;
        }
        supplyNetInfo.addGoToInfo(this.currParsedPfFile, this.args[0].getArgLine(), this.args[this.args.length - 1].getArgLine());
        DVTPFSupplyPortInfo supplyPortInfo = this.pfModel.getExplicityCreatedSupplyPort(netName);
        if (supplyPortInfo == null) {
            supplyPortInfo = new DVTUPFSupplyPortInfo(netName, netName, netName, "in", domainName);
            supplyPortInfo.addGoToInfo("Implicit port", -1, -1);
            this.pfModel.addImplicitSupplyPort(supplyPortInfo);
        }
    }
}

