/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyPortInfo;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class UPFCreateSupplyPortCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.UPFVersionType currVersion;
    protected String currParsedPfFile;

    public UPFCreateSupplyPortCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        DVTPFInfo pdInfo;
        String directionName;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String portName = commandArgs.getCommandArg();
        String domainName = commandArgs.getOptionValue("domain");
        String directionOptionValue = commandArgs.getOptionValue("direction");
        String string = directionName = directionOptionValue == null || directionOptionValue.isEmpty() ? "in" : directionOptionValue;
        if ((domainName == null || domainName.isEmpty()) && (pdInfo = this.pfModel.getPDInfoForInstance(this.currScope)) != null) {
            domainName = pdInfo.getPowerDomainName();
        }
        DVTUPFSupplyPortInfo supplyPortInfo = new DVTUPFSupplyPortInfo(portName, portName, portName, directionName, domainName);
        supplyPortInfo.addGoToInfo(this.currParsedPfFile, this.args[0].getArgLine(), this.args[this.args.length - 1].getArgLine());
        this.pfModel.addExplicityCreatedSupplyPort(supplyPortInfo);
    }
}

