/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import java.util.List;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySet;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class UPFCreateSupplySetCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.UPFVersionType currVersion;
    protected String currParsedPfFile;

    public UPFCreateSupplySetCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String setName = commandArgs.getCommandArg();
        if (setName == null) {
            return;
        }
        DVTUPFSupplySet upfSupplySet = new DVTUPFSupplySet(setName);
        List<String> functions = commandArgs.getAllOptionValues("function");
        if (functions == null) {
            return;
        }
        for (String function : functions) {
            String[] functionArgs = function.split("\\s");
            if (functionArgs == null || functionArgs.length != 2) continue;
            String functionName = functionArgs[0];
            String netName = functionArgs[1];
            if (functionName == null || netName == null) continue;
            upfSupplySet.addSupplySetFunction(functionName, netName);
        }
        this.pfModel.addSupplySet(upfSupplySet);
    }
}

