/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFParsedFiles;
import ro.amiq.dvt.power.format.DVTPFResetScopeScopeDummyCommand;
import ro.amiq.dvt.power.format.DVTPFResetVersionDummyCommand;
import ro.amiq.dvt.power.format.DVTPFSetCurrentFileDummyCommand;
import ro.amiq.dvt.power.format.DVTPFSetScopeDummyCommand;
import ro.amiq.dvt.power.format.DVTPFSetVersionDummyCommand;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class UPFLoadUpfCommand
extends DVTPFCommand {
    protected String currParsedPfFile;
    private boolean shouldPopVersionCommand;
    private boolean shouldPopScopeCommand;

    public UPFLoadUpfCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        try {
            String newVersionString;
            String[] elementsArray;
            super.cmdProc(interp, objv);
            if (this.pfModel == null || this.args == null || this.args.length == 0) {
                return;
            }
            this.args[0].getArgLine();
            this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
            DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
            if (commandArgs == null) {
                return;
            }
            ArrayList<String> instanceList = new ArrayList<String>();
            String loadedFile = commandArgs.getCommandArg();
            String instanceNames = commandArgs.getOptionValue("scope");
            if (instanceNames != null && (elementsArray = instanceNames.split(" ")) != null) {
                instanceList.addAll(Arrays.asList(elementsArray));
            }
            if ((newVersionString = commandArgs.getOptionValue("version")) != null && !newVersionString.isEmpty()) {
                DVTPFModel.UPFVersionType newVersion = this.getUPFVersionFromString(newVersionString);
                this.shouldPopVersionCommand = true;
                this.pfModel.addPfCommand(new DVTPFSetVersionDummyCommand(newVersion, this.pfModel));
            }
            if (loadedFile == null || loadedFile.isEmpty()) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, interp.scriptFile, this.args[0].getArgLine(), "filename", "load_upf");
                return;
            }
            if (!Path.fromOSString((String)loadedFile).isAbsolute()) {
                loadedFile = new File(interp.getWorkingDir(), loadedFile).getAbsolutePath();
            }
            DVTPFParsedFiles pfInclude = new DVTPFParsedFiles();
            pfInclude.including = interp.scriptFile;
            pfInclude.included = loadedFile;
            pfInclude.offset = interp.getOffset(objv[0]);
            pfInclude.includeCommand = this.args[0].getArgName();
            this.pfModel.addPfParsedFile(pfInclude);
            String message = "    TCL load_upf " + pfInclude.including + " @ " + this.args[0].getArgLine() + " : sourcing " + pfInclude.included;
            if (instanceList.isEmpty()) {
                this.pfModel.addPfCommand(new DVTPFSetCurrentFileDummyCommand(loadedFile, this.pfModel));
                DVTTclUtils.printToConsole(message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.TCL_DEBUG_INFO, this.pfModel.isDebugMode());
                interp.evalFile(loadedFile);
                this.resetElementsAfterLoadUpf();
                return;
            }
            this.shouldPopScopeCommand = true;
            for (String instance : instanceList) {
                this.pfModel.addPfCommand(new DVTPFSetScopeDummyCommand(instance, this.pfModel));
                this.pfModel.addPfCommand(new DVTPFSetCurrentFileDummyCommand(loadedFile, this.pfModel));
                DVTTclUtils.printToConsole(message, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.TCL_DEBUG_INFO, this.pfModel.isDebugMode());
                StringBuilder debugM = new StringBuilder("load_upf ... -scope ").append(instance).append(" ...");
                DVTTclUtils.printToConsole("[PF (UPF)] " + debugM, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
                interp.evalFile(loadedFile);
                this.resetElementsAfterLoadUpf();
            }
        }
        catch (TclException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void resetElementsAfterLoadUpf() {
        if (this.shouldPopVersionCommand) {
            this.pfModel.addPfCommand(new DVTPFResetVersionDummyCommand(this.pfModel));
        }
        if (this.shouldPopScopeCommand) {
            this.pfModel.addPfCommand(new DVTPFResetScopeScopeDummyCommand(this.pfModel));
        }
    }

    @Override
    public void executeCommand() {
        StringBuilder messageVer = new StringBuilder("load_upf ... -version ").append(this.pfModel.getUPFVersion().name()).append(" ...");
        DVTTclUtils.printToConsole("[PF (UPF)] " + messageVer, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
    }
}

