/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationCellInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class UPFMapIsolationCellCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public UPFMapIsolationCellCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        DVTPFInfo pdInfoForPDName;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        if (!EnumSet.of(DVTPFModel.UPFVersionType.v2_0, DVTPFModel.UPFVersionType.v1_0).contains(this.currVersion)) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_DEPRECATED_COMMAND, this.pfModel, this.currParsedPfFile, errorLine, "map_isolation_cell");
            return;
        }
        String isolationName = commandArgs.getCommandArg();
        if (isolationName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "isolation_name", "map_retention_cell");
            return;
        }
        String pdName = commandArgs.getOptionValue("domain");
        DVTPFInfo dVTPFInfo = pdInfoForPDName = pdName != null ? this.pfModel.getPDInfoForPDName(pdName) : null;
        if (pdInfoForPDName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
            return;
        }
        DVTPFIsolationStrategyInfo isolationStrategy = pdInfoForPDName.getIsolationStrategyByName(isolationName);
        if (isolationStrategy == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_ISOLATION, this.pfModel, this.currParsedPfFile, errorLine, isolationName, pdName);
            return;
        }
        TreeSet<ElementPath> specifiedElements = new TreeSet<ElementPath>();
        HashSet<DVTPFIsolationCellInfo> specifiedLibCells = new HashSet<DVTPFIsolationCellInfo>();
        this.mapIsolationCells(isolationStrategy, specifiedElements, specifiedLibCells);
    }

    private void computeExtraInfo(DVTCommandResult commandArgs, DVTPFInfo pdInfoForPDName, TreeSet<ElementPath> specifiedElements, Set<DVTPFIsolationCellInfo> specifiedLibCells) {
        String libModelName;
        String libCells;
        String elementList = commandArgs.getOptionValue("elements");
        if (elementList != null) {
            this.computeElements(elementList, specifiedElements);
        }
        if ((libCells = commandArgs.getOptionValue("lib_cells")) != null) {
            this.computeLibCells(specifiedLibCells, libCells);
        }
        if ((libModelName = commandArgs.getOptionValue("lib_model_name")) != null) {
            this.addLibModel(commandArgs, pdInfoForPDName, libModelName);
        }
    }

    private void mapIsolationCells(DVTPFIsolationStrategyInfo isolationStrategy, TreeSet<ElementPath> specifiedElements, Set<DVTPFIsolationCellInfo> cellsOfInterest) {
        if (isolationStrategy.isNoIsolation()) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_MAPPING_OPTION, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), isolationStrategy.getStrategyName());
            return;
        }
        if (isolationStrategy.getElements() == null) {
            return;
        }
    }

    private void performMapping(DVTPFIsolationStrategyInfo isolationStrategy, TreeSet<ElementPath> specifiedElements, Set<DVTPFIsolationCellInfo> cellsOfInterest) {
        TreeSet<ElementPath> elements = isolationStrategy.getElements();
        TreeSet<ElementPath> workingSet = new TreeSet<ElementPath>();
        if (specifiedElements.isEmpty()) {
            workingSet.addAll(elements);
        }
        for (ElementPath element : specifiedElements) {
            ElementPath greaterChildKey = ElementPath.join(element, "{");
            NavigableSet<ElementPath> subset = elements.subSet(element, true, greaterChildKey, false);
            workingSet.addAll(subset);
        }
        for (ElementPath elementPath : workingSet) {
            isolationStrategy.mapIsolationCells(elementPath, cellsOfInterest);
        }
    }

    private void computeElements(String elementList, TreeSet<ElementPath> specifiedElements) {
        String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, elementList);
        if (elements == null || elements.length == 0) {
            return;
        }
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                element = this.replaceSeparators(element, this.pfModel.getHierarchySeparator());
                ElementPath instancePath = this.computeInstancePathFromElement(element, this.currScope);
                specifiedElements.add(instancePath);
            }
            ++n2;
        }
    }

    private void computeLibCells(Set<DVTPFIsolationCellInfo> specifiedLibCells, String libCells) {
        String[] cells = DVTStringUtil.split(WHITESPACE_PATTERN, libCells);
        if (cells == null || cells.length == 0) {
            return;
        }
        String[] stringArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            DVTPFIsolationCellInfo isolationCell;
            String libCell = stringArray[n2];
            String libCellName = libCell.trim();
            if (!libCellName.isEmpty() && (isolationCell = this.pfModel.getIsolationCellByName(libCellName)) != null) {
                specifiedLibCells.add(isolationCell);
            }
            ++n2;
        }
    }

    private void addLibModel(DVTCommandResult commandArgs, DVTPFInfo pdInfoForPDName, String libModelName) {
        String portMap = commandArgs.getOptionValue("port");
        if (portMap == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), "port", "lib_model_name");
            return;
        }
        HashMap<String, String> mappedPorts = new HashMap<String, String>();
        Matcher matcher = BRACKETS_PATTERN.matcher(portMap);
        while (matcher.find()) {
            String pair = matcher.group(1);
            String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, pair);
            if (elements.length != 2) continue;
            mappedPorts.put(elements[0], elements[1]);
        }
        pdInfoForPDName.addLibModelByName(libModelName, mappedPorts);
    }
}

