/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import java.util.HashMap;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionCellInfo;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class UPFMapRetentionCellCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public UPFMapRetentionCellCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        DVTPFInfo pdInfoForPDName;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String retentionNameList = commandArgs.getCommandArg();
        if (retentionNameList == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "retention_name_list", "map_retention_cell");
            return;
        }
        String pdName = commandArgs.getOptionValue("domain");
        DVTPFInfo dVTPFInfo = pdInfoForPDName = pdName != null ? this.pfModel.getPDInfoForPDName(pdName) : null;
        if (pdInfoForPDName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
            return;
        }
        HashSet<DVTPFRetentionRuleInfo> retentionRules = new HashSet<DVTPFRetentionRuleInfo>();
        String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, retentionNameList);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String retentionStrategy = stringArray[n2];
            DVTPFRetentionRuleInfo retentionRule = pdInfoForPDName.getRetentionRuleByName(retentionStrategy);
            if (retentionRule == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_RETENTION_FOR_PD, this.pfModel, this.currParsedPfFile, errorLine, retentionStrategy, pdName);
            } else {
                retentionRules.add(retentionRule);
            }
            ++n2;
        }
        if (retentionRules.isEmpty()) {
            return;
        }
        HashSet<DVTPFRetentionCellInfo> retentionCells = new HashSet<DVTPFRetentionCellInfo>();
        String libCellsType = commandArgs.getOptionValue("lib_cell_type");
        if (libCellsType != null && this.pfModel.getRetentionCellsByType(libCellsType) == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNRESOLVED_PATH, this.pfModel, this.currParsedPfFile, errorLine, libCellsType, pdName);
            return;
        }
        TreeSet<ElementPath> specifiedElements = new TreeSet<ElementPath>();
        TreeSet<ElementPath> excludeElements = new TreeSet<ElementPath>();
        this.mapRetentionCells(retentionRules, specifiedElements, excludeElements, retentionCells);
    }

    private void computeExtraInfo(DVTCommandResult commandArgs, DVTPFInfo pdInfoForPDName, Set<DVTPFRetentionCellInfo> retentionCells, String libCellsType, TreeSet<ElementPath> specifiedElements, TreeSet<ElementPath> excludeElements) {
        String excludeElementList;
        String elementList;
        String libModelName = commandArgs.getOptionValue("lib_model_name");
        if (libModelName != null) {
            this.addLibModel(commandArgs, pdInfoForPDName, libModelName);
        }
        if ((elementList = commandArgs.getOptionValue("elements")) != null) {
            this.computeElements(elementList, specifiedElements);
        }
        if ((excludeElementList = commandArgs.getOptionValue("exclude_elements")) != null) {
            this.computeElements(excludeElementList, excludeElements);
        }
        HashSet<String> specifiedLibCells = new HashSet<String>();
        String libCells = commandArgs.getOptionValue("lib_cells");
        if (libCells != null) {
            this.computeLibCells(specifiedLibCells, libCells);
        }
        this.computeRetentionCells(specifiedLibCells, retentionCells, libCellsType);
    }

    private void mapRetentionCells(Set<DVTPFRetentionRuleInfo> retentionRules, TreeSet<ElementPath> specifiedElements, Set<ElementPath> excludeElements, Set<DVTPFRetentionCellInfo> cellsOfInterest) {
        if (retentionRules == null) {
            return;
        }
        for (DVTPFRetentionRuleInfo rule : retentionRules) {
            if (rule.isNoRetention()) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_MAPPING_OPTION, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), rule.getRuleName());
                continue;
            }
            if (rule.getElements() != null) continue;
        }
    }

    private TreeSet<ElementPath> performMapping(TreeSet<ElementPath> specifiedElements, Set<ElementPath> excludeElements, Set<DVTPFRetentionCellInfo> cellsOfInterest, DVTPFRetentionRuleInfo rule) {
        NavigableSet<ElementPath> subset;
        ElementPath greaterChildKey;
        TreeSet<ElementPath> workingSet = new TreeSet<ElementPath>();
        TreeSet<ElementPath> elements = rule.getElements();
        if (specifiedElements.isEmpty()) {
            workingSet.addAll(elements);
        }
        for (ElementPath element : specifiedElements) {
            greaterChildKey = ElementPath.join(element, "{");
            subset = elements.subSet(element, true, greaterChildKey, false);
            workingSet.addAll(subset);
        }
        for (ElementPath element : excludeElements) {
            greaterChildKey = ElementPath.join(element, "{");
            subset = elements.subSet(element, true, greaterChildKey, false);
            workingSet.removeAll(subset);
        }
        for (ElementPath elementPath : workingSet) {
            rule.mapRetentionCells(elementPath, cellsOfInterest);
        }
        return workingSet;
    }

    private void computeElements(String elementList, TreeSet<ElementPath> specifiedElements) {
        String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, elementList);
        if (elements == null || elements.length == 0) {
            return;
        }
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                element = this.replaceSeparators(element, this.pfModel.getHierarchySeparator());
                ElementPath instancePath = this.computeInstancePathFromElement(element, this.currScope);
                specifiedElements.add(instancePath);
            }
            ++n2;
        }
    }

    private void computeLibCells(Set<String> specifiedLibCells, String libCells) {
        String[] cells = DVTStringUtil.split(WHITESPACE_PATTERN, libCells);
        if (cells == null || cells.length == 0) {
            return;
        }
        String[] stringArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            String libCell = stringArray[n2];
            if (!libCell.trim().isEmpty()) {
                specifiedLibCells.add(libCell.trim());
            }
            ++n2;
        }
    }

    private void computeRetentionCells(Set<String> specifiedLibCells, Set<DVTPFRetentionCellInfo> retentionCells, String libCellsType) {
        if (libCellsType == null) {
            for (String libCell : specifiedLibCells) {
                DVTPFRetentionCellInfo retentionCellInfo = this.pfModel.getRetentionCellByName(libCell.trim());
                if (retentionCellInfo == null) {
                    retentionCellInfo = new DVTPFRetentionCellInfo(libCell, null, null);
                }
                retentionCells.add(retentionCellInfo);
            }
            return;
        }
        Set<DVTPFRetentionCellInfo> retentionCellsByType = this.pfModel.getRetentionCellsByType(libCellsType);
        if (specifiedLibCells.isEmpty()) {
            retentionCells.addAll(retentionCellsByType);
            return;
        }
        for (DVTPFRetentionCellInfo retCell : retentionCellsByType) {
            String cellName = retCell.getName();
            if (!specifiedLibCells.contains(cellName)) continue;
            retentionCells.add(retCell);
            return;
        }
    }

    private void addLibModel(DVTCommandResult commandArgs, DVTPFInfo pdInfoForPDName, String libModelName) {
        String portMap = commandArgs.getOptionValue("port_map");
        if (portMap == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), "port_map", "lib_model_name");
            return;
        }
        HashMap<String, String> mappedPorts = new HashMap<String, String>();
        Matcher matcher = BRACKETS_PATTERN.matcher(portMap);
        while (matcher.find()) {
            String pair = matcher.group(1);
            String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, pair);
            if (elements.length != 2) continue;
            mappedPorts.put(elements[0], elements[1]);
        }
        pdInfoForPDName.addLibModelByName(libModelName, mappedPorts);
    }
}

