/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.regex.Matcher;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.PFDesignForPathStatus;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySet;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class UPFSetIsolationCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public UPFSetIsolationCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String elements;
        String groundNet;
        String powerNet;
        String nameSuffix;
        String namePrefix;
        String instances;
        String location;
        String forceIsolation;
        String noIsolation;
        String useEquivalence;
        String diffSupplyOnly;
        String sink;
        DVTPFIsolationStrategyInfo isolationStrategy;
        String isolationSupply;
        DVTPFInfo pdInfoForPDName;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String isolationStrategyName = commandArgs.getCommandArg();
        if (isolationStrategyName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "name", "set_isolation");
            return;
        }
        String pdName = commandArgs.getOptionValue("domain");
        DVTPFInfo dVTPFInfo = pdInfoForPDName = pdName != null ? this.pfModel.getPDInfoForPDName(pdName) : null;
        if (pdInfoForPDName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
            return;
        }
        String excludeElements = commandArgs.getOptionValue("exclude_elements");
        if (excludeElements != null && EnumSet.of(DVTPFModel.UPFVersionType.v2_0, DVTPFModel.UPFVersionType.v1_0).contains(this.currVersion)) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_ARGUMENT_FOR_LANGUAGE_VERSION, this.pfModel, this.currParsedPfFile, errorLine, "exclude_elements", this.currVersion.toNiceString());
            return;
        }
        String appliesToBoundary = commandArgs.getOptionValue("applies_to_boundary");
        if (appliesToBoundary != null && !DVTPFModel.UPFVersionType.v3_0.equals(this.currVersion)) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_ARGUMENT_FOR_LANGUAGE_VERSION, this.pfModel, this.currParsedPfFile, errorLine, "applies_to_boundary", this.currVersion.toNiceString());
            return;
        }
        String string = isolationSupply = DVTPFModel.UPFVersionType.v3_0.equals(this.currVersion) ? commandArgs.getOptionValue("isolation_supply") : commandArgs.getOptionValue("isolation_supply_set");
        if (isolationSupply == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, DVTPFModel.UPFVersionType.v3_0.equals(this.currVersion) ? "isolation_supply_set" : "isolation_supply", "set_isolation");
            return;
        }
        if (!DVTPFModel.UPFVersionType.v3_0.equals(this.currVersion) && commandArgs.getOptionValue("isolation_supply") != null || DVTPFModel.UPFVersionType.v3_0.equals(this.currVersion) && commandArgs.getOptionValue("isolation_supply_set") != null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_NON_EXISTING_ARGUMENT, this.pfModel, this.currParsedPfFile, errorLine, DVTPFModel.UPFVersionType.v3_0.equals(this.currVersion) ? "isolation_supply_set" : "isolation_supply");
            return;
        }
        String clampValue = commandArgs.getOptionValue("clamp_value");
        if (clampValue == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "clamp_value", "set_isolation");
            return;
        }
        String update = commandArgs.getOptionValue("update");
        if (update != null) {
            DVTPFIsolationStrategyInfo isolationStrategyByName = pdInfoForPDName.getIsolationStrategyByName(isolationStrategyName);
            if (isolationStrategyByName == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_ISOLATION, this.pfModel, this.currParsedPfFile, errorLine, isolationStrategyName, pdName);
                return;
            }
            isolationStrategy = isolationStrategyByName;
        } else {
            isolationStrategy = new DVTPFIsolationStrategyInfo(isolationStrategyName, pdName, this.currParsedPfFile, this.args[0].getArgLine(), this.args[this.args.length - 1].getArgLine());
        }
        this.setClampValue(clampValue, isolationStrategy);
        String source = commandArgs.getOptionValue("source");
        if (source != null) {
            isolationStrategy.setSource(source);
        }
        if ((sink = commandArgs.getOptionValue("sink")) != null) {
            isolationStrategy.setSink(sink);
        }
        DVTPFIsolationStrategyInfo.UPFPortDirection portDirection = DVTPFIsolationStrategyInfo.UPFPortDirection.BOTH;
        String appliesTo = commandArgs.getOptionValue("applies_to");
        if (appliesTo != null) {
            try {
                portDirection = DVTPFIsolationStrategyInfo.UPFPortDirection.valueOf(appliesTo.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, appliesTo, "applies_to");
            }
        }
        DVTPFIsolationStrategyInfo.UPFBoundary boundary = DVTPFIsolationStrategyInfo.UPFBoundary.BOTH;
        if (appliesToBoundary != null) {
            try {
                boundary = DVTPFIsolationStrategyInfo.UPFBoundary.valueOf(appliesToBoundary.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, appliesToBoundary, "applies_to_boundary");
            }
        }
        String isolationSignalList = commandArgs.getOptionValue("isolation_signal");
        String isolationSenseList = commandArgs.getOptionValue("isolation_sense");
        if (isolationSignalList != null && isolationSenseList != null) {
            this.addIsolationSignals(DVTStringUtil.split(WHITESPACE_PATTERN, isolationSignalList), DVTStringUtil.split(WHITESPACE_PATTERN, isolationSenseList), isolationStrategy);
        }
        if ((diffSupplyOnly = commandArgs.getOptionValue("diff_supply_only")) != null) {
            if (diffSupplyOnly.isEmpty()) {
                isolationStrategy.setDiffSupplyOnly(true);
            } else if ("true".equalsIgnoreCase(diffSupplyOnly) || "false".equalsIgnoreCase(diffSupplyOnly)) {
                isolationStrategy.setDiffSupplyOnly(Boolean.parseBoolean(diffSupplyOnly));
            } else {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, diffSupplyOnly, "diff_supply_only");
                return;
            }
        }
        if ((useEquivalence = commandArgs.getOptionValue("use_equivalence")) != null) {
            if (useEquivalence.isEmpty()) {
                isolationStrategy.setUseEquivalence(true);
            } else if ("true".equalsIgnoreCase(useEquivalence) || "false".equalsIgnoreCase(useEquivalence)) {
                isolationStrategy.setUseEquivalence(Boolean.parseBoolean(useEquivalence));
            } else {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, useEquivalence, "use_equivalence");
                return;
            }
        }
        if ((noIsolation = commandArgs.getOptionValue("no_isolation")) != null) {
            isolationStrategy.setNoIsolation();
        }
        if ((forceIsolation = commandArgs.getOptionValue("force_isolation")) != null) {
            isolationStrategy.setForceIsolation();
        }
        if (isolationSupply != null) {
            String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, isolationSupply);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String supply = stringArray[n2];
                this.addSupplySet(supply, isolationStrategy);
                ++n2;
            }
        }
        if ((location = commandArgs.getOptionValue("location")) != null) {
            try {
                isolationStrategy.setLocation(DVTPFIsolationStrategyInfo.UPFIsolationLocation.valueOf(location.toUpperCase()));
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, location, "location");
            }
        }
        if ((instances = commandArgs.getOptionValue("instance")) != null) {
            this.addInstances(isolationStrategy, instances);
        }
        if ((namePrefix = commandArgs.getOptionValue("name_prefix")) != null) {
            isolationStrategy.setNamePrefix(namePrefix);
        }
        if ((nameSuffix = commandArgs.getOptionValue("name_suffix")) != null) {
            isolationStrategy.setNameSufix(nameSuffix);
        }
        if ((powerNet = commandArgs.getOptionValue("isolation_power_net")) != null) {
            DVTPFSupplyNetInfo supplyNet;
            if (EnumSet.of(DVTPFModel.UPFVersionType.v2_1, DVTPFModel.UPFVersionType.v2_2, DVTPFModel.UPFVersionType.v3_0).contains(this.currVersion)) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_LEGACY_ARG, this.pfModel, this.currParsedPfFile, errorLine, "isolation_power_net");
            }
            if ((supplyNet = this.pfModel.getSupplyNetInfo(powerNet)) != null) {
                isolationStrategy.setPowerNet(supplyNet);
            }
        }
        if ((groundNet = commandArgs.getOptionValue("isolation_ground_net")) != null) {
            DVTPFSupplyNetInfo goundNet;
            if (EnumSet.of(DVTPFModel.UPFVersionType.v2_1, DVTPFModel.UPFVersionType.v2_2, DVTPFModel.UPFVersionType.v3_0).contains(this.currVersion)) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_LEGACY_ARG, this.pfModel, this.currParsedPfFile, errorLine, "isolation_ground_net");
            }
            if ((goundNet = this.pfModel.getSupplyNetInfo(groundNet)) != null) {
                isolationStrategy.setGroundNet(goundNet);
            }
        }
        if ((elements = commandArgs.getOptionValue("elements")) != null && !elements.isEmpty()) {
            this.computeStrategyElementsFromList(DVTStringUtil.split(WHITESPACE_PATTERN, elements), isolationStrategy, this.currScope, this.currTopDesign, false, portDirection, boundary, pdName);
        }
        if (excludeElements != null && !excludeElements.isEmpty()) {
            this.computeStrategyElementsFromList(DVTStringUtil.split(WHITESPACE_PATTERN, excludeElements), isolationStrategy, this.currScope, this.currTopDesign, true, portDirection, boundary, pdName);
        }
        if (isolationStrategy.getElements().isEmpty()) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_NO_VALID_ISOLATION_ELEMENTS, this.pfModel, this.currParsedPfFile, errorLine, isolationStrategyName);
            return;
        }
        isolationStrategy.setFilePath(this.currParsedPfFile);
        isolationStrategy.setStartLine(this.args[0].getArgLine());
        for (ElementPath element : isolationStrategy.getElements()) {
            pdInfoForPDName.addElementToIsolation(element, isolationStrategyName);
            String lastSegment = element.lastSegment();
            ElementPath path = element.removeLastSegment();
            int indexOf = lastSegment.indexOf("[");
            if (indexOf >= 0) {
                lastSegment = lastSegment.substring(0, lastSegment.indexOf("["));
            }
            pdInfoForPDName.addElementToIsolation(ElementPath.join(path, lastSegment), isolationStrategyName);
        }
        pdInfoForPDName.addIsolationStrategy(isolationStrategy);
    }

    private void addIsolationSignals(String[] isolationSignals, String[] isolationSenses, DVTPFIsolationStrategyInfo isolationStrategy) {
        if (isolationSignals.length != isolationSenses.length) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_NUMBER_OF_ARGUMENTS, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), "isolation_sense", "isolation_signal");
            return;
        }
        int i = 0;
        while (i < isolationSignals.length) {
            String sense = null;
            try {
                String signal = this.replaceSeparators(isolationSignals[i], this.pfModel.getHierarchySeparator());
                ElementPath signalFullPath = this.computeInstancePathFromElement(signal, this.currScope);
                if (signalFullPath != null) {
                    sense = isolationSenses[i];
                    DVTPFIsolationStrategyInfo.UPFIsolationSense isolationSense = DVTPFIsolationStrategyInfo.UPFIsolationSense.HIGH;
                    isolationSense = DVTPFIsolationStrategyInfo.UPFIsolationSense.valueOf(sense.toUpperCase());
                    isolationStrategy.addIsolationSignal(signalFullPath, isolationSense);
                }
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), sense, "isolation_sense");
            }
            ++i;
        }
    }

    private void setClampValue(String clampValue, DVTPFIsolationStrategyInfo isolationStrategy) {
        isolationStrategy.setClampValue(clampValue);
    }

    protected void computeStrategyElementsFromList(String[] elementsArray, DVTPFIsolationStrategyInfo isolationStrategy, ElementPath currentScope, IRfDesignElement currTopDesign, boolean excludeElements, DVTPFIsolationStrategyInfo.UPFPortDirection portDirection, DVTPFIsolationStrategyInfo.UPFBoundary boundary, String pdName) {
        if (elementsArray == null || this.pfModel == null) {
            return;
        }
        String hierarchySeparator = this.pfModel.getHierarchySeparator();
        DVTTclUtils.printToConsole("[PF] Resolving retention elements '" + elementsArray + "' for retention rule '" + isolationStrategy.getStrategyName() + "'", this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
        String[] stringArray = elementsArray;
        int n = elementsArray.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty() && !(element = this.replaceSeparators(element, hierarchySeparator)).isEmpty()) {
                this.computeIsolationElement(element, isolationStrategy, currTopDesign, currentScope, excludeElements, portDirection, boundary, pdName);
            }
            ++n2;
        }
    }

    protected void computeIsolationElement(String element, DVTPFIsolationStrategyInfo isolationStrategy, IRfDesignElement currTopDesign, ElementPath currentScope, boolean excludeElements, DVTPFIsolationStrategyInfo.UPFPortDirection portDirection, DVTPFIsolationStrategyInfo.UPFBoundary boundary, String pdName) {
        Map<ElementPath, ELInstance> subtreeOf;
        ElementPath hierarchyPath;
        IELMemory memory;
        ElementPath instanceFullPath = this.computeInstancePathFromElement(element, currentScope);
        if (instanceFullPath == null) {
            return;
        }
        boolean isSearchSignal = false;
        DVTPFCommand.DesignForPathResult result = this.getDesignForPath(currTopDesign, currTopDesign.getName(), instanceFullPath, 0);
        if (result == null || result.getStatus() == PFDesignForPathStatus.NOT_IN_PATH) {
            result = this.getDesignForPath(currTopDesign, currTopDesign.getName(), instanceFullPath.removeLastSegment(), 0);
            isSearchSignal = true;
        }
        if ((memory = this.computeElaborationMemory(hierarchyPath = isSearchSignal ? instanceFullPath.removeLastSegment() : instanceFullPath, result)) == null) {
            return;
        }
        ELInstance currentInstance = memory.instanceFor(hierarchyPath);
        if (currentInstance != null) {
            if (isSearchSignal && this.pfModel.getPDInfoForInstance(hierarchyPath) != null) {
                IRfInstanceElement instance = currentInstance.getDescription();
                if (instance == null) {
                    return;
                }
                IRfNamedElement module = instance.getAssociatedType();
                if (module == null) {
                    return;
                }
                String portName = instanceFullPath.lastSegment();
                portName = portName.contains("[") ? portName.substring(0, portName.indexOf("[")) : portName;
                IRfNamedElement field = DesignUtils.getFieldOrInstanceByName(portName, DesignUtils.DesignRequest.of(module));
                if (!this.isValidIsolationElement(field, portDirection = this.computePortDirectionRegardingBoundary(portDirection, boundary, pdName, hierarchyPath))) {
                    return;
                }
                if (excludeElements) {
                    isolationStrategy.excludeElement(instanceFullPath);
                    return;
                }
                isolationStrategy.addElement(instanceFullPath);
                return;
            }
            this.computeIsolationElementsForInstance(currentInstance, isolationStrategy, hierarchyPath, excludeElements, portDirection, boundary, pdName);
        }
        if ((subtreeOf = memory.subtreeOf(instanceFullPath, false)) == null || subtreeOf.isEmpty()) {
            return;
        }
        for (Map.Entry<ElementPath, ELInstance> child : subtreeOf.entrySet()) {
            ElementPath childPath = child.getKey();
            ELInstance elInstance = child.getValue();
            this.computeIsolationElementsForInstance(elInstance, isolationStrategy, childPath, excludeElements, portDirection, boundary, pdName);
        }
    }

    private void computeIsolationElementsForInstance(ELInstance elInstance, DVTPFIsolationStrategyInfo isolationStrategy, ElementPath instancePath, boolean excludeElements, DVTPFIsolationStrategyInfo.UPFPortDirection portDirection, DVTPFIsolationStrategyInfo.UPFBoundary boundary, String pdName) {
        DVTPFInfo pdInfoForInstance = this.pfModel.getPDInfoForInstance(instancePath);
        if (pdInfoForInstance == null || pdInfoForInstance.getPowerDomainName().equals(pdName)) {
            return;
        }
        IRfInstanceElement instance = elInstance.getDescription();
        if (instance == null) {
            return;
        }
        IRfNamedElement module = instance.getAssociatedType();
        if (!(module instanceof IRfDesignElement)) {
            return;
        }
        Collection<? extends IRfFieldElement> localSignals = ((IRfDesignElement)module).getLocalSignals();
        if (localSignals == null) {
            return;
        }
        String hierarchySeparator = this.pfModel.getHierarchySeparator();
        for (IRfFieldElement iRfFieldElement : localSignals) {
            if (!this.isValidIsolationElement(iRfFieldElement, portDirection = this.computePortDirectionRegardingBoundary(portDirection, boundary, pdName, instancePath))) continue;
            String signalPath = this.computeSignalPath(instancePath, hierarchySeparator, iRfFieldElement);
            ElementPath signalElementPath = ElementPath.from(signalPath, hierarchySeparator);
            if (!excludeElements) {
                isolationStrategy.addElement(signalElementPath);
                continue;
            }
            isolationStrategy.excludeElement(signalElementPath);
        }
    }

    private boolean isValidIsolationElement(IRfNamedElement field, DVTPFIsolationStrategyInfo.UPFPortDirection portDirection) {
        boolean isPort = field instanceof IRfPortElement;
        if (!isPort) {
            return false;
        }
        IRfPortElement port = (IRfPortElement)field;
        switch (portDirection) {
            case BOTH: {
                return true;
            }
            case INPUTS: {
                return port.isInput();
            }
            case OUTPUTS: {
                return port.isOutput();
            }
        }
        return false;
    }

    private DVTPFIsolationStrategyInfo.UPFPortDirection computePortDirectionRegardingBoundary(DVTPFIsolationStrategyInfo.UPFPortDirection portDirection, DVTPFIsolationStrategyInfo.UPFBoundary boundary, String pdName, ElementPath hierarchyPath) {
        DVTPFInfo pdInfoForInstance = this.pfModel.getPDInfoForPDName(pdName);
        switch (boundary) {
            case UPPER: {
                if (pdInfoForInstance.isUpperBoundaryInstance(hierarchyPath)) break;
                return DVTPFIsolationStrategyInfo.UPFPortDirection.BOTH;
            }
            case LOWER: {
                if (pdInfoForInstance.isLowerBoundaryInstance(hierarchyPath)) break;
                return DVTPFIsolationStrategyInfo.UPFPortDirection.BOTH;
            }
            default: {
                return portDirection;
            }
        }
        return portDirection;
    }

    private void addSupplySet(String supplySetInfo, DVTPFIsolationStrategyInfo isolationStrategy) {
        if (supplySetInfo.isEmpty()) {
            return;
        }
        DVTUPFSupplySet supplySet = this.pfModel.getSupplySet(supplySetInfo);
        if (supplySet == null) {
            return;
        }
        isolationStrategy.addIsolationSupply(supplySet);
    }

    private void addInstances(DVTPFIsolationStrategyInfo isolationStrategy, String instances) {
        Matcher matcher = BRACKETS_PATTERN.matcher(instances);
        while (matcher.find()) {
            String pair = matcher.group(1);
            String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, pair);
            if (elements.length != 2) continue;
            String instance = elements[0];
            ElementPath instanceFullPath = this.computeInstancePathFromElement(instance = this.replaceSeparators(instance, this.pfModel.getHierarchySeparator()), this.currScope);
            if (instanceFullPath == null) continue;
            isolationStrategy.addInstance(instanceFullPath, elements[1]);
        }
    }
}

