/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import com.google.common.base.Enums;
import java.util.EnumSet;
import java.util.Set;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySet;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class UPFSetRetentionCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public UPFSetRetentionCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String instances;
        String parameters;
        String useRetentionAsPrimary;
        String noRetention;
        String restoreConition;
        String saveConition;
        String groundNet;
        String powerNet;
        String supplySetInfo;
        String excludeElements;
        DVTPFRetentionRuleInfo retentionRule;
        DVTPFInfo pdInfoForPDName;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String retentionRuleName = commandArgs.getCommandArg();
        if (retentionRuleName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "name", "set_retention");
            return;
        }
        String pdName = commandArgs.getOptionValue("domain");
        DVTPFInfo dVTPFInfo = pdInfoForPDName = pdName != null ? this.pfModel.getPDInfoForPDName(pdName) : null;
        if (pdInfoForPDName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
            return;
        }
        String saveSignal = commandArgs.getOptionValue("save_signal");
        String restoreSignal = commandArgs.getOptionValue("restore_signal");
        String retentionCondition = commandArgs.getOptionValue("retention_condition");
        String update = commandArgs.getOptionValue("update");
        if (update != null) {
            DVTPFRetentionRuleInfo retentionRuleByName = pdInfoForPDName.getRetentionRuleByName(retentionRuleName);
            if (retentionRuleByName == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_RETENTION_FOR_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
                return;
            }
            retentionRule = retentionRuleByName;
        } else {
            if (saveSignal == null && restoreSignal == null && retentionCondition == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_RETENTION_CONDITION, this.pfModel, this.currParsedPfFile, errorLine, retentionRuleName);
                return;
            }
            retentionRule = new DVTPFRetentionRuleInfo(retentionRuleName, pdName, this.currParsedPfFile, this.args[0].getArgLine(), this.args[this.args.length - 1].getArgLine());
        }
        String elements = commandArgs.getOptionValue("elements");
        if (elements == null || elements.isEmpty()) {
            Set<ElementPath> instances2 = pdInfoForPDName.getInstances();
            if (instances2 != null) {
                for (ElementPath instance : instances2) {
                    retentionRule.addElement(instance);
                }
            }
        } else {
            this.computeRetentionElementsFromList(DVTStringUtil.split(WHITESPACE_PATTERN, elements), retentionRule, this.currScope, this.currTopDesign, false);
        }
        if ((excludeElements = commandArgs.getOptionValue("exclude_elements")) != null && !excludeElements.isEmpty()) {
            this.computeRetentionElementsFromList(DVTStringUtil.split(WHITESPACE_PATTERN, excludeElements), retentionRule, this.currScope, this.currTopDesign, true);
        }
        this.addRetentionSignal("save_signal", retentionRule, commandArgs, this.pfModel, DVTPFRetentionRuleInfo.SIGNAL_TYPE.SAVE, errorLine);
        this.addRetentionSignal("restore_signal", retentionRule, commandArgs, this.pfModel, DVTPFRetentionRuleInfo.SIGNAL_TYPE.RESTORE, errorLine);
        String string = supplySetInfo = DVTPFModel.UPFVersionType.v3_0.equals(this.currVersion) ? commandArgs.getOptionValue("retention_supply") : commandArgs.getOptionValue("retention_supply_set");
        if (supplySetInfo != null) {
            this.addSupplySet(supplySetInfo, retentionRule);
        }
        if ((powerNet = commandArgs.getOptionValue("retention_power_net")) != null) {
            DVTPFSupplyNetInfo supplyNet;
            if (EnumSet.of(DVTPFModel.UPFVersionType.v2_1, DVTPFModel.UPFVersionType.v2_2, DVTPFModel.UPFVersionType.v3_0).contains(this.currVersion)) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_LEGACY_ARG, this.pfModel, this.currParsedPfFile, errorLine, "retention_power_net");
            }
            if ((supplyNet = this.pfModel.getSupplyNetInfo(powerNet)) != null) {
                retentionRule.setPowerNet(supplyNet);
            }
        }
        if ((groundNet = commandArgs.getOptionValue("retention_ground_net")) != null) {
            DVTPFSupplyNetInfo goundNet;
            if (EnumSet.of(DVTPFModel.UPFVersionType.v2_1, DVTPFModel.UPFVersionType.v2_2, DVTPFModel.UPFVersionType.v3_0).contains(this.currVersion)) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_LEGACY_ARG, this.pfModel, this.currParsedPfFile, errorLine, "retention_ground_net");
            }
            if ((goundNet = this.pfModel.getSupplyNetInfo(groundNet)) != null) {
                retentionRule.setGroundNet(goundNet);
            }
        }
        if (retentionCondition != null) {
            retentionRule.setRetentionCondition(retentionCondition);
        }
        if ((saveConition = commandArgs.getOptionValue("save_condition")) != null) {
            retentionRule.setSaveCondition(saveConition);
        }
        if ((restoreConition = commandArgs.getOptionValue("restore_condition")) != null) {
            retentionRule.setRestoreCondition(restoreConition);
        }
        if ((noRetention = commandArgs.getOptionValue("no_retention")) != null) {
            retentionRule.setNoRetention();
        }
        if ((useRetentionAsPrimary = commandArgs.getOptionValue("use_retention_as_primary")) != null) {
            retentionRule.setUseRetentionAsPrimary();
        }
        if ((parameters = commandArgs.getOptionValue("parameters")) != null) {
            this.addParameters(errorLine, retentionRuleName, retentionRule, parameters);
        }
        if ((instances = commandArgs.getOptionValue("instance")) != null) {
            this.addInstances(retentionRule, instances);
        }
        retentionRule.setFilePath(this.currParsedPfFile);
        retentionRule.setStartLine(this.args[0].getArgLine());
        for (ElementPath element : retentionRule.getElements()) {
            pdInfoForPDName.addElementToRetention(element, retentionRuleName);
        }
        pdInfoForPDName.addRetentionRule(retentionRule);
    }

    private void addSupplySet(String supplySetInfo, DVTPFRetentionRuleInfo retentionRule) {
        DVTUPFSupplySet supplySet = this.pfModel.getSupplySet(supplySetInfo);
        if (supplySet == null) {
            return;
        }
        retentionRule.setRetentionSupplySet(supplySet);
    }

    private void addParameters(int errorLine, String retentionRuleName, DVTPFRetentionRuleInfo retentionRule, String parameters) {
        String[] specifiedParameters = DVTStringUtil.split(WHITESPACE_PATTERN, parameters);
        if (specifiedParameters == null || specifiedParameters.length == 0) {
            return;
        }
        boolean retCorruptionSpecified = false;
        boolean saveRestoreCorruptionSpecified = false;
        String[] stringArray = specifiedParameters;
        int n = specifiedParameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            if (!Enums.getIfPresent(DVTPFRetentionRuleInfo.RetentionParameters.class, (String)parameter).isPresent()) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_NON_EXISTING_ARGUMENT, this.pfModel, this.currParsedPfFile, errorLine, retentionRuleName);
            } else {
                switch (DVTPFRetentionRuleInfo.RetentionParameters.valueOf(parameter)) {
                    case RET_SUP_COR: 
                    case NO_RET_SUP_COR: {
                        if (retCorruptionSpecified) {
                            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_PARAMETERS_COMBINATION, this.pfModel, this.currParsedPfFile, errorLine, DVTPFRetentionRuleInfo.RetentionParameters.RET_SUP_COR.toString(), DVTPFRetentionRuleInfo.RetentionParameters.NO_RET_SUP_COR.toString());
                            break;
                        }
                        retCorruptionSpecified = true;
                        retentionRule.setRetentionSupplyCorruption(DVTPFRetentionRuleInfo.RetentionParameters.valueOf(parameter));
                        break;
                    }
                    case SAV_RES_COR: 
                    case NO_SAV_RES_COR: {
                        if (saveRestoreCorruptionSpecified) {
                            DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_PARAMETERS_COMBINATION, this.pfModel, this.currParsedPfFile, errorLine, DVTPFRetentionRuleInfo.RetentionParameters.SAV_RES_COR.toString(), DVTPFRetentionRuleInfo.RetentionParameters.NO_SAV_RES_COR.toString());
                            break;
                        }
                        saveRestoreCorruptionSpecified = true;
                        retentionRule.setSaveRestoreCorruptionOption(DVTPFRetentionRuleInfo.RetentionParameters.valueOf(parameter));
                        break;
                    }
                }
            }
            ++n2;
        }
    }

    private void addInstances(DVTPFRetentionRuleInfo retentionRule, String instances) {
        String[] specifiedInstances = DVTStringUtil.split(WHITESPACE_PATTERN, instances);
        if (specifiedInstances == null || specifiedInstances.length == 0) {
            return;
        }
        String[] stringArray = specifiedInstances;
        int n = specifiedInstances.length;
        int n2 = 0;
        while (n2 < n) {
            ElementPath instanceFullPath;
            String instance = stringArray[n2];
            if (!instance.trim().isEmpty() && (instanceFullPath = this.computeInstancePathFromElement(instance = this.replaceSeparators(instance, this.pfModel.getHierarchySeparator()), this.currScope)) != null) {
                retentionRule.addInstance(instanceFullPath);
            }
            ++n2;
        }
    }
}

