/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import java.util.EnumSet;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionRuleInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class UPFSetRetentionControlCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public UPFSetRetentionControlCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        DVTPFInfo pdInfoForPDName;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        if (EnumSet.of(DVTPFModel.UPFVersionType.v2_1, DVTPFModel.UPFVersionType.v2_2, DVTPFModel.UPFVersionType.v3_0).contains(this.pfModel.getUPFVersion())) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_DEPRECATED_COMMAND, this.pfModel, this.currParsedPfFile, errorLine, "set_retention_control");
            return;
        }
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String pdName = commandArgs.getOptionValue("domain");
        DVTPFInfo dVTPFInfo = pdInfoForPDName = pdName != null ? this.pfModel.getPDInfoForPDName(pdName) : null;
        if (pdInfoForPDName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
            return;
        }
        String retentionRuleName = commandArgs.getCommandArg();
        if (retentionRuleName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "name", "set_retention_control");
            return;
        }
        DVTPFRetentionRuleInfo retentionRule = pdInfoForPDName.getRetentionRuleByName(retentionRuleName);
        if (retentionRule == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_RETENTION_FOR_PD, this.pfModel, this.currParsedPfFile, errorLine, retentionRuleName, pdName);
            return;
        }
        this.addRetentionSignal("save_signal", retentionRule, commandArgs, this.pfModel, DVTPFRetentionRuleInfo.SIGNAL_TYPE.SAVE, this.args[0].getArgLine());
        this.addRetentionSignal("restore_signal", retentionRule, commandArgs, this.pfModel, DVTPFRetentionRuleInfo.SIGNAL_TYPE.RESTORE, this.args[0].getArgLine());
        this.addRetentionSignal("assert_r_mutex", retentionRule, commandArgs, this.pfModel, DVTPFRetentionRuleInfo.SIGNAL_TYPE.ASSERT_R_MUTEX, this.args[0].getArgLine());
        this.addRetentionSignal("assert_s_mutex", retentionRule, commandArgs, this.pfModel, DVTPFRetentionRuleInfo.SIGNAL_TYPE.ASSERT_S_MUTEX, this.args[0].getArgLine());
        this.addRetentionSignal("assert_rs_mutex", retentionRule, commandArgs, this.pfModel, DVTPFRetentionRuleInfo.SIGNAL_TYPE.ASSERT_RS_MUTEX, this.args[0].getArgLine());
    }
}

