/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFRetentionListInfo;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class UPFSetRetentionElementsCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public UPFSetRetentionElementsCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String retentionListName = commandArgs.getCommandArg();
        if (retentionListName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "name", "set_retention_elements");
            return;
        }
        String[] elements = this.getPortList("elements", commandArgs);
        String[] excludeElements = this.getPortList("exclude_elements", commandArgs);
        this.pfModel.addRetentionListByName(retentionListName, new DVTPFRetentionListInfo(elements, excludeElements));
    }
}

