/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;

public class UPFSetScopeCommand
extends DVTPFCommand {
    protected String currHierarchySeparator;
    protected IRfDesignElement currTopDesign;
    protected ElementPath currScope;
    protected DVTPFModel.UPFVersionType currVersion;
    protected String currParsedPfFile;

    public UPFSetScopeCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String scopeName = commandArgs.getCommandArg();
        ElementPath scopeCopy = ElementPath.from(this.currScope.toString(this.currHierarchySeparator), this.currHierarchySeparator);
        ElementPath newScope = DVTPFUtils.resolveScopeString(scopeName, this.currTopDesign, scopeCopy, this.pfModel);
        this.pfModel.addScope(newScope);
        StringBuilder messageVer = new StringBuilder("set_scope ").append(scopeName).append(" (with top ").append(this.currTopDesign == null ? "null" : this.currTopDesign.getName()).append(") ...");
        DVTTclUtils.printToConsole("[PF (UPF)] " + messageVer, this.pfModel.getProject(), this.pfModel.getBuildKind(), DVTDebugKind.PF_DEBUG_INFO, this.pfModel.isDebugMode());
    }
}

