/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.upf;

import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import ro.amiq.dvt.model.problems.PFProblemKinds;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.power.format.DVTPFCommand;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFInterfaceCellInfo;
import ro.amiq.dvt.power.format.DVTPFIsolationStrategyInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplySet;
import ro.amiq.dvt.power.format.utils.DVTPFUtils;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import ro.amiq.dvt.utils.DVTStringUtil;

public class UPFUseInterfaceCellCommand
extends DVTPFCommand {
    private String currHierarchySeparator;
    private IRfDesignElement currTopDesign;
    private ElementPath currScope;
    private DVTPFModel.UPFVersionType currVersion;
    private String currParsedPfFile;

    public UPFUseInterfaceCellCommand(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void executeCommand() {
        String inverterSupplySet;
        boolean elementsAddedSuccesfully;
        DVTPFInfo pdInfoForPDName;
        if (this.pfModel == null || this.args == null || this.args.length == 0) {
            return;
        }
        int errorLine = this.args[0].getArgLine();
        this.currHierarchySeparator = this.pfModel.getHierarchySeparator();
        this.currTopDesign = this.pfModel.getTopDesign();
        this.currScope = this.pfModel.getScope();
        this.currVersion = this.pfModel.getUPFVersion();
        this.currParsedPfFile = this.pfModel.getCurrentParsedPfFile();
        if (!this.checkInitialConditions(true, this.currTopDesign, this.currScope, this.currVersion, this.currParsedPfFile, this.currHierarchySeparator)) {
            return;
        }
        DVTCommandResult commandArgs = this.parseCommandArguments(this.currParsedPfFile);
        if (commandArgs == null) {
            return;
        }
        String interfaceName = commandArgs.getCommandArg();
        if (interfaceName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "interface_implementation_name", "use_interface_cell");
            return;
        }
        String pdName = commandArgs.getOptionValue("domain");
        DVTPFInfo dVTPFInfo = pdInfoForPDName = pdName != null ? this.pfModel.getPDInfoForPDName(pdName) : null;
        if (pdInfoForPDName == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_PD, this.pfModel, this.currParsedPfFile, errorLine, pdName);
            return;
        }
        HashSet<DVTPFIsolationStrategyInfo> strategies = new HashSet<DVTPFIsolationStrategyInfo>();
        String strategiesList = commandArgs.getOptionValue("strategy");
        String[] stringArray = DVTStringUtil.split(WHITESPACE_PATTERN, strategiesList);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String strategy = stringArray[n2];
            DVTPFIsolationStrategyInfo isolationStrategy = pdInfoForPDName.getIsolationStrategyByName(strategy);
            if (isolationStrategy == null) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_UNDEFINED_ISOLATION, this.pfModel, this.currParsedPfFile, errorLine, strategy, pdName);
            } else {
                strategies.add(isolationStrategy);
            }
            ++n2;
        }
        if (strategies.isEmpty()) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_NO_VALID_STRATEGIES, this.pfModel, this.currParsedPfFile, errorLine, interfaceName);
            return;
        }
        HashSet<String> specifiedLibCells = new HashSet<String>();
        String libCells = commandArgs.getOptionValue("lib_cells");
        if (libCells == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, errorLine, "lib_cells", "use_interface_cell");
            return;
        }
        this.computeLibCells(specifiedLibCells, libCells);
        DVTPFInterfaceCellInfo interfaceCell = new DVTPFInterfaceCellInfo(pdName, libCells, strategies, specifiedLibCells);
        String elementList = commandArgs.getOptionValue("elements");
        TreeSet<ElementPath> specifiedElements = new TreeSet<ElementPath>();
        if (elementList != null) {
            this.computeElements(elementList, specifiedElements);
        }
        TreeSet<ElementPath> excludeElements = new TreeSet<ElementPath>();
        String excludeElementList = commandArgs.getOptionValue("exclude_elements");
        if (excludeElementList != null) {
            this.computeElements(excludeElementList, excludeElements);
        }
        if (!(elementsAddedSuccesfully = this.addElements(strategies, specifiedElements, excludeElements, interfaceCell))) {
            return;
        }
        this.addPortMap(commandArgs, interfaceCell);
        String forceFunction = commandArgs.getOptionValue("force_function");
        if (forceFunction != null) {
            interfaceCell.setForceFunction();
        }
        if ((inverterSupplySet = commandArgs.getOptionValue("inverter_supply_set")) != null) {
            this.computeSupplySet(inverterSupplySet, interfaceCell);
        }
        DVTPFIsolationStrategyInfo.UPFAppliesToClampValue appliesTo = DVTPFIsolationStrategyInfo.UPFAppliesToClampValue.NONE;
        String appliesToClamp = commandArgs.getOptionValue("applies_to_clamp");
        if (appliesToClamp != null) {
            try {
                appliesTo = DVTPFIsolationStrategyInfo.UPFAppliesToClampValue.valueOf(appliesToClamp.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, appliesToClamp, "applies_to_clamp");
            }
        }
        interfaceCell.setAppliesTo(appliesTo);
        DVTPFIsolationStrategyInfo.UPFAppliesToClampValue updateAny = DVTPFIsolationStrategyInfo.UPFAppliesToClampValue.NONE;
        String updateAnyOption = commandArgs.getOptionValue("update_any");
        if (updateAnyOption != null) {
            if (!DVTPFIsolationStrategyInfo.UPFAppliesToClampValue.ANY.equals((Object)appliesTo)) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_MANDATORY_PARAMETERS_COMBINATION, this.pfModel, this.currParsedPfFile, errorLine, "update_any", "applies_to_clamp any");
                return;
            }
            try {
                updateAny = DVTPFIsolationStrategyInfo.UPFAppliesToClampValue.valueOf(updateAnyOption.toUpperCase());
            }
            catch (Exception exception) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_VALUE, this.pfModel, this.currParsedPfFile, errorLine, updateAnyOption, "update_any");
            }
        }
        interfaceCell.setUpdateAny(updateAny);
        this.pfModel.addInterfaceCellByName(interfaceName, interfaceCell);
    }

    private void computeElements(String elementList, TreeSet<ElementPath> specifiedElements) {
        String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, elementList);
        if (elements == null || elements.length == 0) {
            return;
        }
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (!element.trim().isEmpty()) {
                element = this.replaceSeparators(element, this.pfModel.getHierarchySeparator());
                ElementPath instancePath = this.computeInstancePathFromElement(element, this.currScope);
                specifiedElements.add(instancePath);
            }
            ++n2;
        }
    }

    private void computeLibCells(Set<String> specifiedLibCells, String libCells) {
        String[] cells = DVTStringUtil.split(WHITESPACE_PATTERN, libCells);
        if (cells == null || cells.length == 0) {
            return;
        }
        String[] stringArray = cells;
        int n = cells.length;
        int n2 = 0;
        while (n2 < n) {
            String libCell = stringArray[n2];
            if (!libCell.trim().isEmpty()) {
                specifiedLibCells.add(libCell.trim());
            }
            ++n2;
        }
    }

    private boolean addElements(Set<DVTPFIsolationStrategyInfo> isolationStrategies, TreeSet<ElementPath> specifiedElements, Set<ElementPath> excludeElements, DVTPFInterfaceCellInfo interfaceCell) {
        if (isolationStrategies == null) {
            return false;
        }
        for (DVTPFIsolationStrategyInfo strategy : isolationStrategies) {
            NavigableSet<ElementPath> subset;
            ElementPath greaterChildKey;
            if (strategy.isNoIsolation()) {
                DVTPFUtils.addPfProblem(PFProblemKinds.PF_NO_ISOLATION, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), strategy.getStrategyName());
                continue;
            }
            if (strategy.getElements() == null) continue;
            TreeSet<ElementPath> elements = strategy.getElements();
            TreeSet<ElementPath> workingSet = new TreeSet<ElementPath>();
            if (specifiedElements.isEmpty()) {
                workingSet.addAll(elements);
            }
            for (ElementPath element : specifiedElements) {
                if (!elements.contains(element)) {
                    DVTPFUtils.addPfProblem(PFProblemKinds.PF_INVALID_ISOLATION_ELEMENT, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), strategy.getStrategyName(), element.getName());
                    return false;
                }
                greaterChildKey = ElementPath.join(element, "{");
                subset = elements.subSet(element, true, greaterChildKey, false);
                workingSet.addAll(subset);
            }
            for (ElementPath element : excludeElements) {
                greaterChildKey = ElementPath.join(element, "{");
                subset = elements.subSet(element, true, greaterChildKey, false);
                workingSet.removeAll(subset);
            }
            interfaceCell.addElements(workingSet);
        }
        return true;
    }

    private void addPortMap(DVTCommandResult commandArgs, DVTPFInterfaceCellInfo interfaceCell) {
        String portMap = commandArgs.getOptionValue("port_map");
        if (portMap == null) {
            DVTPFUtils.addPfProblem(PFProblemKinds.PF_MISSING_ARG, this.pfModel, this.currParsedPfFile, this.args[0].getArgLine(), "port_map", "lib_model_name");
            return;
        }
        Matcher matcher = BRACKETS_PATTERN.matcher(portMap);
        while (matcher.find()) {
            String pair = matcher.group(1);
            String[] elements = DVTStringUtil.split(WHITESPACE_PATTERN, pair);
            if (elements.length != 2) continue;
            interfaceCell.addPort(elements[0], elements[1]);
        }
    }

    private void computeSupplySet(String inverterSupplySet, DVTPFInterfaceCellInfo interfaceCell) {
        String[] supplySetInfo = DVTStringUtil.split(WHITESPACE_PATTERN, inverterSupplySet);
        if (supplySetInfo == null || supplySetInfo.length == 0) {
            return;
        }
        String[] stringArray = supplySetInfo;
        int n = supplySetInfo.length;
        int n2 = 0;
        while (n2 < n) {
            String supply = stringArray[n2];
            DVTUPFSupplySet supplySet = this.pfModel.getSupplySet(supply);
            if (supplySet == null) {
                return;
            }
            interfaceCell.addInverterSupply(supplySet);
            ++n2;
        }
    }
}

