/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.power.format.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemKind;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.power.format.DVTPFInfo;
import ro.amiq.dvt.power.format.DVTPFModel;
import ro.amiq.dvt.power.format.DVTPFSupplyNetInfo;
import ro.amiq.dvt.power.format.DVTPFSupplyPortInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyNetInfo;
import ro.amiq.dvt.power.format.upf.DVTUPFSupplyPortInfo;
import ro.amiq.dvt.tcl.model.DVTTclCommandArg;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTPFUtils {
    public static final String IMPLICIT_NET = "Implicit net";
    public static final String IMPLICIT_PORT = "Implicit port";
    public static final String CONTROL_SIGNAL = "Control signal: ";
    public static final String POWER = "power";
    public static final String GROUND = "ground";
    public static final String TRUE = "true";
    public static final String FALSE = "false";

    public static ElementPath resolveScopeString(String scopeName, IRfDesignElement topDesign, ElementPath currentScope, DVTPFModel pfModel) {
        if (scopeName == null || scopeName.isEmpty()) {
            return currentScope;
        }
        String hierarchySeparator = pfModel.getHierarchySeparator();
        if ("/".equals(scopeName)) {
            return ElementPath.from(topDesign.getName(), hierarchySeparator);
        }
        if (".".equals(scopeName)) {
            return currentScope;
        }
        if ("..".equals(scopeName)) {
            if (currentScope.length() > 1) {
                currentScope = currentScope.removeLastSegment();
            }
            return currentScope;
        }
        if (scopeName.startsWith("/")) {
            ElementPath newScope = ElementPath.from(scopeName.replaceFirst(hierarchySeparator, ""), hierarchySeparator);
            newScope = DVTPFUtils.removeGenBracketsFromPath(newScope);
            return newScope;
        }
        ElementPath scopePath = ElementPath.from(scopeName, hierarchySeparator);
        if ((scopePath = DVTPFUtils.removeGenBracketsFromPath(scopePath)).length() == 1) {
            if (!scopePath.toString().equals(currentScope.toString(hierarchySeparator))) {
                currentScope = ElementPath.join(currentScope, scopeName);
            }
            return currentScope;
        }
        return DVTPFUtils.resolveHierarchicalPaths(topDesign, currentScope, scopePath);
    }

    public static ElementPath replaceGenBlocksHierarchicalDelim(String hierarchySeparator, ElementPath scopePath) {
        if (scopePath == null || scopePath.isEmpty()) {
            return scopePath;
        }
        if (!".".equals(hierarchySeparator) && scopePath.toString(hierarchySeparator).contains(".")) {
            ArrayList<String> newPathSegments = new ArrayList<String>();
            String[] stringArray = scopePath.getSegments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                if (segment.contains(".")) {
                    if (!segment.replaceAll("\\.", "").trim().isEmpty()) {
                        String newSegment = segment.replaceAll("\\.", hierarchySeparator);
                        newPathSegments.add(newSegment);
                    }
                } else {
                    newPathSegments.add(segment);
                }
                ++n2;
            }
            scopePath = ElementPath.from(DVTStringUtil.join(newPathSegments, hierarchySeparator), hierarchySeparator);
        }
        return scopePath;
    }

    public static ElementPath resolveHierarchicalPaths(IRfDesignElement topDesign, ElementPath currentScope, ElementPath scopePath) {
        if (scopePath.length() == 0) {
            return null;
        }
        String[] stringArray = scopePath.getSegments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (!".".equals(segment)) {
                if ("..".equals(segment) && currentScope.length() > 1) {
                    currentScope = currentScope.removeLastSegment();
                } else if (segment != null && !segment.isEmpty() && !segment.equals(topDesign.getName())) {
                    currentScope = ElementPath.join(currentScope, segment);
                }
            }
            ++n2;
        }
        return currentScope;
    }

    public static ElementPath removeGenBracketsFromPath(ElementPath instancePath) {
        if (instancePath.isEmpty()) {
            return instancePath;
        }
        ElementPath newPath = ElementPath.EMPTY_PATH;
        String[] stringArray = instancePath.getSegments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (segment.contains("[")) {
                segment = segment.substring(0, segment.indexOf(91));
            }
            if (segment.contains("\\")) {
                segment = segment.replace("\\", "");
            }
            newPath = ElementPath.join(newPath, segment);
            ++n2;
        }
        return newPath;
    }

    public static String getPowerDomainsForInstanceOrPortByPath(IRfNamedElement element, ElementPath path, String delim) {
        if (!(element instanceof IRfPortElement) && !(element instanceof IRfInstanceElement)) {
            return null;
        }
        IRfSingleLangProject rfProject = element.getRfProject();
        if (rfProject == null) {
            return null;
        }
        DVTPFModel pfModel = rfProject.getPFModel();
        if (pfModel == null || !pfModel.hasPowerDomains()) {
            return null;
        }
        List<String> allUpf = null;
        if (path == null && element instanceof IRfInstanceElement) {
            allUpf = pfModel.getAllPDForInstance(element.getName());
        } else if (path != null) {
            ElementPath instancePath;
            String lastSeg;
            String[] segments = path.getSegments();
            if (segments == null || segments.length == 0) {
                return null;
            }
            if (segments[0].equals(ElementPath.$ROOT_NAME_PATH.getName())) {
                segments = Arrays.copyOfRange(segments, 1, segments.length);
            }
            if ((lastSeg = path.getSegment(path.length() - 1)) != null && !lastSeg.equals(element.getName())) {
                path = ElementPath.join(path, element.getName());
            }
            if ((allUpf = pfModel.getPDForPathTooltip(instancePath = ElementPath.create(segments))) == null || allUpf.isEmpty()) {
                return null;
            }
            ElementPath portPath = ElementPath.join(instancePath, element.getName());
            DVTPFInfo pdInfo = pfModel.getPDInfoForInstance(instancePath);
            if (pdInfo != null) {
                String isolationStrategy;
                String retentionRuleName = pdInfo.getRetentionRuleByElement(portPath);
                if (retentionRuleName != null) {
                    allUpf.add(String.format("Retention rule: " + retentionRuleName, new Object[0]));
                }
                if ((isolationStrategy = pdInfo.getIsolationStrategyByElement(portPath)) != null) {
                    allUpf.add("Isolation strategy: " + isolationStrategy + " [Clamp value: " + pdInfo.getIsolationStrategyByName(isolationStrategy).getClampValue() + "]");
                }
            }
        }
        return DVTStringUtil.join(allUpf, delim);
    }

    public static String getPowerDomainsForInstanceOrPortUsingDPM(IDVTBreadcrumbHost fTextEditor, IRfNamedElement element, String delim, int offset, IRfScopeElement initialScope) {
        if (fTextEditor == null) {
            return null;
        }
        ElementPath pathFor = DesignPathManager.getInstance().getPathFor((DVTEditor)fTextEditor, offset, element, initialScope, false, false);
        return DVTPFUtils.getPowerDomainsForInstanceOrPortByPath(element, pathFor, delim);
    }

    public static void addSupplyPort(String netName, DVTPFInfo pfInfo, DVTPFModel pfModel, boolean isGround) {
        if (netName == null || pfInfo == null || pfModel == null) {
            return;
        }
        DVTUPFSupplyPortInfo newPort = null;
        DVTPFSupplyNetInfo supplyNetInfo = pfModel.getSupplyNetInfo(netName);
        if (!(supplyNetInfo instanceof DVTUPFSupplyNetInfo)) {
            supplyNetInfo = new DVTUPFSupplyNetInfo(netName, "", false);
            pfModel.addSupplyNet(supplyNetInfo);
        }
        String direction = isGround ? "out" : "in";
        DVTPFSupplyPortInfo portConnectionForNetName = pfModel.getPortConnectionForNetName(netName, pfInfo.getPowerDomainName());
        if (portConnectionForNetName == null) {
            DVTPFSupplyPortInfo primaryPowerSupplyPortInfo = pfModel.getSupplyPortInfo(netName);
            if (primaryPowerSupplyPortInfo != null) {
                newPort = new DVTUPFSupplyPortInfo(netName, netName, netName, direction, pfInfo.getPowerDomainName());
                DVTPFSupplyPortInfo explicitPort = pfModel.getExplicitPort(netName);
                newPort.setGotoInfos(primaryPowerSupplyPortInfo.getGotoInfos());
                if (explicitPort != null) {
                    explicitPort.setDirection(direction);
                }
            } else {
                newPort = new DVTUPFSupplyPortInfo(netName, netName, direction, netName, pfInfo.getPowerDomainName());
                newPort.addGoToInfo(IMPLICIT_PORT, -1, -1);
            }
        } else {
            newPort = new DVTUPFSupplyPortInfo(netName, portConnectionForNetName.getPortName(), netName, direction, pfInfo.getPowerDomainName());
            newPort.setGotoInfos(portConnectionForNetName.getGotoInfos());
            DVTPFSupplyPortInfo explicitPort = pfModel.getExplicitPort(portConnectionForNetName.getPortName());
            if (explicitPort != null) {
                explicitPort.setDirection(direction);
            }
        }
        if (isGround) {
            pfInfo.setPrimaryGroundSupply(newPort);
        } else {
            pfInfo.setPrimaryPowerSupply(newPort);
        }
        supplyNetInfo.connectToPort(newPort);
    }

    public static void addPfProblem(DVTProblemKind problemKind, DVTPFModel pfModel, String filePath, int errorLine, String ... messageParameters) {
        if (pfModel == null) {
            return;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add(pfModel.getPfKind().toString());
        parameters.add(pfModel.getUPFVersion().toNiceString());
        parameters.addAll(Arrays.asList(messageParameters));
        DVTProblem prob = new DVTProblem(pfModel.getProject(), problemKind, filePath, false, errorLine, parameters.toArray(new String[parameters.size()]));
        if (pfModel.reportErrorsToConsole()) {
            prob.setToConsole(true);
        }
        DVTProblemManager.getInstance().reportProblem(prob);
    }

    public static int getArgLine(DVTTclCommandArg[] args, String argName) {
        if (args == null) {
            return -1;
        }
        DVTTclCommandArg[] dVTTclCommandArgArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            DVTTclCommandArg arg = dVTTclCommandArgArray[n2];
            if (argName.equals(arg.getArgName())) {
                return arg.getArgLine();
            }
            ++n2;
        }
        return args[0].getArgLine();
    }

    public static DVTPFModel getUpfModel(IProject iproject) {
        if (iproject == null) {
            return null;
        }
        RfMixedLangProject rfMLP = RfMixedLangManager.getInstance().getRfMixedLangProject(iproject, false);
        if (rfMLP == null) {
            return null;
        }
        return rfMLP.getPFModel();
    }
}

