/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.precompiled;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import ro.amiq.dvt.model.persistence.PersistenceOutputStream;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public enum PrecompiledAutoDebugUtils {
    INSTANCE;

    public static final String LIBRARY_HEADER = "-------- Library: ";
    public static final String DEBUG_SERIALIZATION_FILENAME = "serialized_objects.txt";
    private static final String OBJECT_STATS_FILENAME = "object_stats.txt";
    private static final String RFDM_SIZE_FILENAME = "rfdm_size.txt";
    private Map<String, Integer> libraryObjectTypeCount = new HashMap<String, Integer>();
    private boolean isEnabled;
    private Writer debugSerializationWriter;
    private String rfdmSizeFilePath;
    private String libObjectsFilePath;
    private String serializedObjectsFilePath;
    private long lastSize;

    public void initDebugging(String precompiledDbLocation) {
        if (!this.isEnabled) {
            return;
        }
        this.libObjectsFilePath = Paths.get(precompiledDbLocation, OBJECT_STATS_FILENAME).toString();
        this.rfdmSizeFilePath = Paths.get(precompiledDbLocation, RFDM_SIZE_FILENAME).toString();
        this.serializedObjectsFilePath = Paths.get(precompiledDbLocation, DEBUG_SERIALIZATION_FILENAME).toString();
        this.clearDebugFiles();
    }

    public void beginLibrary(String libName) {
        if (!this.isEnabled) {
            return;
        }
        this.clearLibObjectsMap();
        this.writeLibraryDebugHeader(libName);
        DVTFileUtils.getInstance().writeStringToFile(new File(this.rfdmSizeFilePath), "\n------------------- " + libName + " -------------------\n", true);
    }

    public void endLibrary(String libName) {
        if (!this.isEnabled) {
            return;
        }
        this.lastSize = 0L;
        this.writeLibStats(this.libObjectsFilePath, libName);
        this.clearLibObjectsMap();
    }

    public void writeLibraryDebugHeader(String libName) {
        if (!this.isEnabled) {
            return;
        }
        try {
            if (this.debugSerializationWriter == null) {
                this.debugSerializationWriter = new BufferedWriter(new FileWriter(this.serializedObjectsFilePath, true));
            }
            this.debugSerializationWriter.append(LIBRARY_HEADER + libName + "\n");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void objectWritten(Object obj) {
        if (!this.isEnabled) {
            return;
        }
        String objectClass = obj.getClass().getName();
        objectClass = objectClass.substring(objectClass.lastIndexOf(46) + 1);
        this.libraryObjectTypeCount.put(objectClass, this.libraryObjectTypeCount.getOrDefault(objectClass, 0) + 1);
        try {
            if (this.debugSerializationWriter == null) {
                this.debugSerializationWriter = new BufferedWriter(new FileWriter(this.serializedObjectsFilePath, true));
            }
            if (!(objectClass.contains("RfLibrary") || objectClass.contains("RfProject") || objectClass.contains("VlogFileInstance"))) {
                return;
            }
            this.debugSerializationWriter.append(String.format("%-20s", objectClass));
            if (obj instanceof IRfNamedElement) {
                this.debugSerializationWriter.append(((IRfNamedElement)obj).getName());
            } else if (obj instanceof IRfDefElement) {
                this.debugSerializationWriter.append(((IRfDefElement)obj).getName());
            } else if (obj instanceof IDVTFileInstance) {
                IDVTFileInstance fileInstance = (IDVTFileInstance)obj;
                this.debugSerializationWriter.append("Semantic Scope: ");
                if (fileInstance.getSemanticScope() != null) {
                    String semanticScopeClass = fileInstance.getSemanticScope().getClass().getName();
                    semanticScopeClass = semanticScopeClass.substring(semanticScopeClass.lastIndexOf(46) + 1);
                    this.debugSerializationWriter.append(semanticScopeClass);
                }
                this.debugSerializationWriter.append("  ").append(fileInstance.getParserPath().path);
            }
            this.debugSerializationWriter.append("\n");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void writeLibStats(String path, String libName) {
        if (!this.isEnabled) {
            return;
        }
        StringBuilder content = new StringBuilder();
        content.append("\n --------------- ").append(libName).append(" --------------- \n");
        for (Map.Entry objTypeCount : this.libraryObjectTypeCount.entrySet().stream().sorted((a, b) -> (Integer)b.getValue() - (Integer)a.getValue()).collect(Collectors.toList())) {
            content.append(String.format("%-70s", objTypeCount.getKey())).append(objTypeCount.getValue()).append("\n");
        }
        DVTFileUtils.getInstance().writeStringToFile(new File(path), content.toString(), true);
        try {
            this.debugSerializationWriter.close();
            this.debugSerializationWriter = null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void clearDebugFiles() {
        this.debugSerializationWriter = null;
        DVTFileUtils.getInstance().deleteFile(new File(this.libObjectsFilePath));
        DVTFileUtils.getInstance().deleteFile(new File(this.rfdmSizeFilePath));
        DVTFileUtils.getInstance().deleteFile(new File(this.serializedObjectsFilePath));
    }

    public void clearLibObjectsMap() {
        this.libraryObjectTypeCount.clear();
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void printPrecompileAutoRfdmSizeDebugData(String phase, PersistenceOutputStream stream) throws IOException {
        if (!this.isEnabled) {
            return;
        }
        stream.flush();
        File file = new File(stream.getFile());
        long fileSize = file.length();
        long difference = fileSize - this.lastSize;
        this.lastSize = fileSize;
        String toWrite = String.format("After %-20s the file size is %-10s  (%-8d bytes), increased by %-10s  (%d bytes) \n", phase, DVTUtilsCommon.convertBytesToSuitableUnitString(fileSize), fileSize, DVTUtilsCommon.convertBytesToSuitableUnitString(difference), difference);
        DVTFileUtils.getInstance().writeStringToFile(new File(this.rfdmSizeFilePath), toWrite, true);
    }
}

