/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.precompiled;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBSaveConfig;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;

public class PrecompiledDBManager {
    private static PrecompiledDBManager instance;
    public static final String SAVE_CONFIG_FILE_NAME = "save_config.yml";
    private Map<String, PrecompiledDBSaveConfig> precompiledDBConfigs = new HashMap<String, PrecompiledDBSaveConfig>();
    private Set<ParserPath> filesWithSyntacticErrors = new HashSet<ParserPath>();
    private Set<String> libsWithSemanticErrors = new HashSet<String>();
    private LinkedHashMap<Integer, String> fLibrariesToBeLoaded;
    private Set<String> fPrecompileIrelevantLibraries;
    private Map<String, String> fDefaultLibraryHomes = new HashMap<String, String>();
    private boolean fAllLibrariesAvailable;
    private Set<String> fLibrariesExcludedByPath = new HashSet<String>();
    private Set<ParserPath> fFilesWithIncludesChangedInIncremental = new HashSet<ParserPath>();
    private boolean loadedUvm;
    private Set<Integer> libraryStartedLoading = ConcurrentHashMap.newKeySet();
    private Set<Invocation> fFailedIntegrityInvocationsForInfiniteLoop = new HashSet<Invocation>();

    private PrecompiledDBManager() {
    }

    public static PrecompiledDBManager getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new PrecompiledDBManager();
        return instance;
    }

    public void writePrecompiledDBSaveConfig(IProject project, PrecompiledDBSaveConfig precompiledDBConfig, BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode) {
        String saveConfigFilePath = BuildConfigManager.getModelPersistenceLocation(project, SAVE_CONFIG_FILE_NAME, false, persistenceMode);
        LinkedHashMap<String, Object> precompiledDBConfigToYAML = precompiledDBConfig.convertToYAML();
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml generatedYaml = new Yaml(options);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(saveConfigFilePath)));){
                writer.write(generatedYaml.dump(precompiledDBConfigToYAML));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        PrecompiledDBUtils.logMD5(project, SAVE_CONFIG_FILE_NAME, persistenceMode);
    }

    private boolean readPrecompiledDBSaveConfig(String dbLocation) {
        Path saveConfigFilePath = Paths.get(dbLocation, SAVE_CONFIG_FILE_NAME);
        if (saveConfigFilePath == null || !saveConfigFilePath.toFile().isFile()) {
            return false;
        }
        Map precompiledLibraryData = null;
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(saveConfigFilePath.toFile()));){
                precompiledLibraryData = (Map)new Yaml().load((InputStream)inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if (precompiledLibraryData == null) {
            return false;
        }
        PrecompiledDBSaveConfig loadedLibraryConfig = PrecompiledDBSaveConfig.loadFromYAML(precompiledLibraryData);
        this.precompiledDBConfigs.put(dbLocation, loadedLibraryConfig);
        return true;
    }

    public PrecompiledDBSaveConfig getPrecompiledDBSaveConfig(String dbLocation) {
        if (!this.precompiledDBConfigs.containsKey(dbLocation)) {
            this.readPrecompiledDBSaveConfig(dbLocation);
        }
        return this.precompiledDBConfigs.get(dbLocation);
    }

    public void clearLibrariesToBeLoaded() {
        if (this.fLibrariesToBeLoaded == null) {
            this.fLibrariesToBeLoaded = new LinkedHashMap();
        }
        this.fLibrariesToBeLoaded.clear();
    }

    public LinkedHashMap<Integer, String> getLibrariesToBeLoaded() {
        if (this.fLibrariesToBeLoaded == null) {
            this.fLibrariesToBeLoaded = new LinkedHashMap();
        }
        return this.fLibrariesToBeLoaded;
    }

    public void addLibraryToBeLoaded(int invocationNumber, String libName) {
        if (this.fLibrariesToBeLoaded == null) {
            this.fLibrariesToBeLoaded = new LinkedHashMap();
        }
        this.fLibrariesToBeLoaded.put(invocationNumber, libName);
    }

    public boolean areAllLibrariesAvailable() {
        return this.fAllLibrariesAvailable;
    }

    public void setAllLibrariesAvailable(boolean allLibrariesAvailable) {
        this.fAllLibrariesAvailable = allLibrariesAvailable;
    }

    public void setPrecompileIrelevantLibraries(Set<String> libs) {
        this.fPrecompileIrelevantLibraries = libs;
    }

    public Set<String> getPrecompileIrelevantLibraries() {
        if (this.fPrecompileIrelevantLibraries == null) {
            this.fPrecompileIrelevantLibraries = new HashSet<String>();
        }
        return this.fPrecompileIrelevantLibraries;
    }

    public void clear() {
        if (this.precompiledDBConfigs != null) {
            this.precompiledDBConfigs.clear();
        }
        if (this.fLibrariesToBeLoaded != null) {
            this.fLibrariesToBeLoaded.clear();
        }
        if (this.fPrecompileIrelevantLibraries != null) {
            this.fPrecompileIrelevantLibraries.clear();
        }
        this.fAllLibrariesAvailable = false;
        this.loadedUvm = false;
        if (this.filesWithSyntacticErrors != null) {
            this.filesWithSyntacticErrors.clear();
        }
        if (this.libsWithSemanticErrors != null) {
            this.libsWithSemanticErrors.clear();
        }
        if (this.fDefaultLibraryHomes != null) {
            this.fDefaultLibraryHomes.clear();
        }
        if (this.libraryStartedLoading != null) {
            this.libraryStartedLoading.clear();
        }
        if (this.fLibrariesExcludedByPath != null) {
            this.fLibrariesExcludedByPath.clear();
        }
        if (this.fFilesWithIncludesChangedInIncremental != null) {
            this.fFilesWithIncludesChangedInIncremental.clear();
        }
        if (this.fFailedIntegrityInvocationsForInfiniteLoop != null) {
            this.fFailedIntegrityInvocationsForInfiniteLoop.clear();
        }
    }

    public void setUvmLoaded() {
        this.loadedUvm = true;
    }

    public boolean isUvmLoaded() {
        return this.loadedUvm;
    }

    public void reportFileSyntacticError(ParserPath path) {
        if (this.filesWithSyntacticErrors == null) {
            this.filesWithSyntacticErrors = new HashSet<ParserPath>();
        }
        this.filesWithSyntacticErrors.add(path);
    }

    public void reportLibrarySemanticError(String libName) {
        if (this.libsWithSemanticErrors == null) {
            this.libsWithSemanticErrors = new HashSet<String>();
        }
        this.libsWithSemanticErrors.add(libName);
    }

    public Set<ParserPath> getFilesWithSyntacticErrors() {
        return this.filesWithSyntacticErrors;
    }

    public Set<String> getLibsWithSemanticErrors() {
        return this.libsWithSemanticErrors;
    }

    public Map<String, String> getLibraryHomesMap() {
        return this.fDefaultLibraryHomes;
    }

    public void addLibraryHome(String library, String libraryHome) {
        this.fDefaultLibraryHomes.put(library, libraryHome);
    }

    public boolean getLibraryStartedLoading(int invocationNumber) {
        return this.libraryStartedLoading.contains(invocationNumber);
    }

    public void setLibraryStartedLoading(int invocationNumber) {
        this.libraryStartedLoading.add(invocationNumber);
    }

    public Set<ParserPath> getFilesWithIncludesChangedInIncremental() {
        return this.fFilesWithIncludesChangedInIncremental;
    }

    public void addFileWithIncludesChangedInIncremental(ParserPath parserPath) {
        this.fFilesWithIncludesChangedInIncremental.add(parserPath);
    }

    public Set<String> getLibrariesExcludedByPath() {
        return this.fLibrariesExcludedByPath;
    }

    public void addLibraryExcludedByPath(String librariesExcludedByPath) {
        this.fLibrariesExcludedByPath.add(librariesExcludedByPath);
    }

    public boolean shouldSkipBuildingInvocation(Invocation invocation) {
        return PrecompiledDBManager.getInstance().getLibrariesToBeLoaded().containsKey(invocation.getState().invocationNumber) || PrecompiledDBManager.getInstance().getPrecompileIrelevantLibraries().contains(invocation.getPrecompiledLibName()) || PrecompiledDBManager.getInstance().getLibrariesExcludedByPath().contains(invocation.getPrecompiledLibName());
    }

    public void setFailedIntegrityInvocationsForInfiniteLoopDetection(Set<Invocation> failedInvocations) {
        this.fFailedIntegrityInvocationsForInfiniteLoop = failedInvocations;
    }

    public Set<Invocation> getFailedIntegrityInvocationForInfiniteLoopDetection() {
        return this.fFailedIntegrityInvocationsForInfiniteLoop;
    }
}

