/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.precompiled;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.buildconfig.UvmReuseEnum;

public class PrecompiledDBSaveConfig {
    private static final String UVM_KEY = "uvm";
    private static final String TOP_KEY = "tops";
    private static final String INVOCATIONS_KEY = "invocations";
    private static final String SEMANTIC_ERRORS = "semantic_errors";
    private static final String SYNTACTIC_ERRORS = "syntactic_errors";
    private static final String MACRO_MAP = "macro_map";
    private static final String XILINX_ALTERA_HOMES_MAP = "xilinx_altera_homes";
    private static final String SAVE_TIME = "save_time";
    private static final String EXCLUDED_BY_PATH = "excluded_by_path";
    private Set<UvmReuseEnum> uvmReuse;
    private List<String> dhTops;
    private int precompiledInvocationsCount;
    private boolean semanticErrors;
    private boolean syntacticErrors;
    private Map<String, String> macroMap;
    private Map<String, String> xilinxAlteraHomesMap;
    private int saveTime;
    private boolean excludedByPath;

    public PrecompiledDBSaveConfig() {
    }

    public PrecompiledDBSaveConfig(boolean excludedByPath) {
        this.excludedByPath = excludedByPath;
        this.uvmReuse = new HashSet<UvmReuseEnum>();
        this.dhTops = new ArrayList<String>();
        this.precompiledInvocationsCount = 1;
        this.syntacticErrors = false;
        this.semanticErrors = false;
        this.macroMap = null;
        this.xilinxAlteraHomesMap = null;
        this.saveTime = 0;
    }

    public PrecompiledDBSaveConfig(Set<UvmReuseEnum> uvmReuse, List<String> dhTops, int precompiledInvocationsCount, boolean syntacticErrors, boolean semanticErrors, Map<String, String> macroMap, Map<String, String> xilinxAlteraHomesMap, int saveTime) {
        this.uvmReuse = uvmReuse;
        this.dhTops = dhTops;
        this.precompiledInvocationsCount = precompiledInvocationsCount;
        this.syntacticErrors = syntacticErrors;
        this.semanticErrors = semanticErrors;
        this.macroMap = macroMap;
        this.xilinxAlteraHomesMap = xilinxAlteraHomesMap;
        this.saveTime = saveTime;
        this.excludedByPath = false;
    }

    public LinkedHashMap<String, Object> convertToYAML() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(UVM_KEY, this.uvmReuse.stream().map(x -> x.name()).collect(Collectors.toList()));
        result.put(TOP_KEY, this.dhTops);
        result.put(INVOCATIONS_KEY, this.precompiledInvocationsCount);
        result.put(SYNTACTIC_ERRORS, this.syntacticErrors);
        result.put(SEMANTIC_ERRORS, this.semanticErrors);
        result.put(SAVE_TIME, this.saveTime);
        result.put(EXCLUDED_BY_PATH, this.excludedByPath);
        if (this.macroMap != null) {
            result.put(MACRO_MAP, this.macroMap);
        }
        if (this.xilinxAlteraHomesMap != null) {
            result.put(XILINX_ALTERA_HOMES_MAP, this.xilinxAlteraHomesMap);
        }
        return result;
    }

    public static PrecompiledDBSaveConfig loadFromYAML(Map<String, Object> precompiledLibraryData) {
        PrecompiledDBSaveConfig result = new PrecompiledDBSaveConfig();
        if (precompiledLibraryData.containsKey(UVM_KEY)) {
            List uvm = (List)precompiledLibraryData.get(UVM_KEY);
            result.uvmReuse = uvm.stream().map(x -> UvmReuseEnum.valueOf(x)).collect(Collectors.toSet());
        }
        if (precompiledLibraryData.containsKey(TOP_KEY)) {
            result.dhTops = (List)precompiledLibraryData.get(TOP_KEY);
        }
        if (precompiledLibraryData.containsKey(INVOCATIONS_KEY)) {
            result.precompiledInvocationsCount = (Integer)precompiledLibraryData.get(INVOCATIONS_KEY);
        }
        if (precompiledLibraryData.containsKey(SYNTACTIC_ERRORS)) {
            result.syntacticErrors = (Boolean)precompiledLibraryData.get(SYNTACTIC_ERRORS);
        }
        if (precompiledLibraryData.containsKey(SEMANTIC_ERRORS)) {
            result.semanticErrors = (Boolean)precompiledLibraryData.get(SEMANTIC_ERRORS);
        }
        if (precompiledLibraryData.containsKey(MACRO_MAP)) {
            result.macroMap = (Map)precompiledLibraryData.get(MACRO_MAP);
        }
        if (precompiledLibraryData.containsKey(XILINX_ALTERA_HOMES_MAP)) {
            result.xilinxAlteraHomesMap = (Map)precompiledLibraryData.get(XILINX_ALTERA_HOMES_MAP);
        }
        if (precompiledLibraryData.containsKey(SAVE_TIME)) {
            result.saveTime = (Integer)precompiledLibraryData.get(SAVE_TIME);
        }
        if (precompiledLibraryData.containsKey(EXCLUDED_BY_PATH)) {
            result.excludedByPath = (Boolean)precompiledLibraryData.get(EXCLUDED_BY_PATH);
        }
        return result;
    }

    public List<String> getDHTops() {
        return this.dhTops;
    }

    public int getPrecompiledInvocationsCount() {
        return this.precompiledInvocationsCount;
    }

    public Set<UvmReuseEnum> getUvmReuse() {
        return this.uvmReuse;
    }

    public Map<String, String> getMacroMap() {
        return this.macroMap;
    }

    public Map<String, String> getXilinxAlteraHomesMap() {
        return this.xilinxAlteraHomesMap;
    }

    public int getSaveTime() {
        return this.saveTime;
    }

    public boolean getExcludedByPath() {
        return this.excludedByPath;
    }
}

