/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.precompiled;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.floatingwidgets.FReportIssueDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.FReportIssueNotificationTracker;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.precompiled.PrecompiledDBUtilsCommon;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.PrecompiledDatabaseRebuildDialog;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class PrecompiledDBUtils
extends PrecompiledDBUtilsCommon {
    public static void regeneratePrecompiledLibraries(final IProject project, final String title, final String message, final BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper, final List<Invocation> invocations) {
        PrecompiledDBUtils.stopIfManualLoadFailedInLastBuild();
        Job job = new Job("Regenerate precompiled library"){

            protected IStatus run(IProgressMonitor monitor) {
                boolean isPrecompileAutoReadRfProjectFail;
                String jobsInParallelMessage;
                String string = jobsInParallelMessage = persistenceModeWrapper == null ? PrecompiledDBUtils.getJobsInParallelMessage(project, invocations.size()) : null;
                if (!PrecompiledDBUtils.openFailDialogWithActions(title, message, jobsInParallelMessage)) {
                    return Status.OK_STATUS;
                }
                Map<Integer, Boolean> rebuildSuccess = PrecompiledDBUtils.regeneratePrecompiledLibrariesInternal(project, title, message, persistenceModeWrapper, invocations, monitor);
                if (rebuildSuccess == null || rebuildSuccess.containsValue(Boolean.FALSE)) {
                    return Status.OK_STATUS;
                }
                boolean bl = isPrecompileAutoReadRfProjectFail = persistenceModeWrapper != null && persistenceModeWrapper.libraryName != null;
                if (isPrecompileAutoReadRfProjectFail) {
                    PrecompiledDBUtils.setWasBuildTriggeredAutomatically(false);
                }
                DVTBuildUtils.fullBuildWithProgress(project);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public static void openFailDialog(String title, String body) {
        if (TestHelper.isTestMode() && !TestHelper.isSWTBotSuite()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), title, null, body, 4, new String[]{"OK"}, 0);
            dialog.open();
        });
    }

    public static boolean openFailDialogWithActions(String titleText, String message) {
        return PrecompiledDBUtils.openFailDialogWithActions(titleText, message, null);
    }

    public static boolean openFailDialogWithActions(String titleText, String message, String selectableText) {
        if (TestHelper.isTestMode() && !TestHelper.isSWTBotSuite()) {
            return false;
        }
        return PrecompiledDatabaseRebuildDialog.openWarning(titleText, message, selectableText);
    }

    public static void showAutoInfiniteLoopFloatingNotification(IProject project, String failedLibrariesMessage) {
        FReportIssueDirtyResource dirtyResource = new FReportIssueDirtyResource(FNotificationDirtyReason.PRECOMPILED_AUTO_INFINITE_LOOP, failedLibrariesMessage);
        FReportIssueNotificationTracker.INSTANCE.addDirtyResource(project, dirtyResource);
        FWidgetFactory.INSTANCE.paint(true, FWidgetType.REPORT_ISSUE);
    }

    protected static void updateProblemsView(IProject project) {
        DVTProblemsUiUpdaterRegistry.get(DVTProblemCategories.BUILDCONFIG.getId()).update(project);
        DVTProblemsUiUpdaterRegistry.get(DVTProblemCategories.BUILDCONFIG.getId()).scheduleObjectionsClear(project);
    }
}

