/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.precompiled;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTBuildCancelManager;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.persistence.PersistenceBase;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemKinds;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfCompiledFiles;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.precompiled.PrecompiledDBManager;
import ro.amiq.dvt.precompiled.PrecompiledDBSaveConfig;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.MissingPrecompileCmdDialog;
import ro.amiq.dvt.ui.editor.floatingwidgets.FNotificationFactory;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTJobsUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.MD5InputStream;

public abstract class PrecompiledDBUtilsCommon {
    public static final String PRECOMPILED_FILES_WILL_BE_DELETED = "The existing precompiled database will be deleted.";
    public static final String PRECOMPILED_FILES_ARE_CORRUPTED_DIALOG_TITLE = "Precompiled database is corrupted";
    public static final String PRECOMPILED_FILES_ARE_CORRUPTED_DIALOG_MESSAGE = "Unable to load the precompiled database because it is corrupted.\nDo you want to rebuild the precompiled database?\n\nThe existing precompiled database will be deleted.";
    public static final String LOAD_DATABASE_FAIL_DIALOG_TITLE = "Precompiled databases cannot be loaded";
    public static final String PRECOMPILED_LOAD_FAILED_DIALOG_MESSAGE = "Unable to load precompiled databases for this project.\nIt is recommended to rebuild the precompiled databases.";
    public static final String PRECOMPILED_DATABASE_LOAD_FAILED_MESSAGE = "Precompiled databases could not be loaded.";
    public static final String DIR_NOT_FOUND_REASON_MESSAGE = "Missing precompiled database directory.";
    public static final String DVT_VERSION_DIR_NOT_FOUND_REASON_MESSAGE = "Precompiled directory does not contain the database for the current DVT version (" + DVTPlugin.getDefault().getVersion() + ").";
    public static final String FILES_ARE_CORRUPTED_REASON_MESSAGE = "Precompiled database is corrupted.";
    public static final Map<IntegrityStateEnum, String> FAIL_ERROR_MESSAGE_BY_REASON = new EnumMap<IntegrityStateEnum, String>(IntegrityStateEnum.class);
    public static final String FAILED_SECOND_TIME_MESSAGE = "Precompiled databases could not be regenerated. Check the build configuration.";
    public static final String BUILD_CMD_SEQUENTIAL_JOBS;
    public static final String BUILD_CMD_MULTIPLE_JOBS;
    private static final String PRECOMPILED_DIRECTORY_FAILED_TO_CREATE = "Precompiled directory failed to create.";
    public static final String PRECOMPILED_MD5_CHECK_FILE = "md5_check_sums";
    private static final List<String> PRECOMPILED_FILES;
    public static final String PRECOMPILED_INVOCATION_SUFFIX = "__dvt_inv_";
    public static final String PRECOMPILED_UVM_LIBRARY_NAME = "dvt_uvm_library";
    public static final String PRECOMPILED_ALL_LIBRARIES_PLACEHOLDER = "dvt_all_libraries_placeholder";
    public static final String PRECOMPILED_XILINX_ALTERA_LIBRARIES_DIR = "precompiled_libraries";
    public static final String FAIL_TITLE_PRECOMPILATION_UVMRE = "UVM Runtime Elaboration Issue";
    public static final String FAIL_BODY_PRECOMPILATION_UVMRE = "Cannot perform UVM Runtime Elaboration on projects containing precompiled databases. Build without precompilation when performing UVM Runtime Elaboration.";
    public static final String FAIL_TITLE_PRECOMPILATION_DEBUG = "Debug Issue";
    public static final String FAIL_BODY_PRECOMPILATION_DEBUG = "Cannot perform Debug on projects containing precompiled databases. Build without precompilation when performing Debug.";
    public static final String INFINITE_LOOP_FLOATING_NOTIFICATION = "Unable to precompile the following libraries so they were fully built: ";
    public static final String INFINITE_LOOP_INVOCATION_WARNING = "Invocation was fully built because it could not be precompiled.";
    public static final String BUILD_PRECOMPILED_DATABASE_START = "---------------------------------- Build Precompiled Database Start ----------------------------------";
    public static final String BUILD_PRECOMPILED_DATABASE_END = "----------------------------------- Build Precompiled Database End -----------------------------------";
    public static final String UNDEFINED_MACRO = "DVT_UNDEFINED_MACRO";
    public static final String XILINX_ISE = "XILINX_ISE_HOME";
    public static final String XILINX_VIVADO = "XILINX_VIVADO_HOME";
    public static final String ALTERA = "ALTERA_HOME";
    private static final Map<IProject, Map<String, Boolean>> precompiledFilesCache;
    private static final Map<IProject, Map<String, String>> precompiledSrcMapCache;
    private static boolean wasBuildTriggeredAutomatically;
    private static boolean manualLoadFailedInLastBuild;

    static {
        FAIL_ERROR_MESSAGE_BY_REASON.put(IntegrityStateEnum.PRECOMPILED_DIRECTORY_NOT_FOUND, DIR_NOT_FOUND_REASON_MESSAGE);
        FAIL_ERROR_MESSAGE_BY_REASON.put(IntegrityStateEnum.VERSION_DIRECTORY_NOT_FOUND, DVT_VERSION_DIR_NOT_FOUND_REASON_MESSAGE);
        FAIL_ERROR_MESSAGE_BY_REASON.put(IntegrityStateEnum.CORRUPTED_FILES, FILES_ARE_CORRUPTED_REASON_MESSAGE);
        BUILD_CMD_SEQUENTIAL_JOBS = "The rebuild jobs will run sequentially. To enable parallel execution, you can specify the number of maximum parallel rebuild jobs using the +" + IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_BUILD_CMD_MAX_JOBS.toString() + " directive.";
        BUILD_CMD_MULTIPLE_JOBS = "{0} rebuild jobs will be run in parallel.\nYou can change the number of maximum parallel rebuild jobs by using the +" + IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_BUILD_CMD_MAX_JOBS.toString() + " directive.";
        PRECOMPILED_FILES = Arrays.asList("vlog_dirty", "vlog_index", "vlog_rfdm", "vlog_rfdm_comp_files", "save_config.yml");
        precompiledFilesCache = new HashMap<IProject, Map<String, Boolean>>();
        precompiledSrcMapCache = new HashMap<IProject, Map<String, String>>();
    }

    public static void clearMD5CheckFile(IProject project, BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode) throws IOException {
        String filePath = BuildConfigManager.getModelPersistenceLocation(project, PRECOMPILED_MD5_CHECK_FILE, false, persistenceMode);
        if (filePath == null) {
            return;
        }
        new FileWriter(filePath, false).close();
    }

    public static void logMD5(IProject project, String fileName, BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode) {
        String filePath = BuildConfigManager.getModelPersistenceLocation(project, PRECOMPILED_MD5_CHECK_FILE, false, persistenceMode);
        if (filePath == null) {
            return;
        }
        String propertiesFileLocation = BuildConfigManager.getModelPersistenceLocation(project, fileName, false, persistenceMode);
        if (propertiesFileLocation == null) {
            return;
        }
        String fileMD5 = DVTFileUtils.getInstance().getFileMd5(propertiesFileLocation);
        DVTFileUtils.getInstance().writeStringToFile(new File(filePath), String.valueOf(fileName) + " " + fileMD5 + "\n", true);
    }

    public static IntegrityStateEnum checkPrecompiledDBIntegrity(String precompiledDbLocation) throws PersistenceBase.PrecompiledDbLoadFailException {
        Throwable throwable;
        if (precompiledDbLocation == null) {
            return IntegrityStateEnum.PRECOMPILED_DIRECTORY_NOT_FOUND;
        }
        File precompiledDbPath = new File(precompiledDbLocation);
        if (precompiledDbLocation.endsWith(DVTPlugin.getDefault().getVersion()) && !precompiledDbPath.getParentFile().isDirectory()) {
            return IntegrityStateEnum.PRECOMPILED_DIRECTORY_NOT_FOUND;
        }
        if (!precompiledDbPath.isDirectory()) {
            return IntegrityStateEnum.VERSION_DIRECTORY_NOT_FOUND;
        }
        HashMap files = new HashMap();
        try {
            Throwable throwable2 = null;
            throwable = null;
            try (Stream<Path> localFiles = Files.list(Paths.get(precompiledDbLocation, new String[0]));){
                localFiles.forEach(path -> {
                    File file = files.put(path.getFileName().toString(), path.toFile());
                });
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return IntegrityStateEnum.CORRUPTED_FILES;
        }
        if (files.containsKey(PRECOMPILED_UVM_LIBRARY_NAME)) {
            IntegrityStateEnum uvmLibIntegrity = PrecompiledDBUtilsCommon.checkPrecompiledDBIntegrity(Paths.get(precompiledDbLocation, PRECOMPILED_UVM_LIBRARY_NAME).toString());
            if (uvmLibIntegrity != IntegrityStateEnum.ALL_GOOD) {
                return IntegrityStateEnum.CORRUPTED_FILES;
            }
            if (files.size() == 1) {
                return IntegrityStateEnum.ALL_GOOD;
            }
        }
        if (!files.containsKey(PRECOMPILED_MD5_CHECK_FILE)) {
            return IntegrityStateEnum.CORRUPTED_FILES;
        }
        HashMap md5 = new HashMap();
        try {
            throwable = null;
            Iterator<String> iterator = null;
            try (BufferedReader br = new BufferedReader(new FileReader((File)files.get(PRECOMPILED_MD5_CHECK_FILE)));){
                br.lines().forEach(line -> {
                    String[] lineContent = line.split(" ");
                    md5.put(lineContent[0], lineContent[1]);
                });
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return IntegrityStateEnum.CORRUPTED_FILES;
        }
        for (String toCheckFile : PRECOMPILED_FILES) {
            File file = (File)files.get(toCheckFile);
            String knownMD5 = (String)md5.get(toCheckFile);
            if (file == null || knownMD5 == null) {
                return IntegrityStateEnum.CORRUPTED_FILES;
            }
            if (knownMD5.equals(DVTFileUtils.getInstance().getFileMd5(file.getPath()))) continue;
            return IntegrityStateEnum.CORRUPTED_FILES;
        }
        return IntegrityStateEnum.ALL_GOOD;
    }

    protected static Map<Integer, Boolean> regeneratePrecompiledLibrariesInternal(IProject project, String title, String message, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper, List<Invocation> invocations, IProgressMonitor monitor) {
        PrecompiledDBUtils.setManualLoadFailedInLastBuild(true);
        HashMap<Integer, Boolean> rebuildSuccess = new HashMap<Integer, Boolean>();
        if (persistenceModeWrapper == null) {
            List<Invocation> invocationsWithoutBuildCmds = PrecompiledDBUtilsCommon.getFailedLoadInvocationsWithoutBuildCmd(project, invocations);
            if (!invocationsWithoutBuildCmds.isEmpty()) {
                PrecompiledDBUtilsCommon.reportErrorsOnFailedLoadInvocationsWithoutBuildCmd(project, invocationsWithoutBuildCmds);
                return null;
            }
            int maxJobs = BuildConfigManager.getPrecompiledDbBuildCmdMaxJobs(project);
            ExecutorService executor = PrecompiledDBUtilsCommon.initExecutorService(maxJobs);
            for (Invocation invocation : invocations) {
                executor.execute(() -> rebuildSuccess.put(invocation.getState().invocationNumber, PersistenceBase.precompileDb(project, invocation, monitor, false)));
            }
            PrecompiledDBUtilsCommon.shutdownExecutorService(executor);
        } else if (persistenceModeWrapper.libraryName == null) {
            rebuildSuccess.put(persistenceModeWrapper.invocation.getState().invocationNumber, PersistenceBase.precompileDb(project, persistenceModeWrapper.invocation, monitor, true));
        } else {
            persistenceModeWrapper.libraryName = null;
            PrecompiledDBUtilsCommon.deletePrecompiledDatabaseDirectory(project, persistenceModeWrapper);
        }
        return rebuildSuccess;
    }

    public static boolean isManualPrecompiledFile(IProject project, ParserPath parserPath) {
        return PrecompiledDBUtilsCommon.isPrecompiledFileInternal(project, parserPath.path) == PrecompiledFileStatus.PRECOMPILED_MANUAL;
    }

    public static boolean isAutoPrecompiledFile(IProject project, ParserPath parserPath) {
        return PrecompiledDBUtilsCommon.isPrecompiledFileInternal(project, parserPath.path) == PrecompiledFileStatus.PRECOMPILED_AUTO;
    }

    public static boolean isPrecompiledFile(IProject project, ParserPath parserPath) {
        return PrecompiledDBUtilsCommon.isPrecompiledFile(project, parserPath.path);
    }

    public static boolean isPrecompiledFile(IProject project, String parserPath) {
        return PrecompiledDBUtilsCommon.isPrecompiledFileInternal(project, parserPath) != PrecompiledFileStatus.REGULAR;
    }

    public static boolean isPrecompiledAllFiles(IProject project, Set<String> parserPaths) {
        Map<String, Boolean> precompiledParserPaths = precompiledFilesCache.get(project);
        if (precompiledParserPaths == null) {
            return false;
        }
        return parserPaths.equals(precompiledParserPaths.keySet());
    }

    private static PrecompiledFileStatus isPrecompiledFileInternal(IProject project, String parserPath) {
        Map<String, Boolean> precompiledParserPaths = precompiledFilesCache.get(project);
        if (precompiledParserPaths == null) {
            return PrecompiledFileStatus.REGULAR;
        }
        Boolean precompiledFileStatus = precompiledParserPaths.get(parserPath);
        if (precompiledFileStatus == null) {
            return PrecompiledFileStatus.REGULAR;
        }
        if (precompiledFileStatus.booleanValue()) {
            return PrecompiledFileStatus.PRECOMPILED_AUTO;
        }
        return PrecompiledFileStatus.PRECOMPILED_MANUAL;
    }

    public static void addToPrecompiledFilesCache(IProject project, String parserPath, boolean isAuto) {
        Boolean previousPrecompiledFileStatus;
        Map<String, Boolean> precompiledParserPaths = precompiledFilesCache.get(project);
        if (precompiledParserPaths == null) {
            precompiledParserPaths = new HashMap<String, Boolean>();
        }
        if ((previousPrecompiledFileStatus = precompiledParserPaths.get(parserPath)) == null) {
            precompiledParserPaths.put(parserPath, isAuto);
        } else if (previousPrecompiledFileStatus.booleanValue() && !isAuto) {
            precompiledParserPaths.put(parserPath, false);
        }
        precompiledFilesCache.put(project, precompiledParserPaths);
    }

    public static void removeFromPrecompiledFilesCache(IProject project, String parserPath) {
        Map<String, Boolean> precompiledParserPaths = precompiledFilesCache.get(project);
        if (precompiledParserPaths == null) {
            return;
        }
        precompiledParserPaths.remove(parserPath);
    }

    public static void clearPrecompiledFilesCache(IProject project) {
        precompiledFilesCache.remove(project);
    }

    public static void createPrecompiledDbDirectory(int kind, IProject project) throws PersistenceBase.PrecompiledDirectoryFailedToCreateException {
        File precompiledDbDirectory;
        if (kind != 6 || !BuildConfigManager.isPrecompiledDbSaveMode(project)) {
            return;
        }
        String precompiledDbPath = BuildConfigManagerCommon.getPrecompiledDbSaveLocation(project);
        if (precompiledDbPath == null) {
            return;
        }
        String fullPathOfPrecompiledDbDirectory = precompiledDbPath;
        if (!Paths.get(precompiledDbPath, new String[0]).isAbsolute()) {
            fullPathOfPrecompiledDbDirectory = project.getLocation().append(precompiledDbPath).toOSString();
        }
        if ((precompiledDbDirectory = new File(fullPathOfPrecompiledDbDirectory)).isDirectory()) {
            return;
        }
        if (!precompiledDbDirectory.mkdirs()) {
            DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(project);
            String message = MessageFormat.format(DVTBuildCancelManager.CANCEL_MESSAGE_PATTERN, "Failed to create directory for: +dvt_precompiled_db_save+" + precompiledDbPath);
            console.print(message);
            throw new PersistenceBase.PrecompiledDirectoryFailedToCreateException(PRECOMPILED_DIRECTORY_FAILED_TO_CREATE);
        }
    }

    public static void clearPrecompiledDBDirectory(String precompiledDbLocation) {
        Path path = Paths.get(precompiledDbLocation, new String[0]);
        if (!path.toFile().exists()) {
            return;
        }
        try {
            DVTFileUtils.getInstance().removeRecursive(path, false);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static Map<String, String> discoverPrecompiledLibraries(Path precompiledDbPath) {
        HashMap<String, String> precompiledLibraries = new HashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Stream<Path> pathStream = Files.list(precompiledDbPath);){
                pathStream.forEach(p -> {
                    if (!p.toFile().isDirectory() || p.equals(precompiledDbPath)) {
                        return;
                    }
                    precompiledLibraries.put(p.getFileName().toString(), p.toString());
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return precompiledLibraries;
    }

    public static String adjustLibraryName(String libraryName, IBuildConfigParserConstants.ToolCompat toolCompat) {
        return IBuildConfigParserConstants.IUS_TOOLS.contains((Object)toolCompat) && "worklib".equals(libraryName) ? "work" : libraryName;
    }

    public static boolean containsPrecompiledInvocation(IProject project) {
        return BuildConfigManager.getPrecompiledDbMode(project) != BuildConfigManagerCommon.PrecompileGlobalMode.NO_GLOBAL_PRECOMPILE || BuildConfigManager.projectHasPrecompiledLoadInvocation(project);
    }

    public static final ExecutorService initExecutorService(IProject project) {
        Integer maxNofThreads = BuildConfigManager.getMaxNofThreads(project);
        return PrecompiledDBUtilsCommon.initExecutorService(maxNofThreads);
    }

    public static final ExecutorService initExecutorService(Integer maxNofThreads) {
        if (DVTLogger.INSTANCE.isDebugMode()) {
            TestHelper.out.println("Max nof threads = " + maxNofThreads);
        }
        if (maxNofThreads == null || maxNofThreads < 1) {
            maxNofThreads = 1;
        }
        return Executors.newFixedThreadPool(maxNofThreads);
    }

    public static final void shutdownExecutorService(ExecutorService executorService) {
        if (executorService == null) {
            return;
        }
        executorService.shutdown();
        while (!executorService.isTerminated()) {
            DVTJobsUtils.delay(50L);
        }
    }

    public static String getLibNameWithoutInvocationSuffix(String nameWithSuffix) {
        int indexOfInvocationSuffix = nameWithSuffix.indexOf(PRECOMPILED_INVOCATION_SUFFIX);
        if (indexOfInvocationSuffix == -1) {
            return nameWithSuffix;
        }
        return nameWithSuffix.substring(0, indexOfInvocationSuffix);
    }

    public static void clearPrecompiledSrcMapCache(IProject project) {
        precompiledSrcMapCache.remove(project);
    }

    public static String resolvePrecompiledParserPathSubstitution(IProject destProject, ParserPath parserPath) {
        if (destProject == null || parserPath == null) {
            return null;
        }
        Map<String, String> precompiledSrcMap = precompiledSrcMapCache.get(destProject);
        if (precompiledSrcMap == null) {
            precompiledSrcMap = BuildConfigManager.getPrecompiledSrcMap(destProject);
            precompiledSrcMapCache.put(destProject, precompiledSrcMap);
        }
        if (precompiledSrcMap.isEmpty()) {
            return null;
        }
        for (Map.Entry<String, String> precompiledSrcEntry : precompiledSrcMap.entrySet()) {
            String sub = DVTUtilsCommon.INSTANCE.resolveDirectorySubstitute(parserPath.getCanonicalPath(), precompiledSrcEntry.getKey(), precompiledSrcEntry.getValue(), false);
            if (sub == null) continue;
            return sub;
        }
        return parserPath.path;
    }

    public static boolean precompiledLibraryContainsUvmLibrary(String libraryPath, String searchedLibrary) {
        return new File(libraryPath, searchedLibrary).exists();
    }

    public static long countFilesInDir(String dirPath) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> files = Files.list(Paths.get(dirPath, new String[0]));){
            return files.count();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void setWasBuildTriggeredAutomatically(boolean wasBuildTriggeredAutomatically) {
        PrecompiledDBUtilsCommon.wasBuildTriggeredAutomatically = wasBuildTriggeredAutomatically;
    }

    public static boolean wasBuildTriggeredAutomatically() {
        return wasBuildTriggeredAutomatically;
    }

    public static void setManualLoadFailedInLastBuild(boolean value) {
        manualLoadFailedInLastBuild = value;
    }

    public static void checkManualPrecompiledLibrariesIntegrity(IProject project) throws PersistenceBase.PrecompiledDbLoadFailException {
        List<Invocation> invocations = BuildConfigManager.getInvocations(project);
        ExecutorService executor = PrecompiledDBUtilsCommon.initExecutorService(project);
        LinkedHashMap precompiledDbFailedIntegrityInvocations = new LinkedHashMap();
        for (Invocation invocation : invocations) {
            if (!BuildConfigManager.isPrecompiledDbLoadInvocation(invocation)) continue;
            executor.execute(() -> {
                String dbLocation = BuildConfigManager.getPrecompiledDbLoadLocation(project, invocation);
                IntegrityStateEnum invocationIntegrity = PrecompiledDBUtilsCommon.checkPrecompiledDBIntegrity(dbLocation);
                if (invocationIntegrity != IntegrityStateEnum.ALL_GOOD) {
                    precompiledDbFailedIntegrityInvocations.put(invocation, invocationIntegrity);
                }
            });
        }
        PrecompiledDBUtilsCommon.shutdownExecutorService(executor);
        if (precompiledDbFailedIntegrityInvocations.isEmpty()) {
            PrecompiledDBUtilsCommon.setManualLoadFailedInLastBuild(false);
            return;
        }
        ArrayList<Invocation> failedIntegrityInvocations = new ArrayList<Invocation>(precompiledDbFailedIntegrityInvocations.keySet());
        failedIntegrityInvocations.sort((a, b) -> a.getState().invocationNumber - b.getState().invocationNumber);
        for (Invocation failedInvocation : failedIntegrityInvocations) {
            IntegrityStateEnum failReason = (IntegrityStateEnum)((Object)precompiledDbFailedIntegrityInvocations.get(failedInvocation));
            String errorMessage = FAIL_ERROR_MESSAGE_BY_REASON.get((Object)failReason);
            DVTProblemManager.getInstance().reportProblem(new DVTProblem(project, DVTProblemKinds.BUILDCONFIG_ERROR, failedInvocation.getState().fStartFile, true, failedInvocation.getLine(), failedInvocation.getState().invocationNumber, errorMessage));
        }
        PrecompiledDBUtils.updateProblemsView(project);
        PrecompiledDBUtils.regeneratePrecompiledLibraries(project, LOAD_DATABASE_FAIL_DIALOG_TITLE, PRECOMPILED_LOAD_FAILED_DIALOG_MESSAGE, null, failedIntegrityInvocations);
        throw new PersistenceBase.PrecompiledDbLoadFailException("Failed to load precompiled database.");
    }

    protected static void stopIfManualLoadFailedInLastBuild() throws PersistenceBase.PrecompiledDbLoadFailException {
        if (!manualLoadFailedInLastBuild) {
            return;
        }
        PrecompiledDBUtils.openFailDialog(LOAD_DATABASE_FAIL_DIALOG_TITLE, FAILED_SECOND_TIME_MESSAGE);
        PrecompiledDBUtilsCommon.setManualLoadFailedInLastBuild(false);
        throw new PersistenceBase.PrecompiledDbLoadFailException("Failed to load precompiled database.");
    }

    protected static String getJobsInParallelMessage(IProject project, int failedInvocations) {
        if (failedInvocations == 1) {
            return null;
        }
        int maxJobs = BuildConfigManager.getPrecompiledDbBuildCmdMaxJobs(project);
        if (maxJobs == 1) {
            return BUILD_CMD_SEQUENTIAL_JOBS;
        }
        return MessageFormat.format(BUILD_CMD_MULTIPLE_JOBS, failedInvocations > maxJobs ? maxJobs : failedInvocations);
    }

    public static Map<Integer, Boolean> getInvocationToMd5CheckMap(IProject project, List<Invocation> invocations, BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode) {
        IRfSingleLangProject singleLangProject = RfMixedLangManager.getInstance().getRfSingleLangProject(project, "ro.amiq.vlogdt.VlogNature", false);
        ConcurrentHashMap<Integer, Boolean> invocation2Md5CheckMap = new ConcurrentHashMap<Integer, Boolean>();
        if (!precompiledDbMode.isAny(BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD, BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_SAVE, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_SAVE, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_LOAD)) {
            return invocation2Md5CheckMap;
        }
        ExecutorService executor = PrecompiledDBUtils.initExecutorService(project);
        int invocNumber = 0;
        while (invocNumber < invocations.size()) {
            RfCompiledFiles compiledFiles;
            BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper;
            String precompiledDbPath;
            Invocation invocation = invocations.get(invocNumber);
            if (!PrecompiledDBManager.getInstance().getPrecompileIrelevantLibraries().contains(invocation.getPrecompiledLibName()) && (precompiledDbPath = BuildConfigManager.getModelPersistenceLocation(project, "", false, persistenceModeWrapper = PrecompiledDBUtilsCommon.getPersistenceModeWrapperBasedOnPrecompileMode(invocation, precompiledDbMode))) != null && new File(precompiledDbPath).exists() && (compiledFiles = singleLangProject.readCompiledFiles(persistenceModeWrapper)) != null && compiledFiles.fCompiledFiles != null) {
                executor.execute(() -> invocation2Md5CheckMap.put(invocation.getState().invocationNumber, PrecompiledDBUtilsCommon.checkCompiledFilesIntegrity(rfCompiledFiles.fCompiledFiles, project, invocation, precompiledDbPath)));
            }
            ++invocNumber;
        }
        PrecompiledDBUtils.shutdownExecutorService(executor);
        return invocation2Md5CheckMap;
    }

    private static boolean checkCompiledFilesIntegrity(Set<ParserPath> compiledFiles, IProject iProject, Invocation invocation, String precompiledDbPath) {
        if (compiledFiles == null) {
            return false;
        }
        if (!BuildConfigManager.isPrecompiledDbMD5ChecksumDisabled(iProject, invocation)) {
            return PrecompiledDBUtils.checkPrecompiledFilesMD5(compiledFiles, precompiledDbPath, invocation.getState().invocationNumber, false);
        }
        return true;
    }

    private static BuildConfigManagerCommon.PersistenceModeWrapper getPersistenceModeWrapperBasedOnPrecompileMode(Invocation invocation, BuildConfigManagerCommon.PrecompileGlobalMode precompiledDbMode) {
        BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper = BuildConfigManagerCommon.PersistenceModeWrapper.regular();
        if (precompiledDbMode.isAny(BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_LOAD, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_SAVE, BuildConfigManagerCommon.PrecompileGlobalMode.XILINX_ALTERA_LOAD)) {
            persistenceModeWrapper = BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbLoad(invocation, !BuildConfigManager.isPrecompiledDbLoadInvocation(invocation) ? invocation.getPrecompiledLibName() : null);
        } else if (precompiledDbMode == BuildConfigManagerCommon.PrecompileGlobalMode.AUTO_SAVE) {
            persistenceModeWrapper = BuildConfigManagerCommon.PersistenceModeWrapper.precompiledDbSave(invocation.getPrecompiledLibName());
        }
        return persistenceModeWrapper;
    }

    private static boolean checkPrecompiledFilesMD5Internal(Set<ParserPath> parserPaths) {
        for (ParserPath parserPath : parserPaths) {
            if (parserPath == null || parserPath.path.contains("__vlog__")) continue;
            long oldSize = parserPath.getSize();
            byte[] oldMd5 = parserPath.getMd5();
            File file = new File(parserPath.path);
            if (oldSize != 0L && oldSize != file.length()) {
                return false;
            }
            if (Arrays.equals(oldMd5, IDVTConstants.BLANK_MD5)) {
                return true;
            }
            byte[] newMd5 = new byte[]{};
            try {
                Throwable throwable = null;
                Object var9_10 = null;
                try (MD5InputStream currentVerifFileStream = new MD5InputStream(file);){
                    while (currentVerifFileStream.read() != -1) {
                    }
                    newMd5 = currentVerifFileStream.getMD5();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
            if (oldMd5 == null || Arrays.equals(oldMd5, newMd5)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPrecompiledFilesMD5(final Set<ParserPath> parserPaths, final String precompiledDBPath, final int invocationNumber, boolean runOnJob) {
        if (runOnJob) {
            Job checkPrecompiledMD5Job = new Job("Check precompiled files MD5..."){

                protected IStatus run(IProgressMonitor monitor) {
                    if (!PrecompiledDBUtilsCommon.checkPrecompiledFilesMD5Internal(parserPaths)) {
                        FNotificationFactory.INSTANCE.addDirtyPrecompiledLibrary(precompiledDBPath, invocationNumber);
                    }
                    return Status.OK_STATUS;
                }
            };
            checkPrecompiledMD5Job.setSystem(true);
            checkPrecompiledMD5Job.schedule();
            return true;
        }
        return PrecompiledDBUtilsCommon.checkPrecompiledFilesMD5Internal(parserPaths);
    }

    public static boolean xilinxAlteraLibraryShouldBePrecompiled(String libName, Map<String, String> fXilinxAlteraLibrariesToBePrecompiled, boolean isAlteraPrecompilationDisabled, boolean isXilinxPrecompilationDisabled) {
        for (Map.Entry<String, String> libraryToBePrecompiled : fXilinxAlteraLibrariesToBePrecompiled.entrySet()) {
            String libNameToBePrecompiled = libraryToBePrecompiled.getKey();
            String tool = libraryToBePrecompiled.getValue();
            if (!libName.equals(libNameToBePrecompiled) || ALTERA.equals(tool) && isAlteraPrecompilationDisabled || (XILINX_VIVADO.equals(tool) || XILINX_ISE.equals(tool)) && isXilinxPrecompilationDisabled) continue;
            return true;
        }
        return false;
    }

    public static boolean checkMacrosOrPathChanged(IProject project, String libName, Path precompiledLibrariesPath, Set<Invocation> requiredInvocations) {
        PrecompiledDBSaveConfig precompiledLibraryConfig = PrecompiledDBManager.getInstance().getPrecompiledDBSaveConfig(precompiledLibrariesPath.resolve(libName).toString());
        if (precompiledLibraryConfig == null) {
            return false;
        }
        Map<String, String> loadedXilinxAlteraHomesMap = precompiledLibraryConfig.getXilinxAlteraHomesMap();
        if (!PrecompiledDBManager.getInstance().getLibraryHomesMap().equals(loadedXilinxAlteraHomesMap)) {
            return true;
        }
        Map<String, String> loadedMacroMap = precompiledLibraryConfig.getMacroMap();
        HashMap invocationMacros = new HashMap();
        for (Invocation invocation : requiredInvocations) {
            invocation.getProperties().stream().filter(p -> p.getKind() == 1).forEach(prop -> {
                String string = invocationMacros.put(prop.getName(), prop.getValue());
            });
        }
        return loadedMacroMap.keySet().stream().anyMatch(loadedMacroName -> {
            String loadedMacroValue = (String)loadedMacroMap.get(loadedMacroName);
            if (UNDEFINED_MACRO.equals(loadedMacroValue)) {
                return invocationMacros.containsKey(loadedMacroName);
            }
            if (invocationMacros.containsKey(loadedMacroName)) {
                String invocationMacroValue = (String)invocationMacros.get(loadedMacroName);
                return !Objects.equals(loadedMacroValue, invocationMacroValue);
            }
            return true;
        });
    }

    public static boolean checkMd5ForInvocations(Map<Integer, Boolean> invocationToMd5CheckMap, Set<Invocation> invocations) {
        for (Invocation invocation : invocations) {
            if (!Boolean.FALSE.equals(invocationToMd5CheckMap.get(invocation.getState().invocationNumber))) continue;
            return false;
        }
        return true;
    }

    public static void checkForPrecompileInfiniteLoop(IProject fProject) {
        if (!PrecompiledDBManager.getInstance().areAllLibrariesAvailable() && PrecompiledDBUtils.wasBuildTriggeredAutomatically()) {
            PrecompiledDBManager.getInstance().setAllLibrariesAvailable(true);
            PrecompiledDBUtils.setWasBuildTriggeredAutomatically(false);
            Comparator invocationComparator = (i1, i2) -> i1.getState().invocationNumber - i2.getState().invocationNumber;
            List sortedInvocations = PrecompiledDBManager.getInstance().getFailedIntegrityInvocationForInfiniteLoopDetection().stream().sorted(invocationComparator).collect(Collectors.toList());
            StringBuilder message = new StringBuilder();
            for (Invocation failedInvocation : sortedInvocations) {
                String libName = PrecompiledDBUtils.getLibNameWithoutInvocationSuffix(failedInvocation.getLibName());
                int invocationIndex = failedInvocation.getState().invocationNumber;
                message.append(libName).append(" (invocation number: ").append(invocationIndex).append("), ");
                BuildConfigToken token = failedInvocation.getState().fDvtInit.token;
                String file = token != null ? token.getFilename() : fProject.getLocation().append(failedInvocation.getFilename()).toFile().getAbsolutePath();
                int line = token != null ? token.getLine() : 0;
                int invocationNumber = failedInvocation.getState() != null ? failedInvocation.getState().invocationNumber : -1;
                failedInvocation.getProblems().add(new DVTProblem(fProject, DVTProblemKinds.BUILDCONFIG_WARNING, file, true, line, invocationNumber, "BUILD_CONFIG: ".concat(message.toString())));
                DVTBuildConsoleRegistry.getConsole(fProject).print(MessageFormat.format("*** Warning: {0}\n    at line {1} in {2}{3}{4}", INFINITE_LOOP_INVOCATION_WARNING, Integer.toString(failedInvocation.getLine()), failedInvocation.getFilename(), "", ""));
            }
            message.replace(message.length() - 2, message.length(), ".");
            PrecompiledDBUtils.showAutoInfiniteLoopFloatingNotification(fProject, message.toString());
        }
    }

    public static void deletePrecompiledDatabaseDirectory(IProject project, BuildConfigManagerCommon.PersistenceModeWrapper persistenceModeWrapper) {
        String precompiledDbLocation = BuildConfigManager.getModelPersistenceLocation(project, "", false, persistenceModeWrapper);
        try {
            DVTFileUtils.getInstance().removeRecursive(Paths.get(precompiledDbLocation, new String[0]), false);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static List<Invocation> getFailedLoadInvocationsWithoutBuildCmd(IProject project, List<Invocation> failedLoadInvocations) {
        ArrayList<Invocation> invocationsWithoutBuildCmds = new ArrayList<Invocation>();
        for (Invocation invocation : failedLoadInvocations) {
            String buildCmd = BuildConfigManager.getPrecompiledDbBuildCmd(project, invocation);
            if (buildCmd != null && !buildCmd.isEmpty()) continue;
            invocationsWithoutBuildCmds.add(invocation);
        }
        return invocationsWithoutBuildCmds;
    }

    public static void reportErrorsOnFailedLoadInvocationsWithoutBuildCmd(IProject project, List<Invocation> invocationsWithoutBuildCmds) {
        MissingPrecompileCmdDialog.openWarning(project);
        for (Invocation invocation : invocationsWithoutBuildCmds) {
            DVTProblemManager.getInstance().reportProblem(new DVTProblem(project, DVTProblemKinds.BUILDCONFIG_ERROR, invocation.getState().fStartFile, true, invocation.getLine(), invocation.getState().invocationNumber, "Directive +dvt_precompiled_db_build_cmd is not present in invocation " + invocation.getState().invocationNumber));
        }
        PrecompiledDBUtils.updateProblemsView(project);
        PrecompiledDBUtils.setManualLoadFailedInLastBuild(false);
    }

    public static boolean checkIfGlobalDirectivesChanged(List<BuildConfigProperty> deserializedCompactedCachedInfo, List<BuildConfigProperty> compactedCachedInfo) {
        if (deserializedCompactedCachedInfo == null || deserializedCompactedCachedInfo.isEmpty()) {
            return true;
        }
        Map<String, Object> oldGlobalDirectives = PrecompiledDBUtilsCommon.extractGlobalDirectives(deserializedCompactedCachedInfo);
        Map<String, Object> newGlobalDirectives = PrecompiledDBUtilsCommon.extractGlobalDirectives(compactedCachedInfo);
        if (!oldGlobalDirectives.keySet().equals(newGlobalDirectives.keySet())) {
            return true;
        }
        return !oldGlobalDirectives.equals(newGlobalDirectives);
    }

    private static Map<String, Object> extractGlobalDirectives(List<BuildConfigProperty> properties) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (properties == null || properties.isEmpty()) {
            return result;
        }
        for (BuildConfigProperty property : properties) {
            if (property.getKind() != 11) continue;
            for (Map.Entry<String, Serializable> attribute : property.getAttributes().entrySet()) {
                String directiveName = attribute.getKey();
                if (!IBuildConfigParserConstants.Directive.GLOBAL_DIRECTIVES.contains("+" + directiveName)) continue;
                result.put(directiveName, attribute.getValue());
            }
        }
        return result;
    }

    public static enum IntegrityStateEnum {
        ALL_GOOD,
        PRECOMPILED_DIRECTORY_NOT_FOUND,
        VERSION_DIRECTORY_NOT_FOUND,
        CORRUPTED_FILES;

    }

    private static enum PrecompiledFileStatus {
        REGULAR,
        PRECOMPILED_MANUAL,
        PRECOMPILED_AUTO;

    }
}

