/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.r2lparser;

import java.util.Comparator;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTR2LUtils {
    private static final LexicalComparator fDVTSorter = new LexicalComparator();
    private static final Comparator<IRfNamedElement> fLexicalSorter = new Comparator<IRfNamedElement>(){

        @Override
        public int compare(IRfNamedElement o1, IRfNamedElement o2) {
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    };

    public static LexicalComparator getDVTSorter(String prefix, boolean caseSensitive, LanguageKind languageKind) {
        return fDVTSorter.setPrefix(prefix, caseSensitive, languageKind);
    }

    public static Comparator<IRfNamedElement> getLexicalSorter(String prefix, boolean caseSensitive, LanguageKind languageKind) {
        fDVTSorter.setPrefix(prefix, caseSensitive, languageKind);
        return fDVTSorter.thenComparing(fLexicalSorter);
    }

    private static class LexicalComparator
    implements Comparator<IRfNamedElement> {
        private String fPrefix;
        private boolean fCaseSensitive;
        private LanguageKind fLanguageKind;

        private LexicalComparator() {
        }

        @Override
        public int compare(IRfNamedElement o1, IRfNamedElement o2) {
            if (o1.getLanguageKind() != this.fLanguageKind || o2.getLanguageKind() != this.fLanguageKind) {
                return 0;
            }
            String name1 = o1.getName();
            String name2 = o2.getName();
            if (this.fPrefix == null || this.fPrefix.isEmpty()) {
                return 0;
            }
            if (!this.fCaseSensitive) {
                name1 = name1.toLowerCase();
                name2 = name2.toLowerCase();
                this.fPrefix = this.fPrefix.toLowerCase();
            }
            if (name1.startsWith(this.fPrefix) && name2.startsWith(this.fPrefix)) {
                return 0;
            }
            if (name1.startsWith(this.fPrefix)) {
                return -1;
            }
            if (name2.startsWith(this.fPrefix)) {
                return 1;
            }
            int index1 = DVTStringUtil.getCamelCaseIndex(name1, this.fPrefix, this.fCaseSensitive);
            int index2 = DVTStringUtil.getCamelCaseIndex(name2, this.fPrefix, this.fCaseSensitive);
            if (index1 == 0 && index2 == 0) {
                return 0;
            }
            if (index1 == 0) {
                return -1;
            }
            if (index2 == 0) {
                return 1;
            }
            if (index1 != -1 && index2 != -1) {
                if (index1 < index2) {
                    return -1;
                }
                if (index1 > index2) {
                    return 1;
                }
                return name1.compareToIgnoreCase(name2);
            }
            if (index1 != -1) {
                return -1;
            }
            if (index2 != -1) {
                return 1;
            }
            return 0;
        }

        public LexicalComparator setPrefix(String prefix, boolean caseSensitive, LanguageKind languageKind) {
            this.fPrefix = prefix;
            this.fCaseSensitive = caseSensitive;
            this.fLanguageKind = languageKind;
            return this;
        }
    }
}

