/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.r2lparser.strategies;

import java.util.Set;
import java.util.function.Predicate;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.ui.editor.BaseLRUCache;

public abstract class DVTR2LCache {
    private static Predicate<IRfNamedElement> stillHasDefs = elem -> !elem.hasNoDefs(false);
    private static final int MAX_PARSER_PATHS = 100;
    protected BaseLRUCache<String, BaseLRUCache<IRfNamedElement, IRfNamedElement>> pathToCacheMap;

    private void initializePathToCacheMap() {
        if (this.pathToCacheMap == null) {
            this.pathToCacheMap = new BaseLRUCache(100);
        }
    }

    private void sanitizePathToCacheMap() {
        if (this.pathToCacheMap.isEmpty()) {
            this.pathToCacheMap = null;
        }
    }

    public boolean attemptCaching(ParserPath path, IRfNamedElement candidate) {
        this.initializePathToCacheMap();
        BaseLRUCache<IRfNamedElement, IRfNamedElement> cache = this.pathToCacheMap.get(path.toString());
        if (cache == null) {
            cache = new BaseLRUCache(this.getCacheSize(), stillHasDefs);
        }
        cache.put(candidate, candidate);
        this.pathToCacheMap.put(path.toString(), cache);
        return true;
    }

    public boolean containsCachedProposal(ParserPath path, IRfNamedElement proposal) {
        if (this.pathToCacheMap == null) {
            return false;
        }
        BaseLRUCache<IRfNamedElement, IRfNamedElement> cache = this.pathToCacheMap.get(path.toString());
        if (cache == null) {
            return false;
        }
        return cache.containsKey(proposal);
    }

    public void removePathEntry(ParserPath path) {
        if (this.pathToCacheMap == null) {
            return;
        }
        this.pathToCacheMap.remove(path.toString());
        this.sanitizePathToCacheMap();
    }

    public void removePathEntries(Set<ParserPath> paths) {
        if (this.pathToCacheMap == null) {
            return;
        }
        for (ParserPath path : paths) {
            this.pathToCacheMap.remove(path.toString());
        }
        this.sanitizePathToCacheMap();
    }

    public void removeDanglingElements(ParserPath path) {
        if (this.pathToCacheMap == null) {
            return;
        }
        BaseLRUCache<IRfNamedElement, IRfNamedElement> cache = this.pathToCacheMap.get(path.toString());
        if (cache == null) {
            return;
        }
        cache.checkElements();
    }

    public Set<String> getParserPaths() {
        if (this.pathToCacheMap == null) {
            return null;
        }
        return this.pathToCacheMap.keySet();
    }

    public void clear() {
        this.pathToCacheMap = null;
    }

    protected abstract int getCacheSize();
}

