/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.r2lparser.strategies;

import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.r2lparser.strategies.DVTR2LBaseStrategy;
import ro.amiq.dvt.utils.DVTStringUtil;

public class DVTR2LPrefixStrategy
extends DVTR2LBaseStrategy {
    private String prefix;
    private boolean caseSensitive;

    public DVTR2LPrefixStrategy(String prefix, boolean caseSensitive) {
        this.prefix = prefix;
        this.caseSensitive = caseSensitive;
    }

    @Override
    public int getRelevance(IRfNamedElement candidate) {
        if (this.prefix == null || this.prefix.isEmpty()) {
            return 0;
        }
        String name = candidate.getName();
        if (this.prefix.equals(name) || !this.caseSensitive && name.equalsIgnoreCase(this.prefix)) {
            return 14;
        }
        if (name.startsWith(this.prefix)) {
            return 10;
        }
        int index = DVTStringUtil.getCamelCaseIndex(name, this.prefix, this.caseSensitive);
        if (index != -1) {
            return 10 - index - 1;
        }
        return 0;
    }
}

