/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcemonitor.DVTResourceMonitor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ApplyDVTResourceFiltersJob
extends Job {
    private final IProject project;
    private final Set<String> filteredPaths;
    private final boolean updateResourceMonitor;

    public ApplyDVTResourceFiltersJob(IProject project, Set<String> filteredPaths, boolean updateResourceMonitor) {
        super("Apply DVT Resource Filters");
        this.project = project;
        this.filteredPaths = filteredPaths;
        this.updateResourceMonitor = updateResourceMonitor;
    }

    private ArrayList<FileInfoMatcherDescription> computeFiltersFor(Set<String> filteredPaths, IProgressMonitor monitor) {
        ArrayList<FileInfoMatcherDescription> filters = new ArrayList<FileInfoMatcherDescription>();
        if (filteredPaths == null) {
            return filters;
        }
        for (String path : filteredPaths) {
            if (monitor.isCanceled()) {
                return null;
            }
            filters.add(new FileInfoMatcherDescription("ro.amiq.dvt.multiFilter", (Object)("1.0-projectRelativePath-matches-true-false-" + new Path(path).toPortableString())));
        }
        return filters;
    }

    private Set<FilterDescription> internalApplyDvtFilters(IProject project, ArrayList<FileInfoMatcherDescription> filterDescriptionList, IProgressMonitor monitor) {
        HashSet<FilterDescription> resoruceFilters = new HashSet<FilterDescription>();
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        for (FileInfoMatcherDescription filter : filterDescriptionList) {
            if (monitor.isCanceled()) {
                return null;
            }
            FilterDescription filterDesc = new FilterDescription((IResource)project, 30, filter);
            filterDesc.setId(System.currentTimeMillis());
            projectDescription.addFilter(project.getProjectRelativePath(), filterDesc);
            resoruceFilters.add(filterDesc);
        }
        return resoruceFilters;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<FilterDescription> deleteAllDvtFilters(IProject project, IProgressMonitor monitor) {
        HashSet<FilterDescription> oldFilters = new HashSet<FilterDescription>();
        try {
            ProjectDescription projectDescription = ((Project)project).internalGetDescription();
            if (projectDescription == null) {
                return null;
            }
            Collection<LinkedList<FilterDescription>> allFilters = Collections.synchronizedCollection(ResourceFilterUtils.getAllFilters(project.getLocation().toOSString(), monitor));
            Iterator<LinkedList<FilterDescription>> iterator = allFilters.iterator();
            while (iterator.hasNext()) {
                if (monitor.isCanceled()) {
                    return null;
                }
                List<FilterDescription> filters = Collections.synchronizedList((List)iterator.next());
                if (filters == null) continue;
                for (FilterDescription filterDescription : filters) {
                    if (monitor.isCanceled()) {
                        return null;
                    }
                    if (!ResourceFilterUtils.isDVTFilter(filterDescription) || (filterDescription.getType() & 1) != 0) continue;
                    projectDescription.removeFilter((IPath)Path.EMPTY, filterDescription);
                    oldFilters.add(filterDescription);
                }
            }
            return oldFilters;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Set<FilterDescription> oldFilters = this.deleteAllDvtFilters(this.project, monitor);
            if (oldFilters == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            ArrayList<FileInfoMatcherDescription> filterMatchers = this.computeFiltersFor(this.filteredPaths, monitor);
            if (filterMatchers == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            Set<FilterDescription> newFilters = this.internalApplyDvtFilters(this.project, filterMatchers, monitor);
            if (newFilters == null) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            try {
                ResourceFiltersManager.INSTANCE.refreshChangedResources(this.project, oldFilters, newFilters);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
        }
        finally {
            if (this.updateResourceMonitor) {
                DVTResourceMonitor.resourceFiltersUpdated(true);
            }
        }
        return Status.OK_STATUS;
    }
}

