/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.resourcefilters.ResourceFilters;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ApplyFilterOnNewResourceJob
extends Job {
    IResource resource;

    private ApplyFilterOnNewResourceJob(IResource resource) {
        super("Apply Filter Job");
        this.resource = resource;
    }

    public static void runJob(IResource resource, boolean joinJob) {
        try {
            ApplyFilterOnNewResourceJob applyFilterJob = new ApplyFilterOnNewResourceJob(resource);
            applyFilterJob.schedule();
            if (joinJob) {
                applyFilterJob.join();
            }
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.isFiltered(this.resource)) {
            this.addFilter(this.resource);
        }
        return Status.OK_STATUS;
    }

    private boolean isFiltered(IResource resource) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null || resource == null) {
            return false;
        }
        return !workspace.validateFiltered(resource).isOK();
    }

    private void addFilter(IResource resource) {
        if (resource == null) {
            return;
        }
        ResourceFilters.applyAutoFiltersForResource(resource.getParent(), resource.getLocation(), true);
    }
}

