/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import ro.amiq.dvt.resourcefilters.ResourceFilterControlGroupIO;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.autofilters.DbOutOfSyncDialogStatus;

public class DvtResourceFiltersPropertyPage
extends PropertyPage {
    private ResourceFilterControlGroupIO fResourceControl;

    public String getDescription() {
        return "Configure Resource Filters";
    }

    public String getMessage() {
        return "Resource Filters";
    }

    public Control getControl() {
        this.noDefaultAndApplyButton();
        Control control = super.getControl();
        this.refresh();
        return control;
    }

    protected Control createContents(Composite parent) {
        this.fResourceControl = new ResourceFilterControlGroupIO(this.getProject().getLocation().toOSString(), this.getProject(), false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData layout = new GridData();
        layout.minimumWidth = 600;
        layout.minimumHeight = 580;
        composite.setLayoutData((Object)layout);
        composite = this.fResourceControl.createGroup(composite, 200, 280);
        Button applyFilters = new Button(composite, 0);
        GridData layoutData = new GridData(0x1000008, 4, true, false, 3, 1);
        applyFilters.setLayoutData((Object)layoutData);
        applyFilters.setText("Apply Filters");
        applyFilters.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DbOutOfSyncDialogStatus returnedState = ResourceFilterUtils.applyFilters(DvtResourceFiltersPropertyPage.this.getProject(), DvtResourceFiltersPropertyPage.this.fResourceControl);
                if (returnedState.isParseCancelled()) {
                    DvtResourceFiltersPropertyPage.this.fResourceControl.getAutoFilterCheckbox().setSelection(false);
                }
                DvtResourceFiltersPropertyPage.this.fResourceControl.updateCachedCheckedFiles();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        composite.pack();
        this.refresh();
        return composite;
    }

    public void dispose() {
        super.dispose();
    }

    protected IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    public boolean performOk() {
        DbOutOfSyncDialogStatus returnedState = ResourceFilterUtils.applyFilters(this.getProject(), this.fResourceControl);
        if (returnedState.isParseCancelled()) {
            this.fResourceControl.getAutoFilterCheckbox().setSelection(false);
            return false;
        }
        return super.performOk();
    }

    private void refresh() {
        if (this.fResourceControl != null) {
            this.fResourceControl.refresh();
        }
    }
}

