/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.resourcefilters.FileType;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFilters;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.AutoFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModelManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public interface IFiltersManager {
    public static final /* synthetic */ int[] $SWITCH_TABLE$ro$amiq$dvt$resourcefilters$ResourceFiltersManager$FiltersSelectionType;

    public List<ResourceFilters.CliFilter> computeFirstLevelFilters(IProject var1, List<ResourceFilters.CliFilter> var2);

    public Optional<List<ResourceFilters.CliFilter>> computeAutoFilters(IProject var1, boolean var2, BuildConfigParseMode var3);

    public void deactivateFilters(IProject var1, ResourceFiltersManager.FiltersSelectionType var2, boolean var3);

    default public void removeProjectDescriptionFilters(IProject project, ResourceFiltersManager.FiltersSelectionType type) {
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return;
        }
        HashMap filters = projectDescription.getFilters();
        if (filters == null) {
            return;
        }
        for (Map.Entry filter : filters.entrySet()) {
            LinkedList filterDescriptions = (LinkedList)filter.getValue();
            Iterator iterator = filterDescriptions.iterator();
            block6: while (iterator.hasNext()) {
                FilterDescription filterDescription = (FilterDescription)iterator.next();
                switch (type) {
                    case BOTH: {
                        if (!LazyResourcesModelManager.INSTANCE.isLazyFilter(filterDescription) || !AutoFiltersManager.INSTANCE.isAutoFilter(filterDescription)) continue block6;
                        iterator.remove();
                        break;
                    }
                    case FIRST_LEVEL: {
                        if (!LazyResourcesModelManager.INSTANCE.isLazyFilter(filterDescription) || AutoFiltersManager.INSTANCE.isAutoFilter(filterDescription)) continue block6;
                        iterator.remove();
                        break;
                    }
                    case AUTO: {
                        if (!AutoFiltersManager.INSTANCE.isAutoFilter(filterDescription)) break;
                        iterator.remove();
                        break;
                    }
                }
            }
        }
    }

    default public void updateAutoLinkAfterComputeFilters(IProject project, List<ResourceFilters.CliFilter> allFilters) {
        HashMap<IContainer, List<Filter>> filtersMap = new HashMap<IContainer, List<Filter>>(ResourceFilterUtils.getFiltersFromProject(project));
        boolean hasIncludeFilters = this.hasIncludeFilters(filtersMap);
        ResourceFiltersManager.addFiltersToMap(project, allFilters, filtersMap);
        if (hasIncludeFilters) {
            this.dirtyFilteredResourcesAutoLink(project, filtersMap, this.hasIncludeFilters(filtersMap));
            this.restoreAutoLink(project, filtersMap);
            return;
        }
        this.restoreAutoLink(project, filtersMap);
    }

    default public void updateAutoLinkAfterDeactivateFilters(IProject project, boolean updateAutoLinked) {
        Map<IContainer, List<Filter>> filters = ResourceFilterUtils.getFiltersFromProject(project);
        boolean hasIncludeFilters = this.hasIncludeFilters(filters);
        if (hasIncludeFilters && updateAutoLinked) {
            this.restoreAutoLink(project, filters);
            this.dirtyFilteredResourcesAutoLink(project, filters, hasIncludeFilters);
            return;
        }
        this.dirtyFilteredResourcesAutoLink(project, filters, hasIncludeFilters);
    }

    default public void restoreAutoLink(final IProject project, final Map<IContainer, List<Filter>> filtersMap) {
        final HashSet visitedDirectories = new HashSet();
        try {
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IContainer root;
                    IResource member = proxy.requestResource();
                    if (member == null) {
                        return false;
                    }
                    Object object = member instanceof IFile ? member.getParent() : (root = member instanceof IContainer ? (IContainer)member : null);
                    if (root == null || visitedDirectories.contains(root)) {
                        return false;
                    }
                    IPath location = member.getLocation();
                    if (location == null) {
                        return false;
                    }
                    File resourceFile = location.toFile();
                    if (!ResourceFilterUtils.isFiltered(resourceFile, member instanceof IContainer ? FileType.DIRECTORY : FileType.FILE, filtersMap, true)) {
                        return true;
                    }
                    if (project.equals((Object)root)) {
                        return true;
                    }
                    LazyResourcesModelManager.INSTANCE.restoreAutoLink(root, project);
                    visitedDirectories.add(root);
                    return false;
                }
            }, 2);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    default public void dirtyFilteredResourcesAutoLink(final IProject project, final Map<IContainer, List<Filter>> filters, final boolean hasIncludeFilters) {
        try {
            final IFolder autoLinkedDirectory = project.getFolder("DVT Auto-Linked");
            final IPath projectLocation = project.getLocation();
            if (projectLocation == null) {
                return;
            }
            if (autoLinkedDirectory == null || !autoLinkedDirectory.exists()) {
                return;
            }
            autoLinkedDirectory.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    IPath location = IFiltersManager.this.getLocationForAutoLink(resource, autoLinkedDirectory, project);
                    if (location == null) {
                        return true;
                    }
                    if (projectLocation.equals((Object)location) || !projectLocation.isPrefixOf(location)) {
                        return true;
                    }
                    File resourceFile = location.toFile();
                    if (ResourceFilterUtils.isFiltered(resourceFile, resource instanceof IContainer ? FileType.DIRECTORY : FileType.FILE, filters, hasIncludeFilters)) {
                        return false;
                    }
                    LazyResourcesModelManager.INSTANCE.updateDirtyAutoLinkFile(resource);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    default public IPath getLocationForAutoLink(IResource resource, IFolder autoLinkedDirectory, IProject project) {
        if (resource.getLocation() != null) {
            return resource.getLocation();
        }
        IPath fullPath = resource.getFullPath();
        if (fullPath == null) {
            return null;
        }
        IPath relativePath = fullPath.makeRelativeTo(autoLinkedDirectory.getFullPath());
        if (fullPath.equals((Object)relativePath)) {
            return null;
        }
        Map<String, AutoLinkRoot> autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
        String expandedRelativePath = relativePath.toOSString();
        for (Map.Entry<String, AutoLinkRoot> root : autoLinkedRoots.entrySet()) {
            String alias = root.getKey();
            IPath expandedPath = root.getValue().getExpandedPath();
            if (expandedPath == null || !relativePath.toOSString().startsWith(alias)) continue;
            expandedRelativePath = DVTStringUtil.replace(expandedRelativePath, alias, expandedPath.toOSString(), true);
        }
        if (expandedRelativePath.equals(relativePath.toOSString())) {
            expandedRelativePath = String.valueOf(File.separator) + expandedRelativePath;
        }
        return Path.fromOSString((String)expandedRelativePath);
    }

    default public boolean hasIncludeFilters(Map<IContainer, List<Filter>> filters) {
        return filters.values().stream().anyMatch(filterList -> filterList.stream().anyMatch(filter -> filter.isIncludeOnly() && !AutoFiltersManager.INSTANCE.isAutoFilter((Filter)filter)));
    }

    public static boolean isDbOutOfSync(IProject project) {
        boolean isBuildConfigChanged = FIncrementalNotificationTracker.INSTANCE.getDirtyResources(project).stream().anyMatch(resource -> resource.getReason().equals(FNotificationDirtyReason.BUILD_CONFIG_CHANGED));
        return FIncrementalNotificationTracker.INSTANCE.isDirty(project) && isBuildConfigChanged;
    }
}

