/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class RecursiveSymLinks {
    protected PrefixPool pathPrefixHistory;
    protected PrefixPool rootPathHistory;
    protected File root;

    public RecursiveSymLinks(File root) {
        this.root = root;
        try {
            this.pathPrefixHistory = new PrefixPool(20);
            this.rootPathHistory = new PrefixPool(20);
            this.rootPathHistory.insertShorter(String.valueOf(root.getCanonicalPath()) + '/');
        }
        catch (IOException iOException) {}
    }

    public void addToRootHistory(File rootFile) {
        try {
            this.rootPathHistory.insertShorter(String.valueOf(rootFile.getCanonicalPath()) + '/');
        }
        catch (Exception exception) {}
    }

    public boolean isRecursiveLink(File file) {
        block9: {
            String childPath;
            block10: {
                block8: {
                    File parentFile;
                    block7: {
                        String linkTarget = file.getPath();
                        if (linkTarget != null && PatternHolder.trivialSymlinkPattern.matcher(linkTarget).matches()) {
                            return true;
                        }
                        try {
                            parentFile = file.getParentFile();
                            if (parentFile != null) break block7;
                            return false;
                        }
                        catch (Exception exception) {}
                    }
                    String parentPath = String.valueOf(parentFile.getCanonicalPath()) + '/';
                    childPath = String.valueOf(file.getCanonicalPath()) + '/';
                    this.pathPrefixHistory.insertLonger(parentPath);
                    if (!this.pathPrefixHistory.containsAsPrefix(childPath)) break block8;
                    if (!this.rootPathHistory.insertShorter(childPath)) {
                        return true;
                    }
                    break block9;
                }
                if (!this.rootPathHistory.hasPrefixOf(childPath)) break block10;
                return false;
            }
            this.rootPathHistory.insertShorter(childPath);
        }
        return false;
    }

    private static class PatternHolder {
        public static final Pattern trivialSymlinkPattern = Pattern.compile("\\.[./]*");

        private PatternHolder() {
        }
    }

    public static class PrefixPool {
        private String[] pool;
        private int size;

        public PrefixPool(int initialCapacity) {
            if (initialCapacity <= 0) {
                throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
            }
            this.pool = new String[initialCapacity];
            this.size = 0;
        }

        public void clear() {
            Arrays.fill(this.pool, 0, this.size, null);
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        private void checkCapacity() {
            if (this.size + 1 >= this.pool.length) {
                String[] newprefixList = new String[2 * this.pool.length];
                System.arraycopy(this.pool, 0, newprefixList, 0, this.pool.length);
                Arrays.fill(this.pool, null);
                this.pool = newprefixList;
            }
        }

        public void insertLonger(String s) {
            int i = this.size - 1;
            while (i >= 0) {
                if (this.pool[i].startsWith(s)) {
                    return;
                }
                if (s.startsWith(this.pool[i])) {
                    this.pool[i] = s;
                    return;
                }
                --i;
            }
            this.checkCapacity();
            this.pool[this.size] = s;
            ++this.size;
        }

        public boolean insertShorter(String s) {
            boolean replaced = false;
            int i = this.size - 1;
            while (i >= 0) {
                if (s.startsWith(this.pool[i])) {
                    return false;
                }
                if (this.pool[i].startsWith(s)) {
                    if (replaced) {
                        System.arraycopy(this.pool, i + 1, this.pool, i, this.size - i - 1);
                        --this.size;
                        this.pool[this.size] = null;
                    } else {
                        this.pool[i] = s;
                        replaced = true;
                    }
                }
                --i;
            }
            if (!replaced) {
                this.checkCapacity();
                this.pool[this.size] = s;
                ++this.size;
            }
            return replaced;
        }

        public boolean containsAsPrefix(String s) {
            int i = this.size - 1;
            while (i >= 0) {
                if (this.pool[i].startsWith(s)) {
                    return true;
                }
                --i;
            }
            return false;
        }

        public boolean hasPrefixOf(String s) {
            int i = this.size - 1;
            while (i >= 0) {
                if (s.startsWith(this.pool[i])) {
                    return true;
                }
                --i;
            }
            return false;
        }
    }
}

