/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import ro.amiq.dvt.resourcefilters.RecursiveSymLinks;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.AutoFiltersManager;
import ro.amiq.dvt.resourcefilters.lazyfilters.FirstLevelFiltersManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;

public class ResourceFilterControlGroupIO {
    private static final String FILTER_BY_NAME_ANY_STRING_ANY_CHARACTER = "Filter by: name (* = any string, ? = any character)";
    public static final String CHILDREN_LIMIT = "9999";
    public static final String AUTO_BUTTON_TEXT = "Bring only compilation related resources";
    public static final String FIRST_LEVEL_BUTTON_TEXT = "Lazy bring-up resources";
    private static final String AUTO_MORE_INFO = "Bring only the compilation related files and directories, based on the active build configuration.";
    private static final String FIRST_LEVEL_MORE_INFO = "Bring only the files and directories (without their content) located directly under the project root." + System.lineSeparator() + "Double click a directory to further bring in its contents.";
    public final AtomicInteger CURRENT_NUMBER_OF_CHILDREN = new AtomicInteger(50);
    public final AtomicInteger CURRENT_TIMEOUT_MILLISECONDS = new AtomicInteger(10000);
    private String fRootPath;
    private IProject fProject = null;
    private Map<String, File[]> fFilesMap = new HashMap<String, File[]>();
    private Group templatesTreeGroup;
    private CheckboxTreeViewer fFilesTree;
    private Text fFilterText;
    private Label filesNrLimitLabel;
    private Button refreshFilesNr;
    private Text filesNrLimit;
    private Button selectAllButton;
    private Button deSelectAllButton;
    private Label timeoutLimitLabel;
    private Label noteRightClickMenu;
    private CustomCheckStateListener fCustomCheckStateListener;
    private final Set<File> fCheckedFilesReg = new HashSet<File>();
    private final Set<File> fCachedCheckedFilesReg = new HashSet<File>();
    private final Set<File> fPartCheckedFilesReg = new HashSet<File>();
    private boolean fIgnoreSerializedFilters = false;
    private RecursiveSymLinks fRecursiveSymLinks = null;
    private Map<File, LinkDescription> fLinkFiles = new HashMap<File, LinkDescription>();
    private Map<File, File> fTranslatedLink = new HashMap<File, File>();
    private Map<File, List<File>> fLinkParents = new HashMap<File, List<File>>();
    private Map<File, Integer> fNrOfFiles = new HashMap<File, Integer>();
    private Map<File, Integer> fNrOfFilesRecursively = new HashMap<File, Integer>();
    private Map<File, Boolean> fWasExpanded = new HashMap<File, Boolean>();
    private Map<File, Integer> fCountLimit = new HashMap<File, Integer>();
    private Combo fTimeOutLimit;
    private Set<String> fExcludedPaths;
    private Button firstLevelFilterCheckbox;
    private Button autoFilterCheckbox;
    private FieldDecoration infoField = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION");

    public ResourceFilterControlGroupIO(String rootPath, IProject project, boolean ignoreSerializedFilters) {
        this(rootPath, project, ignoreSerializedFilters, Collections.emptySet());
    }

    public ResourceFilterControlGroupIO(String rootPath, IProject project, boolean ignoreSerializedFilters, Set<String> excludedPaths) {
        this.fRootPath = rootPath;
        this.fProject = project;
        this.fIgnoreSerializedFilters = ignoreSerializedFilters;
        this.fRecursiveSymLinks = new RecursiveSymLinks(new File(rootPath));
        this.updateLinks();
        this.fExcludedPaths = excludedPaths;
    }

    public Button getFirstLevelFilterCheckbox() {
        return this.firstLevelFilterCheckbox;
    }

    public Button getAutoFilterCheckbox() {
        return this.autoFilterCheckbox;
    }

    public Composite createGroup(Composite composite) {
        return this.createGroup(composite, 0, 0);
    }

    public Composite createGroup(Composite composite, int height, int width) {
        this.countFiles(new File(this.fRootPath));
        if (ResourceFilterUtils.hasOtherFiltersDefined(this.fRootPath)) {
            Link warningLink = new Link(composite, 0);
            warningLink.setText("Warning! This project contains filters that can interfere with DVT filters and cause unexpected behavior.\nIt is recommended to remove them" + (this.fProject != null ? " from <a>here</a>" : "") + " before applying the DVT filters.");
            DVTUiUtils.setPlatformLinkColor((Link)warningLink);
            warningLink.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
            warningLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Set<File> filesSelectedNow = ResourceFilterControlGroupIO.this.getFilesSelectedDelta();
                    String remoteWizardID = "org.eclipse.ui.propertypages.resource.filters";
                    PreferenceDialog pref = PreferencesUtil.createPropertyDialogOn((Shell)ResourceFilterControlGroupIO.this.getShell(), (IAdaptable)ResourceFilterControlGroupIO.this.fProject, (String)remoteWizardID, null, null, (int)0);
                    if (pref != null) {
                        pref.open();
                    }
                    ResourceFilterControlGroupIO.this.resetToSerializedCheckedPaths(filesSelectedNow);
                }
            });
        }
        GridData checkboxData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.autoFilterCheckbox = new Button(composite, 32);
        this.autoFilterCheckbox.setText(AUTO_BUTTON_TEXT);
        this.autoFilterCheckbox.setSelection(AutoFiltersManager.INSTANCE.hasAutoFilters(this.fProject));
        this.autoFilterCheckbox.setLayoutData((Object)checkboxData);
        ControlDecoration autoDecoration = new ControlDecoration((Control)this.autoFilterCheckbox, 16512);
        autoDecoration.setImage(this.infoField.getImage());
        autoDecoration.setDescriptionText(AUTO_MORE_INFO);
        this.firstLevelFilterCheckbox = new Button(composite, 32);
        this.firstLevelFilterCheckbox.setText(FIRST_LEVEL_BUTTON_TEXT);
        this.firstLevelFilterCheckbox.setSelection(FirstLevelFiltersManager.INSTANCE.hasFirstLevelFilters(this.fProject));
        this.firstLevelFilterCheckbox.setLayoutData((Object)checkboxData);
        ControlDecoration firstLevelDecoration = new ControlDecoration((Control)this.firstLevelFilterCheckbox, 16512);
        firstLevelDecoration.setImage(this.infoField.getImage());
        firstLevelDecoration.setDescriptionText(FIRST_LEVEL_MORE_INFO);
        this.templatesTreeGroup = new Group(composite, 0);
        this.templatesTreeGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gdTemplatesGroup = new GridData(4, 4, true, true, 3, 1);
        this.templatesTreeGroup.setLayoutData((Object)gdTemplatesGroup);
        this.templatesTreeGroup.setText("You can select which files/directories to exclude from the project directory:");
        this.fFilterText = new Text((Composite)this.templatesTreeGroup, 2048);
        this.fFilterText.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        this.fFilterText.setMessage(FILTER_BY_NAME_ANY_STRING_ANY_CHARACTER);
        this.fFilterText.setText("");
        DVTColorUtil.INSTANCE.setForeground((Control)this.fFilterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.foregroundColor"), true);
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    ResourceFilterControlGroupIO.this.fFilesTree.getTree().setFocus();
                }
                this.setFilterTextColor();
            }

            public void keyReleased(KeyEvent e) {
                this.setFilterTextColor();
            }

            private void setFilterTextColor() {
                if (ResourceFilterControlGroupIO.this.fFilterText.getText().length() == 0) {
                    DVTColorUtil.INSTANCE.setBackground((Control)ResourceFilterControlGroupIO.this.fFilterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.emptyBackgroundColor"));
                } else {
                    DVTColorUtil.INSTANCE.setBackground((Control)ResourceFilterControlGroupIO.this.fFilterText, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.filter.backgroundColor"));
                }
            }
        });
        this.fFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = ResourceFilterControlGroupIO.this.fFilterText.getText();
                ResourceFilterControlGroupIO.this.fFilesTree.resetFilters();
                ResourceFilterControlGroupIO.this.fFilesTree.addFilter((ViewerFilter)new CustomViewFilter(filterText));
                ResourceFilterControlGroupIO.this.refresh();
            }
        });
        this.fFilesTree = new CheckboxTreeViewer((Composite)this.templatesTreeGroup, 0x10000B00);
        this.fFilesTree.setUseHashlookup(true);
        GridData filesTreeGridData = new GridData(4, 4, true, true, 3, 1);
        filesTreeGridData.heightHint = height == 0 ? 500 : height;
        filesTreeGridData.widthHint = width == 0 ? 600 : width;
        this.fFilesTree.getTree().setLayoutData((Object)filesTreeGridData);
        ContentProvider provider = new ContentProvider();
        this.fFilesTree.setContentProvider((IContentProvider)provider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.fFilesTree, (int)2);
        this.fFilesTree.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.fFilesTree.setInput((Object)new File(this.fRootPath));
        this.fFilesTree.getTree().setFocus();
        this.fCustomCheckStateListener = new CustomCheckStateListener();
        this.fFilesTree.addCheckStateListener((ICheckStateListener)this.fCustomCheckStateListener);
        this.fFilesTree.addTreeListener(new ITreeViewerListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                final File elem = (File)event.getElement();
                if (!ResourceFilterControlGroupIO.this.fWasExpanded.containsKey(elem) || !ResourceFilterControlGroupIO.this.fWasExpanded.get(elem).booleanValue()) {
                    ResourceFilterControlGroupIO.this.countFiles(elem);
                    ResourceFilterControlGroupIO.this.fWasExpanded.put(elem, true);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ResourceFilterControlGroupIO.this.fFilesTree.refresh((Object)elem, true);
                        }
                    });
                }
                boolean isChecked = ResourceFilterControlGroupIO.this.fCheckedFilesReg.contains(elem);
                boolean isAnyChildChecked = false;
                File[] files = ResourceFilterControlGroupIO.this.customListFiles(elem);
                int index = 0;
                while (!isAnyChildChecked && index < files.length) {
                    isAnyChildChecked = ResourceFilterControlGroupIO.this.fCheckedFilesReg.contains(files[index]);
                    ++index;
                }
                if (isAnyChildChecked && isChecked) {
                    ResourceFilterControlGroupIO.this.refresh();
                    return;
                }
                int i = 0;
                while (i < files.length) {
                    if (isChecked) {
                        ResourceFilterControlGroupIO.this.fCheckedFilesReg.add(files[i]);
                    } else {
                        ResourceFilterControlGroupIO.this.fCheckedFilesReg.remove(files[i]);
                        ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.remove(files[i]);
                    }
                    ++i;
                }
                ResourceFilterControlGroupIO.this.refresh();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                File elem = (File)event.getElement();
                boolean isChecked = ResourceFilterControlGroupIO.this.fCheckedFilesReg.contains(elem);
                boolean isAnyChildUnChecked = false;
                File[] files = ResourceFilterControlGroupIO.this.customListFiles(elem);
                int index = 0;
                while (!isAnyChildUnChecked && index < files.length) {
                    isAnyChildUnChecked = !ResourceFilterControlGroupIO.this.fCheckedFilesReg.contains(files[index]);
                    ++index;
                }
                if (isAnyChildUnChecked && isChecked) {
                    return;
                }
                int i = 0;
                while (i < files.length) {
                    ResourceFilterControlGroupIO.this.fCheckedFilesReg.remove(files[i]);
                    ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.remove(files[i]);
                    ++i;
                }
                ResourceFilterControlGroupIO.this.refresh();
            }
        });
        this.fFilesTree.getTree().addListener(35, new Listener(){

            public void handleEvent(Event event) {
                Menu menu = new Menu((Decorations)ResourceFilterControlGroupIO.this.getShell(), 8);
                MenuItem item_new = new MenuItem(menu, 2056);
                item_new.setText("Show more files...");
                item_new.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        ITreeSelection selection = (ITreeSelection)(this).ResourceFilterControlGroupIO.this.fFilesTree.getSelection();
                        File selectedFile = (File)selection.getFirstElement();
                        InputDialog dlg = new InputDialog(Display.getCurrent().getActiveShell(), "Show More Children", "How many children (min 1; max 9999):", String.valueOf((this).ResourceFilterControlGroupIO.this.CURRENT_NUMBER_OF_CHILDREN.get()), null);
                        if (dlg.open() == 0) {
                            try {
                                int newNr = Integer.parseInt(dlg.getValue());
                                if (newNr > 0) {
                                    (this).ResourceFilterControlGroupIO.this.fCountLimit.put(selectedFile, newNr);
                                }
                                ResourceFilterControlGroupIO.this.countFiles(selectedFile);
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ResourceFilterControlGroupIO.this.refresh();
                                    }
                                });
                            }
                            catch (Exception exception) {}
                        }
                    }
                });
                ITreeSelection selection = (ITreeSelection)ResourceFilterControlGroupIO.this.fFilesTree.getSelection();
                File firstElement = (File)selection.getFirstElement();
                if (ResourceFilterControlGroupIO.this.fTranslatedLink.containsKey(firstElement)) {
                    firstElement = ResourceFilterControlGroupIO.this.fTranslatedLink.get(firstElement);
                }
                if (!firstElement.isDirectory()) {
                    return;
                }
                menu.setLocation(event.x, event.y);
                menu.setVisible(true);
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (PlatformUI.getWorkbench().getDisplay().readAndDispatch()) continue;
                    PlatformUI.getWorkbench().getDisplay().sleep();
                }
                menu.dispose();
            }
        });
        this.filesNrLimitLabel = new Label((Composite)this.templatesTreeGroup, 0);
        this.filesNrLimitLabel.setText("Maximum number of children for each directory (between 1 and 9999):");
        this.filesNrLimitLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.filesNrLimit = new Text((Composite)this.templatesTreeGroup, 2048);
        this.filesNrLimit.setText(String.valueOf(this.CURRENT_NUMBER_OF_CHILDREN.get()));
        this.filesNrLimit.setLayoutData((Object)new GridData(4, 4, true, false));
        this.filesNrLimit.setTextLimit(4);
        this.refreshFilesNr = new Button((Composite)this.templatesTreeGroup, 0);
        this.refreshFilesNr.setText("Refresh");
        this.refreshFilesNr.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 2));
        this.refreshFilesNr.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String nrStr = ResourceFilterControlGroupIO.this.filesNrLimit.getText();
                try {
                    Integer nr = Integer.parseInt(nrStr);
                    if (nr <= 0) {
                        return;
                    }
                    ResourceFilterControlGroupIO.this.CURRENT_NUMBER_OF_CHILDREN.set(nr);
                    ResourceFilterControlGroupIO.this.fFilesMap = new HashMap<String, File[]>();
                    ResourceFilterControlGroupIO.this.fCountLimit = new HashMap<File, Integer>();
                    ResourceFilterControlGroupIO.this.fWasExpanded = new HashMap<File, Boolean>();
                    ResourceFilterControlGroupIO.this.fNrOfFilesRecursively = new HashMap<File, Integer>();
                    ResourceFilterControlGroupIO.this.fRecursiveSymLinks = new RecursiveSymLinks(new File(ResourceFilterControlGroupIO.this.fRootPath));
                    ResourceFilterControlGroupIO.this.fFilesTree.collapseAll();
                    ResourceFilterControlGroupIO.this.countFiles(new File(ResourceFilterControlGroupIO.this.fRootPath));
                    String nrStr2 = ResourceFilterControlGroupIO.this.fTimeOutLimit.getText();
                    Integer nr2 = Integer.parseInt(nrStr2);
                    ResourceFilterControlGroupIO.this.CURRENT_TIMEOUT_MILLISECONDS.set(nr2 * 1000);
                    BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ResourceFilterControlGroupIO.this.refresh();
                        }
                    });
                }
                catch (Exception exception) {
                    ResourceFilterControlGroupIO.this.filesNrLimit.setText(String.valueOf(ResourceFilterControlGroupIO.this.CURRENT_NUMBER_OF_CHILDREN.get()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.timeoutLimitLabel = new Label((Composite)this.templatesTreeGroup, 0);
        this.timeoutLimitLabel.setText("Timeout for children listing (in seconds):");
        this.timeoutLimitLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fTimeOutLimit = new Combo((Composite)this.templatesTreeGroup, 12);
        int i = 1;
        while (i < 10) {
            this.fTimeOutLimit.add(String.valueOf(i));
            ++i;
        }
        this.fTimeOutLimit.select(5);
        this.filesNrLimit.setLayoutData((Object)new GridData(4, 4, true, false));
        this.noteRightClickMenu = new Label((Composite)this.templatesTreeGroup, 0);
        this.noteRightClickMenu.setText("NOTE: You can also right-click on a directory and select how many children to be displayed");
        this.noteRightClickMenu.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        Composite selectDeselectButtonsComposite = new Composite((Composite)this.templatesTreeGroup, 0);
        GridLayout layout = new GridLayout(2, false);
        selectDeselectButtonsComposite.setLayout((Layout)layout);
        selectDeselectButtonsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.selectAllButton = new Button(selectDeselectButtonsComposite, 0);
        this.selectAllButton.setText("Select All");
        this.selectAllButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List<File> expandedChildren = ResourceFilterControlGroupIO.this.getAllExpandedChildrenFiles(new File(ResourceFilterControlGroupIO.this.fRootPath));
                for (File file : expandedChildren) {
                    if (ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.contains(file)) {
                        ResourceFilterControlGroupIO.this.fFilesTree.setGrayChecked((Object)file, false);
                    }
                    ResourceFilterControlGroupIO.this.fCheckedFilesReg.add(file);
                }
                ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.clear();
                ResourceFilterControlGroupIO.this.fFilesTree.setAllChecked(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.deSelectAllButton = new Button(selectDeselectButtonsComposite, 0);
        this.deSelectAllButton.setText("Deselect All");
        this.deSelectAllButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.deSelectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResourceFilterControlGroupIO.this.fFilesTree.setAllChecked(false);
                ResourceFilterControlGroupIO.this.fCheckedFilesReg.clear();
                ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.clear();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setContentEnabledState(ResourceFilterUtils.getFiltersSelection(this) == ResourceFiltersManager.FiltersSelectionType.NONE);
        this.autoFilterCheckbox.addListener(13, event -> {
            boolean enabledSTate = !this.autoFilterCheckbox.getSelection() && !this.firstLevelFilterCheckbox.getSelection();
            this.setContentEnabledState(enabledSTate);
        });
        this.firstLevelFilterCheckbox.addListener(13, event -> {
            boolean enabledSTate = !this.autoFilterCheckbox.getSelection() && !this.firstLevelFilterCheckbox.getSelection();
            this.setContentEnabledState(enabledSTate);
        });
        this.resetToSerializedCheckedPaths(new HashSet<File>());
        return composite;
    }

    public void refresh() {
        if (this.fFilesTree == null) {
            return;
        }
        this.fFilesTree.setAllChecked(false);
        for (File file : this.fCheckedFilesReg) {
            if (this.fPartCheckedFilesReg.contains(file)) {
                this.fFilesTree.setGrayChecked((Object)file, true);
                continue;
            }
            this.fFilesTree.setGrayChecked((Object)file, false);
            this.fFilesTree.setChecked((Object)file, true);
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> this.fFilesTree.refresh(true));
    }

    public void resetToSerializedCheckedPaths(Set<File> files) {
        File file;
        if (this.fIgnoreSerializedFilters) {
            return;
        }
        this.fCheckedFilesReg.clear();
        this.fCachedCheckedFilesReg.clear();
        this.fPartCheckedFilesReg.clear();
        this.fCheckedFilesReg.addAll(files);
        this.fCachedCheckedFilesReg.addAll(files);
        Set<String> previoulsyCheckedPaths = ResourceFilterUtils.getFilteredPathsFromProject(this.fRootPath);
        for (String path : previoulsyCheckedPaths) {
            file = new File(String.valueOf(this.fRootPath) + File.separator + path);
            this.checkOldPaths(file);
        }
        for (String path : this.fExcludedPaths) {
            file = new File(path);
            if (!file.isAbsolute()) {
                file = new File(String.valueOf(this.fRootPath) + File.separator + path);
            }
            this.checkOldPaths(file);
        }
        this.refresh();
    }

    private void checkOldPaths(File file) {
        File parent = file.getParentFile();
        while (parent != null && !parent.getAbsolutePath().equals(this.fRootPath)) {
            this.fPartCheckedFilesReg.add(parent);
            this.fCachedCheckedFilesReg.add(parent);
            this.fCheckedFilesReg.add(parent);
            parent = parent.getParentFile();
        }
        this.fCheckedFilesReg.add(file);
        this.fCachedCheckedFilesReg.add(file);
    }

    public void updateLinks() {
        if (this.fProject != null) {
            this.fLinkFiles = new HashMap<File, LinkDescription>();
            this.fLinkParents = new HashMap<File, List<File>>();
            this.fTranslatedLink = new HashMap<File, File>();
            ProjectDescription projectDescription = ResourceFilterUtils.getProjectDescription(this.fRootPath);
            if (projectDescription == null) {
                return;
            }
            HashMap links = projectDescription.getLinks();
            if (links == null) {
                return;
            }
            for (Map.Entry entry : links.entrySet()) {
                LinkDescription linkDesc;
                IPath key = (IPath)entry.getKey();
                if (key.segment(0).equals("DVT Auto-Linked") || (linkDesc = (LinkDescription)entry.getValue()).getLocationURI().toString().startsWith("virtual:/virtual")) continue;
                File linkFile = new File(String.valueOf(this.fRootPath) + File.separator + key.toOSString());
                File linkParent = linkFile.getParentFile();
                this.fLinkFiles.put(linkFile, (LinkDescription)entry.getValue());
                String uriStr = ResourceFilterUtils.expandDvtEnvVars(URIUtil.toPath((URI)linkDesc.getLocationURI()).toOSString());
                File translatedFile = new File(DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(uriStr, DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, null));
                this.fTranslatedLink.put(linkFile, translatedFile);
                List<File> list = this.fLinkParents.get(linkParent);
                if (list == null) {
                    list = new ArrayList<File>();
                }
                list.add(linkFile);
                this.fLinkParents.put(linkParent, list);
            }
        }
    }

    private Set<File> getFilesSelectedDelta() {
        HashSet<File> filesSelectedNow = new HashSet<File>();
        Set<String> previoulsyCheckedPaths = ResourceFilterUtils.getFilteredPathsFromProject(this.fRootPath);
        for (File file : this.fCheckedFilesReg) {
            if (previoulsyCheckedPaths.contains(file.getAbsolutePath().replace(String.valueOf(this.fRootPath) + File.separator, ""))) continue;
            filesSelectedNow.add(file);
        }
        return filesSelectedNow;
    }

    private Set<File> getAllCheckedChildren(File root) {
        HashSet<File> result = new HashSet<File>();
        for (File selectedPath : this.fCheckedFilesReg) {
            if (!selectedPath.getPath().startsWith(String.valueOf(root.getPath()) + File.separator)) continue;
            result.add(selectedPath);
        }
        return result;
    }

    public Set<String> getCheckedPaths() {
        HashSet<String> result = new HashSet<String>();
        HashSet<File> tmpFiles = new HashSet<File>();
        Set<File> returnedCheckedFilesReg = this.fFilesTree.getTree().getEnabled() ? this.fCheckedFilesReg : this.fCachedCheckedFilesReg;
        tmpFiles.addAll(returnedCheckedFilesReg);
        for (File checkedFile : returnedCheckedFilesReg) {
            if (this.fTranslatedLink.containsKey(checkedFile)) {
                checkedFile = this.fTranslatedLink.get(checkedFile);
            }
            if (!checkedFile.isDirectory() || !this.hasAllChildrenChecked(checkedFile)) continue;
            tmpFiles.removeAll(this.getAllCheckedChildren(checkedFile));
        }
        for (File selectedPath : tmpFiles) {
            boolean isExcluded = false;
            if (!this.hasAllChildrenChecked(selectedPath)) {
                for (File selectedPath2 : tmpFiles) {
                    if (isExcluded || selectedPath2.equals(selectedPath) || !selectedPath2.getAbsolutePath().startsWith(String.valueOf(selectedPath.getAbsolutePath()) + File.separator)) continue;
                    isExcluded = true;
                }
            }
            if (isExcluded) continue;
            result.add(selectedPath.getPath().replace(String.valueOf(this.fRootPath) + File.separator, ""));
        }
        return result;
    }

    private void countFiles(File root) {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, monitor -> {
                monitor.beginTask("List directory's children...", -1);
                int fileCountLimit = this.CURRENT_NUMBER_OF_CHILDREN.get();
                if (this.fCountLimit.containsKey(root)) {
                    fileCountLimit = this.fCountLimit.get(root);
                }
                long startTimeMillis = System.currentTimeMillis();
                try {
                    List<File> firstChildren = this.cf(root, this.CURRENT_TIMEOUT_MILLISECONDS.get(), fileCountLimit, monitor);
                    for (File file2 : firstChildren) {
                        if (monitor.isCanceled() || System.currentTimeMillis() - startTimeMillis >= (long)this.CURRENT_TIMEOUT_MILLISECONDS.get()) {
                            return;
                        }
                        this.cf(file2, this.CURRENT_TIMEOUT_MILLISECONDS.get(), fileCountLimit, monitor);
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                monitor.done();
            });
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private List<File> cf(File root, long timeout, int limit, IProgressMonitor monitor) {
        boolean isLinkedResource = false;
        File originalRoot = root;
        List<Object> links = new ArrayList();
        if (this.fLinkParents.containsKey(root)) {
            links = this.fLinkParents.get(root);
        }
        if (this.fTranslatedLink.containsKey(root)) {
            root = this.fTranslatedLink.get(root);
            isLinkedResource = true;
        }
        if (root.isDirectory()) {
            List<Object> tmp = new ArrayList();
            List<File> children = ResourceFilterUtils.customOptListFiles(root, limit, timeout);
            int nrOfChildren = 0;
            if (children == null) {
                File[] listFiles = root.listFiles();
                if (listFiles == null) {
                    return new ArrayList<File>();
                }
                tmp = new ArrayList<File>(Arrays.asList(listFiles));
            } else {
                tmp = children;
            }
            nrOfChildren = tmp.size();
            ArrayList<File> tmpList = new ArrayList<File>();
            for (File file : tmp) {
                if (!file.canRead() || ResourceFilterUtils.RESTRICTED_PATHS_LIST.contains(file.getName()) || ResourceFilterUtils.isSymlink(file) && file.isDirectory() && this.fRecursiveSymLinks.isRecursiveLink(file)) continue;
                tmpList.add(file);
            }
            tmp = tmpList;
            if (isLinkedResource) {
                tmpList = new ArrayList();
                for (File file : tmp) {
                    File nFile = new File(originalRoot + File.separator + file.getName());
                    this.fTranslatedLink.put(nFile, file);
                    tmpList.add(nFile);
                }
                tmp = tmpList;
            }
            if (!links.isEmpty()) {
                tmp.addAll(links);
            }
            Collections.sort(tmp);
            this.fFilesMap.put(originalRoot.getAbsolutePath(), tmp.toArray(new File[0]));
            this.fNrOfFiles.put(originalRoot, nrOfChildren);
            if (nrOfChildren < 50) {
                this.fNrOfFilesRecursively.put(originalRoot, ResourceFilterUtils.countChildrenRecursively(root, limit, timeout, false));
            } else {
                this.fNrOfFilesRecursively.put(originalRoot, nrOfChildren);
            }
            File file = originalRoot.getParentFile();
            if (file != null && this.fNrOfFilesRecursively.containsKey(file)) {
                this.fNrOfFilesRecursively.put(file, nrOfChildren + this.fNrOfFilesRecursively.get(file));
            }
            return tmp;
        }
        return new ArrayList<File>();
    }

    private File[] customListFiles(File root) {
        if (this.fFilesMap.containsKey(root.getAbsolutePath())) {
            return this.fFilesMap.get(root.getAbsolutePath());
        }
        return new File[0];
    }

    private boolean hasAllChildrenChecked(File rootFile) {
        File[] children;
        File[] fileArray = children = this.customListFiles(rootFile);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (!this.fCheckedFilesReg.contains(child) || this.fPartCheckedFilesReg.contains(child)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private List<File> getAllExpandedChildrenFiles(File root) {
        ArrayList<File> result = new ArrayList<File>();
        result.addAll(Arrays.asList(this.customListFiles(root)));
        ArrayList<File> tmp = new ArrayList<File>();
        for (File file : result) {
            if (!this.fFilesTree.getExpandedState((Object)file)) continue;
            tmp.addAll(this.getAllExpandedChildrenFiles(file));
        }
        result.addAll(tmp);
        return result;
    }

    private void setContentEnabledState(boolean enabledState) {
        this.templatesTreeGroup.setEnabled(enabledState);
        this.fFilesTree.getTree().setEnabled(enabledState);
        this.fFilterText.setEnabled(enabledState);
        this.filesNrLimitLabel.setEnabled(enabledState);
        this.refreshFilesNr.setEnabled(enabledState);
        this.filesNrLimit.setEnabled(enabledState);
        this.selectAllButton.setEnabled(enabledState);
        this.deSelectAllButton.setEnabled(enabledState);
        this.timeoutLimitLabel.setEnabled(enabledState);
        this.noteRightClickMenu.setEnabled(enabledState);
        this.fTimeOutLimit.setEnabled(enabledState);
    }

    public void updateCachedCheckedFiles() {
        this.fCachedCheckedFilesReg.clear();
        this.fCachedCheckedFilesReg.addAll(this.fCheckedFilesReg);
    }

    public void activateBothFilterCheckboxed() {
        this.firstLevelFilterCheckbox.setSelection(true);
        this.autoFilterCheckbox.setSelection(true);
        this.setContentEnabledState(false);
    }

    private class ContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            File file = (File)inputElement;
            return ResourceFilterControlGroupIO.this.customListFiles(file);
        }

        public Object[] getChildren(Object parentElement) {
            return ResourceFilterControlGroupIO.this.customListFiles((File)parentElement);
        }

        public Object getParent(Object element) {
            return ((File)element).getParentFile();
        }

        public boolean hasChildren(Object element) {
            File file = (File)element;
            return ResourceFilterControlGroupIO.this.customListFiles(file).length > 0;
        }
    }

    private class CustomCheckStateListener
    implements ICheckStateListener {
        /*
         * Unable to fully structure code
         */
        public void checkStateChanged(CheckStateChangedEvent event) {
            block16: {
                clickedFile = (File)event.getElement();
                clickedFileParent = clickedFile.getParentFile();
                isChecked = event.getChecked();
                while (clickedFileParent != null && !clickedFileParent.getAbsolutePath().equals(ResourceFilterControlGroupIO.this.fRootPath) && ResourceFilterControlGroupIO.this.fNrOfFiles.containsKey(clickedFileParent)) {
                    if (ResourceFilterControlGroupIO.this.fNrOfFiles.get(clickedFileParent) >= ResourceFilterControlGroupIO.this.CURRENT_NUMBER_OF_CHILDREN.get()) {
                        ResourceFilterControlGroupIO.this.fFilesTree.setChecked((Object)clickedFile, isChecked == false);
                        return;
                    }
                    clickedFileParent = clickedFileParent.getParentFile();
                }
                if (isChecked) {
                    ResourceFilterControlGroupIO.this.fCheckedFilesReg.add(clickedFile);
                } else {
                    ResourceFilterControlGroupIO.this.fCheckedFilesReg.remove(clickedFile);
                    ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.remove(clickedFile);
                }
                if (isChecked) {
                    if (ResourceFilterControlGroupIO.this.fFilesTree.getExpandedState((Object)clickedFile)) {
                        expandedChildren = ResourceFilterControlGroupIO.this.getAllExpandedChildrenFiles(clickedFile);
                        for (File childfile : expandedChildren) {
                            ResourceFilterControlGroupIO.this.fCheckedFilesReg.add(childfile);
                        }
                    }
                } else {
                    checkedElems = new HashSet<File>();
                    checkedElems.addAll(ResourceFilterControlGroupIO.this.fCheckedFilesReg);
                    for (File file : checkedElems) {
                        if (!file.getAbsolutePath().startsWith(String.valueOf(clickedFile.getAbsolutePath()) + File.separator)) continue;
                        ResourceFilterControlGroupIO.this.fCheckedFilesReg.remove(file);
                        ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.remove(file);
                    }
                }
                if (!isChecked) ** GOTO lbl56
                while (clickedFileParent != null && (clickedFileParent.exists() || ResourceFilterControlGroupIO.this.fTranslatedLink.containsKey(clickedFileParent)) && !clickedFileParent.getAbsolutePath().equals(ResourceFilterControlGroupIO.this.fRootPath)) {
                    ResourceFilterControlGroupIO.this.fCheckedFilesReg.add(clickedFileParent);
                    clickedFileParent = clickedFileParent.getParentFile();
                }
                break block16;
lbl-1000:
                // 1 sources

                {
                    anythingSelected = false;
                    files = ResourceFilterControlGroupIO.this.customListFiles(clickedFileParent);
                    index = 0;
                    while (!anythingSelected && index < files.length) {
                        anythingSelected = ResourceFilterControlGroupIO.this.fCheckedFilesReg.contains(files[index]);
                        ++index;
                    }
                    if (!anythingSelected) {
                        ResourceFilterControlGroupIO.this.fCheckedFilesReg.remove(clickedFileParent);
                    }
                    clickedFileParent = clickedFileParent.getParentFile();
lbl56:
                    // 2 sources

                    ** while (clickedFileParent != null && (clickedFileParent.exists() || ResourceFilterControlGroupIO.this.fTranslatedLink.containsKey((Object)clickedFileParent)) && !clickedFileParent.getAbsolutePath().equals((Object)ResourceFilterControlGroupIO.this.fRootPath))
                }
            }
            clickedFileParent = clickedFile.getParentFile();
            while (clickedFileParent != null && (clickedFileParent.exists() || ResourceFilterControlGroupIO.this.fTranslatedLink.containsKey(clickedFileParent)) && !clickedFileParent.getAbsolutePath().equals(ResourceFilterControlGroupIO.this.fRootPath)) {
                if (!ResourceFilterControlGroupIO.this.hasAllChildrenChecked(clickedFileParent) && ResourceFilterControlGroupIO.this.fCheckedFilesReg.contains(clickedFileParent)) {
                    ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.add(clickedFileParent);
                } else {
                    ResourceFilterControlGroupIO.this.fPartCheckedFilesReg.remove(clickedFileParent);
                }
                clickedFileParent = clickedFileParent.getParentFile();
            }
            ResourceFilterControlGroupIO.this.refresh();
        }
    }

    private class CustomViewFilter
    extends ViewerFilter {
        private StringMatcher fMatcher;

        public CustomViewFilter(String pattern) {
            if (pattern.isEmpty()) {
                this.fMatcher = null;
            }
            this.fMatcher = new StringMatcher("*" + pattern + "*", true, false);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (this.fMatcher == null || !(element instanceof File)) {
                return false;
            }
            File file = (File)element;
            if (ResourceFilterControlGroupIO.this.fFilesTree.getExpandedState((Object)file)) {
                Object[] children;
                ITreeContentProvider provider = (ITreeContentProvider)ResourceFilterControlGroupIO.this.fFilesTree.getContentProvider();
                Object[] objectArray = children = provider.getChildren(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.select(viewer, element, child)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            return this.fMatcher.match(file.getName());
        }
    }

    private class LabelProvider
    extends ColumnLabelProvider {
        private LabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            File file = (File)element;
            if (ResourceFilterControlGroupIO.this.fLinkFiles.containsKey(file)) {
                if ((file = ResourceFilterControlGroupIO.this.fTranslatedLink.get(file)).isDirectory()) {
                    return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER"), DVTImages.DESC_OVR_LINK, 3));
                }
                return DVTImages.imageCache.getImage((ImageDescriptor)new DecorationOverlayIcon(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE"), DVTImages.DESC_OVR_LINK, 3));
            }
            if (ResourceFilterControlGroupIO.this.fTranslatedLink.containsKey(file)) {
                file = ResourceFilterControlGroupIO.this.fTranslatedLink.get(file);
            }
            if (file.isDirectory()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }

        public String getText(Object element) {
            File file = (File)element;
            Integer nr = ResourceFilterControlGroupIO.this.fNrOfFilesRecursively.get(file);
            if (nr != null && nr > 0) {
                if (nr >= ResourceFilterControlGroupIO.this.CURRENT_NUMBER_OF_CHILDREN.get()) {
                    return String.valueOf(file.getName()) + "  (more than " + ResourceFilterControlGroupIO.this.CURRENT_NUMBER_OF_CHILDREN.get() + " children)";
                }
                return String.valueOf(file.getName()) + "  (" + nr + " children)";
            }
            return file.getName();
        }

        public String getToolTipText(Object element) {
            if (ResourceFilterControlGroupIO.this.fTranslatedLink.containsKey(element)) {
                return ResourceFilterControlGroupIO.this.fTranslatedLink.get(element).getAbsolutePath();
            }
            return ((File)element).getAbsolutePath();
        }

        public Color getForeground(Object element) {
            File file = (File)element;
            File parentFile = file.getParentFile();
            while (parentFile != null && !parentFile.getAbsolutePath().equals(ResourceFilterControlGroupIO.this.fRootPath) && ResourceFilterControlGroupIO.this.fNrOfFiles.containsKey(parentFile)) {
                if (ResourceFilterControlGroupIO.this.fNrOfFiles.get(parentFile) >= ResourceFilterControlGroupIO.this.CURRENT_NUMBER_OF_CHILDREN.get()) {
                    return DVTColorUtil.INSTANCE.getColor(192, 192, 192);
                }
                parentFile = parentFile.getParentFile();
            }
            if (this.getText(element).contains("more than")) {
                return DVTColorUtil.INSTANCE.getColor(255, 0, 0);
            }
            return super.getForeground(element);
        }
    }
}

