/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.resourcefilters.NewProjectResourceFiltersWrapper;
import ro.amiq.dvt.resourcefilters.ResourceFilterControlGroupIO;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;

public class ResourceFilterMessageDialog
extends MessageDialog {
    private Set<String> fCheckedPaths = new HashSet<String>();
    private ResourceFilterControlGroupIO fResourceControl;
    private boolean cancelled = true;
    private ResourceFiltersManager.FiltersSelectionType filtersSelection = ResourceFiltersManager.FiltersSelectionType.NONE;

    public ResourceFilterMessageDialog(String dialogMessage, String rootPath, IProject project, boolean ignoreSerializedFilters, boolean ignoreEmptySerializedFilters) {
        this(dialogMessage, rootPath, project, ignoreSerializedFilters, ignoreEmptySerializedFilters, Collections.emptySet());
    }

    public ResourceFilterMessageDialog(String dialogMessage, String rootPath, IProject project, boolean ignoreSerializedFilters, boolean ignoreEmptySerializedFilters, Set<String> excludedPaths) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Resource Filter", null, dialogMessage, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.fResourceControl = new ResourceFilterControlGroupIO(rootPath, project, ignoreSerializedFilters, excludedPaths);
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public ResourceFiltersManager.FiltersSelectionType getFiltersSelection() {
        return this.filtersSelection;
    }

    protected Control createCustomArea(Composite parent) {
        Object play = parent.getLayoutData();
        if (play instanceof GridData) {
            ((GridData)play).grabExcessHorizontalSpace = true;
            ((GridData)play).grabExcessVerticalSpace = true;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridData layout = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layout);
        Composite resourceFilterGroup = this.fResourceControl.createGroup(composite);
        this.fResourceControl.activateBothFilterCheckboxed();
        return resourceFilterGroup;
    }

    protected Control createMessageArea(Composite composite) {
        return super.createMessageArea(composite);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.fCheckedPaths = this.fResourceControl.getCheckedPaths();
            this.cancelled = false;
            this.filtersSelection = ResourceFilterUtils.getFiltersSelection(this.fResourceControl);
        } else {
            this.fCheckedPaths = null;
        }
        super.buttonPressed(buttonId);
    }

    public NewProjectResourceFiltersWrapper openCustom() {
        super.open();
        return new NewProjectResourceFiltersWrapper(this.fCheckedPaths, this.filtersSelection);
    }

    protected boolean isResizable() {
        return true;
    }

    protected boolean canHandleShellCloseEvent() {
        return false;
    }
}

