/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.json.JSONException;
import org.json.JSONObject;
import ro.amiq.dvt.cli.CreateProject;
import ro.amiq.dvt.resourcefilters.ApplyDVTResourceFiltersJob;
import ro.amiq.dvt.resourcefilters.FileType;
import ro.amiq.dvt.resourcefilters.NewProjectResourceFiltersWrapper;
import ro.amiq.dvt.resourcefilters.ResourceFilterControlGroupIO;
import ro.amiq.dvt.resourcefilters.ResourceFilterMessageDialog;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.AutoFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.resourcefilters.autofilters.DbOutOfSyncDialogStatus;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModelManager;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.variableresolvers.DVTEnvVariableResolver;
import ro.amiq.dvt.utils.DVTProcessRunner;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.JarUtils;

public class ResourceFilterUtils {
    public static final String DVT_FILTER_DESCRIPTION = "1.0-projectRelativePath-matches-true-false-";
    public static final int MAX_NUMBER_OF_CHILDREN_IN_FOLDER = 50000;
    public static final int TIMEOUT = 10000;
    private static final Pattern BATCH_JAR_PATTERN = Pattern.compile("ro.amiq.dvt.batch-\\S+\\.jar");
    public static final List<String> RESTRICTED_PATHS_LIST = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("DVT Auto-Linked");
            this.add(".project");
            this.add(".dvt");
        }
    };

    protected static boolean isDVTFilter(FilterDescription filterDescription) {
        if (!filterDescription.getFileInfoMatcherDescription().getId().equals("ro.amiq.dvt.multiFilter")) {
            return false;
        }
        Object args = filterDescription.getFileInfoMatcherDescription().getArguments();
        if (!(args instanceof String)) {
            return false;
        }
        String strArgs = (String)args;
        return strArgs.startsWith(DVT_FILTER_DESCRIPTION);
    }

    public static Set<String> getFilteredPathsFromProject(String projectPath) {
        HashSet<String> paths = new HashSet<String>();
        Collection<LinkedList<FilterDescription>> allFilters = ResourceFilterUtils.getAllFilters(projectPath, (IProgressMonitor)new NullProgressMonitor());
        for (LinkedList<FilterDescription> filters : allFilters) {
            if (filters == null) continue;
            for (FilterDescription filterDescription : filters) {
                String strArgs;
                Object args;
                if (!ResourceFilterUtils.isDVTFilter(filterDescription) || (filterDescription.getType() & 1) != 0 || !((args = filterDescription.getFileInfoMatcherDescription().getArguments()) instanceof String) || !(strArgs = (String)args).contains("-")) continue;
                String[] arrArgs = strArgs.split("-");
                StringBuilder pathBuffer = new StringBuilder();
                int i = 5;
                while (i < arrArgs.length) {
                    if (i == arrArgs.length - 1) {
                        pathBuffer.append(arrArgs[i]);
                    } else {
                        pathBuffer.append(String.valueOf(arrArgs[i]) + "-");
                    }
                    ++i;
                }
                paths.add(pathBuffer.toString());
            }
        }
        return paths;
    }

    protected static boolean hasOtherFiltersDefined(String projectPath) {
        Collection<LinkedList<FilterDescription>> allFilters = ResourceFilterUtils.getAllFilters(projectPath, (IProgressMonitor)new NullProgressMonitor());
        for (LinkedList<FilterDescription> filters : allFilters) {
            if (filters == null) continue;
            for (FilterDescription filterDescription : filters) {
                if (ResourceFilterUtils.isDVTFilter(filterDescription)) continue;
                return true;
            }
        }
        return false;
    }

    protected static Collection<LinkedList<FilterDescription>> getAllFilters(String projectPath, IProgressMonitor monitor) {
        File dotProjFile = new File(projectPath, ".project");
        if (!dotProjFile.exists()) {
            return Collections.emptyList();
        }
        IProjectDescription description = null;
        Path path = new Path(dotProjFile.getPath());
        try {
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        ProjectDescription projectDescription = (ProjectDescription)description;
        HashMap filterMap = projectDescription.getFilters();
        if (filterMap == null) {
            return Collections.emptyList();
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        Collection<LinkedList<FilterDescription>> allFilters = filterMap.values();
        return allFilters;
    }

    public static ProjectDescription getProjectDescription(IProject project) {
        if (project == null) {
            return null;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            projectDescription = ResourceFilterUtils.internalGetProjectDescription(project);
        }
        return projectDescription;
    }

    private static ProjectDescription internalGetProjectDescription(IProject project) {
        IPath location = project.getLocation();
        if (location == null) {
            return null;
        }
        String projectPath = location.toOSString();
        File dotProjFile = new File(projectPath, ".project");
        if (!dotProjFile.exists()) {
            return null;
        }
        IProjectDescription description = null;
        Path path = new Path(dotProjFile.getPath());
        try {
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        }
        catch (Exception exception) {
            return null;
        }
        return (ProjectDescription)description;
    }

    public static ProjectDescription getProjectDescription(String projectPath) {
        File dotProjFile = new File(projectPath, ".project");
        if (!dotProjFile.exists()) {
            return null;
        }
        IProjectDescription description = null;
        Path path = new Path(dotProjFile.getPath());
        try {
            description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        }
        catch (Exception exception) {
            return null;
        }
        return (ProjectDescription)description;
    }

    public static void applyDvtFilters(IProject project, Set<String> filteredPaths, boolean updateResourceMonitor) {
        ApplyDVTResourceFiltersJob job = new ApplyDVTResourceFiltersJob(project, filteredPaths, updateResourceMonitor);
        job.setUser(true);
        job.schedule();
    }

    public static void appendDvtFilters(IProject project, Set<String> filteredPaths, boolean startResourceMonitor) {
        if (filteredPaths.isEmpty()) {
            return;
        }
        Set<String> existingPaths = ResourceFilterUtils.getFilteredPathsFromProject(project.getLocation().toOSString());
        existingPaths.addAll(filteredPaths);
        ResourceFilterUtils.applyDvtFilters(project, existingPaths, startResourceMonitor);
    }

    protected static List<File> customOptListFiles(File root, int limit, long timeoutMillis) {
        long startTime = System.currentTimeMillis();
        NullPointerException exception = new NullPointerException("Directory has more than " + limit + " files.");
        List<File> result = new ArrayList<File>();
        try {
            result = ResourceFilterUtils.getChilden(root, limit, 0, timeoutMillis, startTime, exception);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private static List<File> getChilden(File root, int limit, int currNofFiles, long timeoutMillis, long startTimeMillis, NullPointerException exception) {
        ArrayList<File> result = new ArrayList<File>();
        try {
            root.listFiles(pathname -> {
                if (result.size() + currNofFiles >= limit || System.currentTimeMillis() - startTimeMillis >= timeoutMillis) {
                    throw exception;
                }
                result.add(pathname);
                return false;
            });
        }
        catch (NullPointerException nullPointerException) {
            return result;
        }
        return result;
    }

    public static int countChildrenRecursively(File root, int limit, long timeoutMillis, boolean withProgressMonitor) {
        return ResourceFilterUtils.countChildrenRecursively(root, limit, timeoutMillis, withProgressMonitor, Collections.emptyMap(), Collections.emptySet(), Collections.emptySet());
    }

    public static int countChildrenRecursively(File root, int limit, long timeoutMillis, boolean withProgressMonitor, Map<IContainer, List<Filter>> filters, Set<Pattern> excludedFiles, Set<Pattern> includedFiles) {
        boolean hasIncludeFilters;
        long startTime = System.currentTimeMillis();
        NullPointerException exception = new NullPointerException("Directory has more than " + limit + " files.");
        AtomicInteger aInteger = new AtomicInteger(0);
        boolean bl = hasIncludeFilters = !includedFiles.isEmpty() || filters.values().stream().anyMatch(filterList -> filterList.stream().anyMatch(filter -> filter.isIncludeOnly()));
        if (withProgressMonitor) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            try {
                dialog.run(true, false, monitor -> {
                    monitor.beginTask("Checking directory...", -1);
                    aInteger.set(ResourceFilterUtils.intCountChildrenRecursively(root, limit, 0, timeoutMillis, startTime, exception, hasIncludeFilters, filters, excludedFiles, includedFiles));
                    monitor.done();
                });
                dialog.close();
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        } else {
            return ResourceFilterUtils.intCountChildrenRecursively(root, limit, 0, timeoutMillis, startTime, exception, hasIncludeFilters, filters, excludedFiles, includedFiles);
        }
        return aInteger.get();
    }

    private static int intCountChildrenRecursively(File root, int limit, int currNofFiles, long timeoutMillis, long startTimeMillis, NullPointerException exception, boolean hasIncludeFilters, Map<IContainer, List<Filter>> filters, Set<Pattern> excludedFiles, Set<Pattern> includedFiles) {
        LinkedList result = new LinkedList();
        int tmpNrOfFiles = currNofFiles;
        try {
            root.listFiles(pathname -> {
                if (result.size() + tmpNrOfFiles >= limit || System.currentTimeMillis() - startTimeMillis >= timeoutMillis) {
                    throw exception;
                }
                String absolutePath = pathname.getAbsolutePath();
                if (excludedFiles.stream().anyMatch(filter -> DVTStringUtil.matches(filter, absolutePath) || absolutePath.equals(filter.toString()))) {
                    return false;
                }
                if (includedFiles.stream().anyMatch(filter -> DVTStringUtil.matches(filter, absolutePath) || absolutePath.equals(filter.toString()))) {
                    result.add(pathname);
                }
                if (ResourceFilterUtils.isFiltered(pathname, filters, hasIncludeFilters, result)) {
                    return false;
                }
                result.add(pathname);
                return false;
            });
        }
        catch (NullPointerException nullPointerException) {
            return limit;
        }
        if ((currNofFiles += result.size()) >= limit) {
            return limit;
        }
        for (File child : result) {
            if (!child.isDirectory() || (currNofFiles = ResourceFilterUtils.intCountChildrenRecursively(child, limit, currNofFiles, timeoutMillis, startTimeMillis, exception, hasIncludeFilters, filters, excludedFiles, includedFiles)) < limit) continue;
            return limit;
        }
        return currNofFiles;
    }

    public static String toDvtEnvVars(String input) {
        try {
            input = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(input, false);
        }
        catch (Exception exception) {}
        Pattern pattern = Pattern.compile("((\\$\\{?[a-zA-Z_][a-zA-Z0-9_]*\\}?)|(%[a-zA-Z_][a-zA-Z0-9_]*%))", 8);
        Matcher matcher = pattern.matcher(input);
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        String result = input;
        while (matcher.find()) {
            String value;
            String variable = matcher.group(1);
            if (variable == null || variable.contains("{") && !variable.endsWith("}") || variable.contains("%") && !variable.endsWith("%") || (value = DVTEnvVariableResolver.toDvtEnvVariables((CharSequence)variable)) == null) continue;
            replaceMap.put(variable, value);
        }
        for (Map.Entry entry : replaceMap.entrySet()) {
            String key = (String)entry.getKey();
            while (result.contains(key)) {
                result = result.replace(key, (CharSequence)entry.getValue());
            }
        }
        return result;
    }

    public static String expandDvtEnvVars(String input) {
        Pattern pattern = Pattern.compile("(\\$\\{(DVT_ENV\\-[a-zA-Z_][a-zA-Z0-9_]*)\\})", 8);
        Matcher matcher = pattern.matcher(input);
        HashMap<String, String> replaceMap = new HashMap<String, String>();
        DVTEnvVariableResolver resolver = new DVTEnvVariableResolver();
        String result = input;
        while (matcher.find()) {
            String varName;
            String variable = matcher.group(1);
            if (variable == null || (varName = matcher.group(2)) == null) continue;
            URI uri = null;
            try {
                String value = resolver.getValue(varName, null);
                if (value != null) {
                    if (value.endsWith(File.separator)) {
                        value = value.substring(0, value.length() - 1);
                    }
                    uri = new URI(value);
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            if (uri == null) continue;
            replaceMap.put(variable, URIUtil.toPath(uri).toOSString());
        }
        for (Map.Entry entry : replaceMap.entrySet()) {
            String key = (String)entry.getKey();
            while (result.contains(key)) {
                result = result.replace(key, (CharSequence)entry.getValue());
            }
        }
        return result;
    }

    protected static boolean isSymlink(File file) {
        try {
            File canon;
            if (file.getParent() == null) {
                canon = file;
            } else {
                File canonDir = file.getParentFile().getCanonicalFile();
                canon = new File(canonDir, file.getName());
            }
            return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    public static NewProjectResourceFiltersWrapper checkProjectDirectory(String directoryName, String projectName) {
        return ResourceFilterUtils.checkProjectDirectory(directoryName, projectName, Collections.emptySet());
    }

    protected static NewProjectResourceFiltersWrapper checkProjectDirectory(String directoryName, String projectName, Set<String> excludedPaths) {
        File directory = new File(directoryName);
        long startTimeMillis = System.currentTimeMillis();
        HashSet<String> paths = new HashSet<String>();
        ResourceFiltersManager.FiltersSelectionType[] filtersType = new ResourceFiltersManager.FiltersSelectionType[]{ResourceFiltersManager.FiltersSelectionType.NONE};
        int nrOfFiles = ResourceFilterUtils.countChildrenRecursively(directory, 50000, 10000L, false);
        IProject project = projectName == null ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        AtomicBoolean cancelPressed = new AtomicBoolean(false);
        if (System.currentTimeMillis() - startTimeMillis >= 10000L) {
            Display.getDefault().syncExec(() -> {
                ResourceFilterMessageDialog messageDialog = new ResourceFilterMessageDialog("The project directory seems to be located on a slow filesystem (It takes more than 10000 ms to list all files). ", directory.getAbsolutePath(), (IProject)(project != null ? project : null), false, true, excludedPaths);
                NewProjectResourceFiltersWrapper resourceFilterWrapper = messageDialog.openCustom();
                if (!messageDialog.isCancelled()) {
                    filtersSelectionTypeArray[0] = resourceFilterWrapper.getFiltersSelection();
                }
                if (resourceFilterWrapper.getExcludedPaths() != null) {
                    paths.addAll(resourceFilterWrapper.getExcludedPaths());
                } else {
                    cancelPressed.set(true);
                }
            });
        } else if (nrOfFiles >= 50000) {
            Display.getDefault().syncExec(() -> {
                ResourceFilterMessageDialog messageDialog = new ResourceFilterMessageDialog("The project directory contains more than 50000 children and this may slow down the platform.", directory.getAbsolutePath(), (IProject)(project != null ? project : null), false, true, excludedPaths);
                NewProjectResourceFiltersWrapper resourceFilterWrapper = messageDialog.openCustom();
                if (!messageDialog.isCancelled()) {
                    filtersSelectionTypeArray[0] = resourceFilterWrapper.getFiltersSelection();
                }
                if (resourceFilterWrapper.getExcludedPaths() != null) {
                    paths.addAll(resourceFilterWrapper.getExcludedPaths());
                } else {
                    cancelPressed.set(true);
                }
            });
        }
        if (cancelPressed.get()) {
            return null;
        }
        return new NewProjectResourceFiltersWrapper(paths, filtersType[0]);
    }

    public static boolean isFiltered(File pathname, Map<IContainer, List<Filter>> filters, boolean hasIncludeFilters) {
        return ResourceFilterUtils.isFiltered(pathname, FileType.UNRESOLVED, filters, hasIncludeFilters, Collections.emptyList());
    }

    public static boolean isFiltered(File file, Map<IContainer, List<Filter>> filters, boolean hasIncludeFilters, List<File> result) {
        return ResourceFilterUtils.isFiltered(file, FileType.UNRESOLVED, filters, hasIncludeFilters, result);
    }

    public static boolean isFiltered(File pathname, FileType fileType, Map<IContainer, List<Filter>> filters, boolean hasIncludeFilters) {
        return ResourceFilterUtils.isFiltered(pathname, fileType, filters, hasIncludeFilters, Collections.emptyList());
    }

    private static boolean isFiltered(File file, FileType fileType, Map<IContainer, List<Filter>> filters, boolean hasIncludeFilters, List<File> result) {
        if (file == null || filters == null) {
            return false;
        }
        String fileParent = file.getParent();
        if (fileParent == null) {
            return false;
        }
        FileInfo fileInfo = new FileInfo(file.getName());
        Path parentPath = new Path(fileParent);
        if (fileType == FileType.UNRESOLVED) {
            fileType = file.isDirectory() ? FileType.DIRECTORY : FileType.FILE;
        }
        boolean isInFilterMap = false;
        for (Map.Entry<IContainer, List<Filter>> entry : filters.entrySet()) {
            IPath ppPath;
            IContainer container = entry.getKey();
            IPath location = container.getLocation();
            if (location == null || !location.isPrefixOf((IPath)parentPath) || (ppPath = parentPath.makeRelativeTo(location)) == null) continue;
            IContainer parent = container;
            String locationPath = location.toOSString();
            if (!fileParent.equals(locationPath)) {
                parent = container.getFolder(ppPath);
            }
            for (Filter filter : entry.getValue()) {
                block9: {
                    try {
                        int type = filter.getType();
                        if (fileType == FileType.FILE && (type & 4) == 0 || fileType == FileType.DIRECTORY && (type & 8) == 0 || (type & 0x10) == 0 && !fileParent.equals(locationPath) || !filter.match(parent, (IFileInfo)fileInfo)) continue;
                        if (filter.isIncludeOnly()) break block9;
                        result.remove(file);
                        return true;
                    }
                    catch (CoreException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        return true;
                    }
                }
                isInFilterMap = true;
            }
        }
        return hasIncludeFilters && !isInFilterMap;
    }

    public static Map<IContainer, List<Filter>> getFiltersFromProject(IProject project) {
        ProjectDescription projectDescription = ResourceFilterUtils.getProjectDescription(project);
        if (projectDescription == null) {
            return Collections.emptyMap();
        }
        HashMap filters = projectDescription.getFilters();
        if (filters == null || filters.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<IContainer, List<Filter>> projectFilters = new HashMap<IContainer, List<Filter>>();
        for (Map.Entry entry : filters.entrySet()) {
            Object path = entry.getKey();
            if (path == null) continue;
            IProject resource = null;
            if ("".equals(path)) {
                resource = project;
            } else if (path instanceof IPath) {
                resource = project.findMember((IPath)path);
            }
            if (!(resource instanceof IContainer)) continue;
            IContainer container = (IContainer)resource;
            ArrayList containerFilters = new ArrayList();
            ((LinkedList)entry.getValue()).forEach(filterDesc -> {
                boolean bl = containerFilters.add(new Filter(project, filterDesc));
            });
            projectFilters.put(container, containerFilters);
        }
        return projectFilters;
    }

    public static void applyFiltersSelection(IProject project, ResourceFiltersManager.FiltersSelectionType filtersSelection, BuildConfigParseMode parseMode) {
        ResourceFiltersManager.INSTANCE.applyFiltersSelection(project, filtersSelection, parseMode);
    }

    protected static DbOutOfSyncDialogStatus applyFilters(IProject project, ResourceFilterControlGroupIO fResourceControl) {
        if (project == null) {
            return DbOutOfSyncDialogStatus.OK;
        }
        DbOutOfSyncDialogStatus resultKind = ResourceFiltersManager.INSTANCE.applyFiltersSelection(project, ResourceFilterUtils.getFiltersSelection(fResourceControl), BuildConfigParseMode.CHECK_DIRTY_PROJECT);
        ResourceFilterUtils.applyDvtFilters(project, fResourceControl.getCheckedPaths(), true);
        return resultKind;
    }

    protected static ResourceFiltersManager.FiltersSelectionType getFiltersSelection(ResourceFilterControlGroupIO fResourceControl) {
        if (fResourceControl.getFirstLevelFilterCheckbox().getSelection() && fResourceControl.getAutoFilterCheckbox().getSelection()) {
            return ResourceFiltersManager.FiltersSelectionType.BOTH;
        }
        if (fResourceControl.getFirstLevelFilterCheckbox().getSelection()) {
            return ResourceFiltersManager.FiltersSelectionType.FIRST_LEVEL;
        }
        if (fResourceControl.getAutoFilterCheckbox().getSelection()) {
            return ResourceFiltersManager.FiltersSelectionType.AUTO;
        }
        return ResourceFiltersManager.FiltersSelectionType.NONE;
    }

    public static Map<IPath, List<FilterDescription>> getActiveFilters(IProject project, ResourceFiltersManager.FiltersSelectionType filtersType) {
        ProjectDescription projectDescription = ResourceFilterUtils.getProjectDescription(project);
        if (projectDescription == null) {
            return Collections.emptyMap();
        }
        HashMap filters = projectDescription.getFilters();
        if (filters == null) {
            return Collections.emptyMap();
        }
        HashMap<IPath, List<FilterDescription>> projectFilters = new HashMap<IPath, List<FilterDescription>>();
        for (Map.Entry entry : filters.entrySet()) {
            IPath targetFolderPath = (IPath)entry.getKey();
            for (FilterDescription filterDescription : (LinkedList)entry.getValue()) {
                ResourceFilterUtils.addTypeDependentFilter(projectFilters, targetFolderPath, filterDescription, filtersType);
            }
        }
        return projectFilters;
    }

    protected static void addTypeDependentFilter(Map<IPath, List<FilterDescription>> filterMap, IPath resourcePath, FilterDescription filterDescription, ResourceFiltersManager.FiltersSelectionType filterType) {
        if (!ResourceFilterUtils.isFilterType(filterDescription, filterType)) {
            return;
        }
        if (!filterMap.containsKey(resourcePath)) {
            filterMap.put(resourcePath, new LinkedList());
        }
        filterMap.get(resourcePath).add(filterDescription);
    }

    private static boolean isFilterType(FilterDescription filterDescription, ResourceFiltersManager.FiltersSelectionType filtersType) {
        switch (filtersType) {
            case BOTH: {
                return AutoFiltersManager.INSTANCE.isAutoFilter(filterDescription) || LazyResourcesModelManager.INSTANCE.isLazyFilter(filterDescription);
            }
            case FIRST_LEVEL: {
                return LazyResourcesModelManager.INSTANCE.isLazyFilter(filterDescription);
            }
            case AUTO: {
                return AutoFiltersManager.INSTANCE.isAutoFilter(filterDescription);
            }
        }
        return false;
    }

    public static JSONObject runAutoFiltersHelperMain(IPath projectLocation, String buildConfigFileName, List<String> natureIds, DVTCliHandlerV1.ResultBuilder result) throws DVTCliException {
        ArrayList<String> args = new ArrayList<String>();
        args.add(ResourceFilterUtils.computeJavaPath());
        args.add("-cp");
        args.add(ResourceFilterUtils.computeClassPath());
        args.add("ro.amiq.dvt.main.autoFilters.helper.AutoFiltersHelperMain");
        args.add("-cmd");
        String buildConfigFile = projectLocation + "/.dvt/" + buildConfigFileName + ".build";
        args.add(buildConfigFile);
        for (String natureId : natureIds) {
            args.add("-lang");
            args.add(natureId);
        }
        args.add("-print_bc_dirs");
        args.add("-working_dir");
        args.add(projectLocation.toOSString());
        DVTProcessRunner dvtProcessRunner = new DVTProcessRunner(args);
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            monitor.setTaskName("Parsing build config for auto-including resources...");
            dvtProcessRunner.run((IProgressMonitor)monitor);
        }
        catch (IOException e1) {
            DVTLogger.INSTANCE.logError((Throwable)e1);
            result.appendError("Auto-include failed while parsing '" + buildConfigFile + "':\n" + e1.getMessage() + "\nOnly the .dvt directory will be auto-included.");
            return ResourceFilterUtils.getDefaultDataFromAutoFiltersHelperMain(projectLocation);
        }
        String standardOutput = dvtProcessRunner.getStandardOutput();
        String jsonData = standardOutput.substring(standardOutput.lastIndexOf("### CLI_JSON_DATA ###") + "### CLI_JSON_DATA ###".length());
        JSONObject data = null;
        try {
            data = new JSONObject(jsonData);
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return data == null ? ResourceFilterUtils.getDefaultDataFromAutoFiltersHelperMain(projectLocation) : data;
    }

    private static JSONObject getDefaultDataFromAutoFiltersHelperMain(IPath projectLocation) {
        JSONObject defaultData = new JSONObject();
        try {
            defaultData.put("IS_BUILD_CONFIG_KIND_AUTO_KEY", false);
            defaultData.put("RESOURCE_FILTERS_KEY", new ArrayList<String>(Arrays.asList(projectLocation.toOSString())));
        }
        catch (JSONException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return defaultData;
    }

    private static String computeJavaPath() {
        return String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + ("win32".equals(Platform.getOS()) ? "javaw.exe" : "java");
    }

    private static String computeClassPath() throws DVTCliException {
        java.nio.file.Path location = JarUtils.getCodeSourcePath(CreateProject.class);
        if (!location.getFileName().toString().endsWith(".jar")) {
            File batchFolder = location.resolveSibling(Paths.get("ro.amiq.dvt.batch", new String[0])).toFile();
            if (!batchFolder.canRead()) {
                throw new DVTCliException("Unable to read ro.amiq.dvt.batch!");
            }
            File batchLibsFolder = new File(batchFolder, "libs");
            if (!batchFolder.canRead()) {
                throw new DVTCliException("Unable to read ro.amiq.dvt.batch/libs!");
            }
            File batchBinFolder = new File(batchFolder, "bin");
            if (!batchBinFolder.canRead()) {
                throw new DVTCliException("Unable to read ro.amiq.dvt.batch/bin!");
            }
            String classPath = Arrays.stream(batchLibsFolder.listFiles()).filter(File::isDirectory).flatMap(folder -> Arrays.stream(folder.listFiles())).filter(file -> file.getName().endsWith(".jar") && file.isFile()).map(File::getAbsolutePath).collect(Collectors.joining(":"));
            return String.valueOf(classPath) + ":" + batchBinFolder;
        }
        String dvtHome = System.getenv("DVT_HOME");
        if (dvtHome == null) {
            throw new DVTCliException("$DVT_HOME environment variable not set.");
        }
        File batchDirFile = Path.fromOSString((String)dvtHome).append("batch").toFile();
        if (!batchDirFile.exists()) {
            throw new DVTCliException("Unable to find DVT batch jar file in $DVT_HOME/batch.");
        }
        String[] matched = batchDirFile.list((dir, name) -> DVTStringUtil.matches(BATCH_JAR_PATTERN, name));
        if (matched.length == 0) {
            throw new DVTCliException("Unable to find DVT batch jar file in $DVT_HOME/batch.");
        }
        return new File(batchDirFile, matched[0]).getAbsolutePath();
    }
}

