/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcefilters.lazyfilters.LBRLevel;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModelManager;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesType;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class ResourceFilters {
    public static final int AUTO_FILTER_DEFAULT_THRESHOLD = 500;
    public static final String EXCLUDE = "exclude";
    public static final String INCLUDE = "include";
    private static final Pattern CLI_FILTER_PATTERN = Pattern.compile("^((name|location|projectRelativePath|symlink)(_regex)?=)?(.*)$");
    private static final String PROJECT_RELATIVE_PATH = "projectRelativePath";
    public static final String ROOT = "root=";
    public static final String APPLIES = "applies=";
    private static final String LAZY = "lazy";
    private static final String AUTO = "auto";
    private static final String SYMLINK = "symlink";
    private static final Pattern STAR = Pattern.compile("\\*");
    public static final String AUTO_FILTERS_ROOT = ",root=";
    public static final String AUTO_FILTERS_APPLIES = ",applies=fd";
    private static final String AUTO_FILTERS_NAME = "name=*";
    private static final String AUTO_FILTERS_LAZY = "name=*,lazy";
    public static final String PROJECT_RELATIVE_PATH_REGEX = "projectRelativePath_regex=";

    public static ArrayList<CliFilter> computeFiltersFor(CommandLine commandLine, DVTCliHandlerV1.ResultBuilder cliResult) {
        ArrayList<CliFilter> filters = new ArrayList<CliFilter>();
        if (commandLine.hasOption(EXCLUDE)) {
            Arrays.asList(commandLine.getOptionValues(EXCLUDE)).forEach(s -> {
                boolean bl = filters.add(new CliFilter((String)s, 2));
            });
        }
        if (commandLine.hasOption(INCLUDE)) {
            Arrays.asList(commandLine.getOptionValues(INCLUDE)).forEach(s -> {
                if (!s.startsWith(AUTO) && !s.equals("first_level")) {
                    filters.add(new CliFilter((String)s, 1));
                }
            });
        }
        ResourceFilters.setFiltersProperties(filters, cliResult);
        return filters;
    }

    public static void setFiltersProperties(ArrayList<CliFilter> filters, DVTCliHandlerV1.ResultBuilder cliResult) {
        if (cliResult == null) {
            cliResult = new DVTCliHandlerV1.ResultBuilder();
        }
        ArrayList<String> unmanagedFilters = new ArrayList<String>();
        for (CliFilter filter : filters) {
            String[] pieces;
            String[] stringArray = pieces = filter.string.split(",");
            int n = pieces.length;
            int n2 = 0;
            while (n2 < n) {
                String piece = stringArray[n2];
                if (!piece.isEmpty()) {
                    if (piece.startsWith(ROOT)) {
                        filter.rootString = piece.substring(ROOT.length());
                    } else if (piece.startsWith(APPLIES)) {
                        filter.appliesString = piece.substring(APPLIES.length());
                    } else if (piece.startsWith(LAZY)) {
                        filter.isLazyResource = true;
                    } else if (piece.startsWith(AUTO)) {
                        filter.isAutoResource = true;
                    } else if (filter.matchRuleString != null) {
                        cliResult.appendWarning("Ignoring " + filter.getInclExclString() + " matching rule '" + piece + "', already specified '" + filter.matchRuleString + "'.");
                    } else {
                        filter.matchRuleString = piece;
                    }
                }
                ++n2;
            }
            if (filter.matchRuleString == null) {
                cliResult.appendWarning("Unable to parse " + filter.getInclExclString() + " filter: '" + filter.string + "', will be ignored.");
                continue;
            }
            Matcher matcher = CLI_FILTER_PATTERN.matcher(filter.matchRuleString);
            if (!matcher.matches()) {
                cliResult.appendWarning("Unable to parse " + filter.getInclExclString() + " match rule: '" + filter.matchRuleString + "', will be ignored.");
                continue;
            }
            String excludeBy = matcher.group(2) == null ? "name" : matcher.group(2);
            Boolean isRegex = matcher.group(3) != null;
            String pattern = matcher.group(4);
            if (pattern == null) {
                cliResult.appendWarning(String.valueOf(filter.getInclExclString()) + " match rule pattern is empty for: '" + filter.matchRuleString + "', will be ignored.");
                continue;
            }
            if (excludeBy.equals(SYMLINK) && !pattern.equals("true") && !pattern.equals("false")) {
                cliResult.appendWarning("Unable to parse " + filter.getInclExclString() + " match rule: '" + filter.matchRuleString + "', will be ignored.");
                continue;
            }
            if (filter.rootString != null) {
                Arrays.asList(filter.rootString.split(":")).forEach(s -> {
                    boolean bl = cliFilter.roots.add(Path.fromOSString((String)s));
                });
            } else {
                filter.roots.add(Path.fromOSString((String)""));
            }
            if (filter.isLazyResource) {
                filter.flags |= 0x20;
            }
            if (filter.isAutoResource) {
                filter.flags |= 0x40;
            }
            if (filter.appliesString != null) {
                boolean isRecursive;
                boolean isFiles = filter.appliesString.indexOf(102) != -1;
                boolean isFolders = filter.appliesString.indexOf(100) != -1;
                boolean bl = isRecursive = filter.appliesString.indexOf(114) != -1;
                if (!isFiles && !isFolders) {
                    cliResult.appendWarning("Skipping " + filter.getInclExclString() + " filter since it applies to neither f(iles) or d(irectories): applies=" + filter.appliesString);
                    continue;
                }
                if (isFiles) {
                    filter.flags |= 4;
                }
                if (isFolders) {
                    filter.flags |= 8;
                }
                if (isRecursive) {
                    filter.flags |= 0x10;
                }
            } else {
                filter.flags = filter.flags | 4 | 8 | 0x10;
            }
            if (filter.rootString == null && filter.appliesString == null && excludeBy.equals(PROJECT_RELATIVE_PATH) && !pattern.contains("*") && !pattern.contains("?") && !isRegex.booleanValue()) {
                filter.fimDescription = new FileInfoMatcherDescription("ro.amiq.dvt.multiFilter", (Object)("1.0-projectRelativePath-matches-true-false-" + new Path(pattern).toPortableString()));
                continue;
            }
            if (filter.isLazyResource || filter.isAutoResource) {
                filter.fimDescription = new FileInfoMatcherDescription("ro.amiq.dvt.multiFilter", (Object)("1.0-" + excludeBy + "-matches-true-" + isRegex.toString() + "-" + new Path(pattern).toPortableString()));
                continue;
            }
            unmanagedFilters.add(filter.string);
            filter.fimDescription = excludeBy.equals(SYMLINK) ? new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)("1.0-isSymLink-equals-" + isRegex.toString() + "-" + isRegex.toString() + "-" + pattern)) : new FileInfoMatcherDescription("org.eclipse.ui.ide.multiFilter", (Object)("1.0-" + excludeBy + "-matches-" + isRegex.toString() + "-" + isRegex.toString() + "-" + pattern));
        }
        if (!unmanagedFilters.isEmpty()) {
            cliResult.appendWarning("The following filter(s): [" + DVTStringUtil.join(unmanagedFilters, ", ") + "] will not be managed by the DVT Resource Filters UI.\n" + "DVT's Resource Filters UI only works for <projectRelativePath> filters that do not contain wildcards or regular expressions.\n" + "However, filtering functionality is not affected, and filters can be managed from the project's properties page.");
        }
    }

    public static void applyFilters(IProject project, List<CliFilter> filters, IProgressMonitor monitor) throws CoreException {
        if (!(project instanceof Project)) {
            return;
        }
        Workspace workspace = (Workspace)project.getWorkspace();
        IWorkspaceRoot rule = workspace.getRoot();
        workspace.prepareOperation((ISchedulingRule)rule, monitor);
        workspace.beginOperation(true);
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return;
        }
        for (CliFilter filter : filters) {
            if (filter.fimDescription == null) continue;
            for (IPath rootPath : filter.roots) {
                try {
                    IProject rootResource = rootPath.isEmpty() ? project : project.getFolder(rootPath);
                    ((Resource)rootResource).checkValidPath(rootResource.getFullPath(), 6, true);
                    FilterDescription newFilter = new FilterDescription((IResource)rootResource, filter.flags, filter.fimDescription);
                    newFilter.setId(System.currentTimeMillis());
                    projectDescription.addFilter(rootResource.getProjectRelativePath(), newFilter);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        ((Project)project).writeDescription(0);
        ResourceFilters.workSpaceEndOperationWithReflection(workspace, (ISchedulingRule)rule, monitor);
    }

    public static Map<IPath, List<FilterDescription>> applyFilters(IProject project, List<CliFilter> filters, IProgressMonitor monitor, ResourceFiltersManager.FiltersSelectionType filtersType) throws CoreException {
        if (!(project instanceof Project)) {
            return Collections.emptyMap();
        }
        Workspace workspace = (Workspace)project.getWorkspace();
        IWorkspaceRoot rule = workspace.getRoot();
        workspace.prepareOperation((ISchedulingRule)rule, monitor);
        workspace.beginOperation(true);
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return Collections.emptyMap();
        }
        HashMap<IPath, List<FilterDescription>> returnedFilters = new HashMap<IPath, List<FilterDescription>>();
        for (CliFilter filter : filters) {
            if (filter.fimDescription == null) continue;
            for (IPath rootPath : filter.roots) {
                try {
                    IProject rootResource = rootPath.isEmpty() ? project : project.getFolder(rootPath);
                    ((Resource)rootResource).checkValidPath(rootResource.getFullPath(), 6, true);
                    FilterDescription newFilter = new FilterDescription((IResource)rootResource, filter.flags, filter.fimDescription);
                    newFilter.setId(System.currentTimeMillis());
                    LinkedList existingFilters = projectDescription.getFilter(rootResource.getProjectRelativePath());
                    if (existingFilters != null && existingFilters.stream().anyMatch(existingFilter -> ResourceFiltersManager.INSTANCE.sameFilter((FilterDescription)existingFilter, newFilter))) continue;
                    projectDescription.addFilter(rootResource.getProjectRelativePath(), newFilter);
                    ResourceFilterUtils.addTypeDependentFilter(returnedFilters, rootPath, newFilter, filtersType);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        ((Project)project).writeDescription(0);
        ResourceFilters.workSpaceEndOperationWithReflection(workspace, (ISchedulingRule)rule, monitor);
        return returnedFilters;
    }

    private static void workSpaceEndOperationWithReflection(Workspace workspace, ISchedulingRule rule, IProgressMonitor monitor) {
        try {
            if (EclipseUtils.isAtLeastEclipse47()) {
                Method endOperationM = workspace.getClass().getMethod("endOperation", ISchedulingRule.class, Boolean.TYPE);
                endOperationM.invoke((Object)workspace, rule, true);
            } else {
                Method endOperationM = workspace.getClass().getMethod("endOperation", ISchedulingRule.class, Boolean.TYPE, IProgressMonitor.class);
                endOperationM.invoke((Object)workspace, rule, true, monitor);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static String getReference() {
        return "    -exclude    [optional] exclude from the project resources (files, \n                           directories) and their children recursively \n                           by name, location (absolute path) or projectRelativePath.\n                           For <name|location|projectRelativePath>=<pattern>, \n                           the pattern is case insensitive and allows simple wildcards (* and ?)\n                           For <name_regex|location_regex|projectRelativePath_regex>=<pattern>, \n                           the pattern is case sensitive and allows regular expressions\n                           If only <pattern> is specified, matching is done \n                           against the resouce <name> using simple wildcards (* and ?).\n";
    }

    public static void addProjectDirectoryFilters(String directoryName, String projectName, ArrayList<CliFilter> cliFilters) {
        HashSet<Pattern> includedPaths = new HashSet<Pattern>();
        HashSet<String> excludedPaths = new HashSet<String>();
        for (CliFilter cliFilter : cliFilters) {
            String filter2 = DVTStringUtil.replaceAll(STAR, cliFilter.string, ".*");
            int startRelativePath = filter2.indexOf("=");
            if ((cliFilter.flags & 1) != 0) {
                if (!filter2.startsWith(PROJECT_RELATIVE_PATH) || cliFilter.isLazyResource || cliFilter.isAutoResource) continue;
                includedPaths.add(Pattern.compile(String.valueOf(directoryName) + File.separator + filter2.substring(startRelativePath + 1)));
                continue;
            }
            if (!filter2.startsWith(PROJECT_RELATIVE_PATH)) continue;
            excludedPaths.add(String.valueOf(directoryName) + File.separator + filter2.substring(startRelativePath + 1));
        }
        ResourceFilters.addExcludedFiles(directoryName, includedPaths, excludedPaths);
        Set<String> paths = ResourceFilterUtils.checkProjectDirectory(directoryName, projectName, excludedPaths).getExcludedPaths();
        if (paths == null) {
            return;
        }
        cliFilters.removeIf(filter -> filter.string.startsWith(PROJECT_RELATIVE_PATH));
        for (String path : paths) {
            cliFilters.add(new CliFilter("projectRelativePath=" + path, 2));
        }
        ResourceFilters.setFiltersProperties(cliFilters, null);
    }

    private static void addExcludedFiles(String directoryPath, Set<Pattern> includedPaths, Set<String> excludedPaths) {
        File[] files;
        if (includedPaths.isEmpty()) {
            return;
        }
        File directory = new File(directoryPath);
        File[] fileArray = files = directory.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!includedPaths.stream().anyMatch(path -> DVTStringUtil.matches(path, file.getAbsolutePath()))) {
                excludedPaths.add(file.getAbsolutePath());
            } else if (file.isDirectory()) {
                ResourceFilters.addExcludedFiles(file.getAbsolutePath(), includedPaths, excludedPaths);
            }
            ++n2;
        }
    }

    public static void computeFiltersFromCLI(IProject project, ArrayList<CliFilter> cliFilters, Map<IContainer, List<Filter>> filters, Set<Pattern> includedProjectRelativePath, Set<Pattern> excludedProjectRelativePath) {
        IPath location = project.getLocation();
        if (location == null) {
            return;
        }
        String projectPath = location.toOSString();
        for (CliFilter cliFilter : cliFilters) {
            if (cliFilter.fimDescription == null) continue;
            if (cliFilter.string.startsWith(PROJECT_RELATIVE_PATH) && cliFilter.appliesString == null && cliFilter.rootString == null) {
                String filter = DVTStringUtil.replaceAll(STAR, cliFilter.string.substring(cliFilter.string.indexOf("=") + 1), ".*");
                if ((cliFilter.flags & 1) == 0) {
                    excludedProjectRelativePath.add(Pattern.compile(String.valueOf(projectPath) + File.separator + filter));
                    continue;
                }
                includedProjectRelativePath.add(Pattern.compile(String.valueOf(projectPath) + File.separator + filter));
                continue;
            }
            for (IPath rootPath : cliFilter.roots) {
                IProject rootResource;
                Object object = rootResource = rootPath.isEmpty() ? project : project.getFolder(rootPath);
                if (!filters.containsKey(rootResource)) {
                    filters.put((IContainer)rootResource, new LinkedList());
                }
                filters.get(rootResource).add(new Filter(project, new FilterDescription((IResource)rootResource, cliFilter.flags, cliFilter.fimDescription)));
            }
        }
    }

    public static List<CliFilter> computeFirstLevelFilters(IProject project) {
        ArrayList<CliFilter> result = new ArrayList<CliFilter>();
        result.add(new CliFilter(LazyResourcesModelManager.FIRST_LEVEL_FILTER, 33));
        LazyResourcesModelManager.INSTANCE.initProject(project);
        LinkedHashSet<String> readFiltersFromFile = new LinkedHashSet<String>();
        readFiltersFromFile.addAll(LazyResourcesModelManager.INSTANCE.getLazyResources(project, BuildConfigManager.getActiveBuildConfigName(project), LazyResourcesType.ALL));
        for (String filter : readFiltersFromFile) {
            result.add(new CliFilter(filter, 1));
        }
        ResourceFilters.setFiltersProperties(result, null);
        return result;
    }

    public static List<CliFilter> getAutoIncludeFilters(int threshold, IPath projectLocation, List<String> resources, boolean autoFiltersFirstLevel) {
        LinkedHashSet<String> cliFiltersNameList = new LinkedHashSet<String>();
        int noOfChildren = ResourceFilterUtils.countChildrenRecursively(projectLocation.toFile(), threshold + 1, 10000L, false);
        if (noOfChildren < threshold) {
            return new ArrayList<CliFilter>();
        }
        if (resources == null || resources.isEmpty()) {
            DVTLogger.INSTANCE.logError("No relevant directories parsed from the build config file.");
            return new ArrayList<CliFilter>();
        }
        if (!autoFiltersFirstLevel) {
            ResourceFilters.addExceptionsToFiltersList(projectLocation, cliFiltersNameList);
            cliFiltersNameList.add("name=*,applies=f,auto");
        }
        return ResourceFilters.computeAutoFiltersForResources(projectLocation, resources, cliFiltersNameList, threshold, autoFiltersFirstLevel);
    }

    public static void applyAutoFiltersForResource(IContainer folder, IPath resourceLocation, boolean serializeFilter) {
        if (folder == null) {
            return;
        }
        IProject project = folder.getProject();
        if (project == null) {
            return;
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null || resourceLocation == null) {
            return;
        }
        ResourceFiltersManager.FiltersSelectionType activeFilterSelection = ResourceFiltersManager.INSTANCE.getActiveFiltersSelection(project);
        try {
            switch (activeFilterSelection) {
                case FIRST_LEVEL: 
                case BOTH: {
                    LazyResourcesModelManager.INSTANCE.addLazyFilter((IResource)folder, LBRLevel.SINGLE, serializeFilter);
                    break;
                }
                case AUTO: {
                    boolean autoFiltersFirstLevel = activeFilterSelection == ResourceFiltersManager.FiltersSelectionType.BOTH;
                    List<CliFilter> autoFilter = ResourceFilters.computeAutoFiltersForResources(projectLocation, Collections.singletonList(resourceLocation.toOSString()), new HashSet<String>(), 500, autoFiltersFirstLevel);
                    ResourceFilters.applyFilters(project, autoFilter, (IProgressMonitor)new NullProgressMonitor(), activeFilterSelection);
                    ResourceFiltersManager.INSTANCE.refreshResource(project, (IResource)folder, false);
                    break;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected static List<CliFilter> computeAutoFiltersForResources(IPath projectLocation, List<String> resources, Set<String> cliFiltersNameList, int threshold, boolean autoFiltersFirstLevel) {
        Set<IPath> relativeFilterPaths = ResourceFilters.sanitizePaths(projectLocation, resources);
        Iterator<IPath> iterator = relativeFilterPaths.iterator();
        while (iterator.hasNext()) {
            IPath filterPath = iterator.next();
            if (filterPath.toOSString().equals(".dvt")) {
                iterator.remove();
                continue;
            }
            File file = projectLocation.append(filterPath).toFile();
            int noOfChildren = ResourceFilterUtils.countChildrenRecursively(file, threshold + 1, 10000L, false);
            if (noOfChildren > threshold) {
                iterator.remove();
                continue;
            }
            if (!relativeFilterPaths.contains(filterPath.removeLastSegments(1))) continue;
            iterator.remove();
        }
        for (IPath filterPath : relativeFilterPaths) {
            StringBuilder pathFromSegments = new StringBuilder();
            int i = 0;
            while (i < filterPath.segmentCount()) {
                cliFiltersNameList.add(ResourceFilters.createIncludeAutoFilter(pathFromSegments.toString(), filterPath.segment(i), autoFiltersFirstLevel, !pathFromSegments.toString().isEmpty(), false));
                pathFromSegments.append(filterPath.segment(i)).append("/");
                ++i;
            }
            cliFiltersNameList.add(ResourceFilters.createIncludeAutoFilter(pathFromSegments.toString(), AUTO_FILTERS_NAME, autoFiltersFirstLevel, true, true));
        }
        ArrayList<CliFilter> cliAutoFilterList = new ArrayList<CliFilter>();
        for (String filter : cliFiltersNameList) {
            cliAutoFilterList.add(new CliFilter(filter, 65));
        }
        ResourceFilters.setFiltersProperties(cliAutoFilterList, null);
        return cliAutoFilterList;
    }

    private static String createIncludeAutoFilter(String root, String name, boolean autoFiltersFirstLevel, boolean shouldAddRoot, boolean recursive) {
        StringBuilder result = new StringBuilder();
        if (autoFiltersFirstLevel) {
            result.append(AUTO_FILTERS_LAZY);
        } else {
            result.append(name);
        }
        if (!recursive) {
            result.append(AUTO_FILTERS_APPLIES);
        }
        if (shouldAddRoot) {
            result.append(AUTO_FILTERS_ROOT).append(root);
        }
        result.append(",").append(AUTO);
        return result.toString();
    }

    private static void addExceptionsToFiltersList(IPath projectLocation, Set<String> cliFiltersNameList) {
        cliFiltersNameList.addAll(LazyResourcesModelManager.INSTANCE.computeExceptions(projectLocation, ",auto"));
        cliFiltersNameList.add("projectRelativePath_regex=.project,applies=f,auto");
        cliFiltersNameList.add("projectRelativePath_regex=.cproject,applies=f,auto");
        cliFiltersNameList.add("projectRelativePath_regex=.pydevproject,applies=f,auto");
        cliFiltersNameList.add("projectRelativePath_regex=.classpath,applies=f,auto");
        cliFiltersNameList.add("projectRelativePath_regex=.buildpath,applies=f,auto");
    }

    private static Set<IPath> sanitizePaths(IPath projectLocation, List<String> resourceFilters) {
        TreeSet<IPath> relativeFilterPaths = new TreeSet<IPath>((path1, path2) -> path1.toOSString().compareTo(path2.toOSString()));
        for (String resourceFilter : resourceFilters) {
            IPath relativePath;
            block5: {
                relativePath = ResourceFilters.pathRelativeToProject(resourceFilter, projectLocation);
                if (relativePath == null) {
                    try {
                        relativePath = ResourceFilters.pathRelativeToProject(new File(resourceFilter).getCanonicalPath(), projectLocation);
                        if (relativePath == null) {
                        }
                        break block5;
                    }
                    catch (IOException e) {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                    }
                    continue;
                }
            }
            relativeFilterPaths.add(relativePath);
        }
        return relativeFilterPaths;
    }

    private static IPath pathRelativeToProject(String path, IPath projectLocation) {
        IPath resourcePath = Path.fromOSString((String)path);
        IPath relativePath = resourcePath.makeRelativeTo(projectLocation).removeTrailingSeparator();
        if (relativePath.equals((Object)Path.EMPTY) || relativePath.toOSString().contains("..")) {
            return null;
        }
        return relativePath;
    }

    public static class CliFilter {
        private String string;
        private int flags;
        public String rootString;
        public String appliesString;
        public String matchRuleString;
        private boolean isLazyResource;
        private boolean isAutoResource;
        public FileInfoMatcherDescription fimDescription;
        public Set<IPath> roots = new HashSet<IPath>();

        public CliFilter(String s, int flag) {
            this.flags = flag;
            this.string = s;
        }

        public int getFlags() {
            return this.flags;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            if ((this.flags & 2) != 0) {
                result.append("EXCLUDE_ALL|");
            }
            if ((this.flags & 1) != 0) {
                result.append("INCLUDE_ONLY|");
            }
            if ((this.flags & 4) != 0) {
                result.append("FILES|");
            }
            if ((this.flags & 8) != 0) {
                result.append("FOLDERS|");
            }
            if ((this.flags & 0x10) != 0) {
                result.append("INHERITABLE|");
            }
            for (IPath p : this.roots) {
                result.append(p).append(":");
            }
            result.append(this.fimDescription.getArguments());
            return result.toString();
        }

        public String getInclExclString() {
            if ((this.flags & 2) != 0) {
                return "-exclude";
            }
            if ((this.flags & 1) != 0) {
                return "-include";
            }
            return "";
        }
    }
}

