/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.resourcefilters.FiltersManagerFactory;
import ro.amiq.dvt.resourcefilters.IFiltersManager;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFilters;
import ro.amiq.dvt.resourcefilters.autofilters.AutoFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.resourcefilters.autofilters.DbOutOfSyncDialogStatus;
import ro.amiq.dvt.resourcefilters.lazyfilters.FirstLevelFiltersManager;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModelManager;
import ro.amiq.dvt.resourcemonitor.DVTResourceMonitor;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum ResourceFiltersManager {
    INSTANCE;


    public DbOutOfSyncDialogStatus applyFiltersSelection(IProject project, FiltersSelectionType filtersSelection, BuildConfigParseMode parseMode) {
        if (project == null) {
            return DbOutOfSyncDialogStatus.OK;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return DbOutOfSyncDialogStatus.OK;
        }
        DbOutOfSyncDialogStatus resultKind = DbOutOfSyncDialogStatus.OK;
        boolean updateAutoLinks = parseMode != BuildConfigParseMode.FORCE_PARSE;
        ArrayList<ResourceFilters.CliFilter> allFilters = new ArrayList<ResourceFilters.CliFilter>();
        ArrayList<ResourceFilters.CliFilter> autoFilters = new ArrayList();
        IFiltersManager autoManager = FiltersManagerFactory.INSTANCE.createManager(FiltersSelectionType.AUTO);
        IFiltersManager firstLevelManager = FiltersManagerFactory.INSTANCE.createManager(FiltersSelectionType.FIRST_LEVEL);
        FiltersSelectionType oldFiltersSelection = this.getActiveFiltersSelection(project);
        Map<IPath, List<FilterDescription>> oldAutoFilters = ResourceFilterUtils.getActiveFilters(project, FiltersSelectionType.BOTH);
        try {
            switch (filtersSelection) {
                case BOTH: {
                    Optional<List<ResourceFilters.CliFilter>> autoFiltersOptional = autoManager.computeAutoFilters(project, true, parseMode);
                    if (!autoFiltersOptional.isPresent()) {
                        resultKind = DbOutOfSyncDialogStatus.CANCELLED;
                    } else {
                        autoFilters = autoFiltersOptional.get();
                    }
                    allFilters.addAll(autoFilters);
                    allFilters.addAll(firstLevelManager.computeFirstLevelFilters(project, autoFilters));
                    this.updateFilterTypes(projectDescription, filtersSelection);
                    if (!updateAutoLinks) break;
                    if (oldFiltersSelection == FiltersSelectionType.FIRST_LEVEL) {
                        Map<IContainer, List<Filter>> activeFilters = ResourceFilterUtils.getFiltersFromProject(project);
                        ResourceFiltersManager.addFiltersToMap(project, autoFilters, activeFilters);
                        firstLevelManager.dirtyFilteredResourcesAutoLink(project, activeFilters, true);
                        break;
                    }
                    firstLevelManager.updateAutoLinkAfterComputeFilters(project, allFilters);
                    break;
                }
                case FIRST_LEVEL: {
                    HashMap<IContainer, List<Filter>> filtersMap;
                    autoManager.deactivateFilters(project, FiltersSelectionType.AUTO, true);
                    firstLevelManager.deactivateFilters(project, oldFiltersSelection, true);
                    allFilters.addAll(firstLevelManager.computeFirstLevelFilters(project, Collections.emptyList()));
                    if (!updateAutoLinks) break;
                    if (oldFiltersSelection == FiltersSelectionType.BOTH) {
                        filtersMap = new HashMap<IContainer, List<Filter>>(ResourceFilterUtils.getFiltersFromProject(project));
                        ResourceFiltersManager.addFiltersToMap(project, allFilters, filtersMap);
                        firstLevelManager.restoreAutoLink(project, filtersMap);
                        break;
                    }
                    firstLevelManager.updateAutoLinkAfterComputeFilters(project, allFilters);
                    break;
                }
                case AUTO: {
                    boolean hasIncludeFilters;
                    HashMap<IContainer, List<Filter>> filtersMap;
                    autoManager.deactivateFilters(project, FiltersSelectionType.BOTH, false);
                    firstLevelManager.deactivateFilters(project, FiltersSelectionType.BOTH, false);
                    firstLevelManager.updateAutoLinkAfterDeactivateFilters(project, true);
                    Optional<List<ResourceFilters.CliFilter>> autoFiltersOptional = autoManager.computeAutoFilters(project, false, parseMode);
                    if (!autoFiltersOptional.isPresent()) {
                        resultKind = DbOutOfSyncDialogStatus.CANCELLED;
                    } else {
                        allFilters.addAll((Collection<ResourceFilters.CliFilter>)autoFiltersOptional.get());
                    }
                    if (!updateAutoLinks || !(hasIncludeFilters = autoManager.hasIncludeFilters(filtersMap = new HashMap<IContainer, List<Filter>>(ResourceFilterUtils.getFiltersFromProject(project))))) break;
                    autoManager.updateAutoLinkAfterComputeFilters(project, allFilters);
                    break;
                }
                case NONE: {
                    autoManager.deactivateFilters(project, oldFiltersSelection, true);
                    firstLevelManager.deactivateFilters(project, oldFiltersSelection, true);
                    if (!updateAutoLinks) break;
                    firstLevelManager.updateAutoLinkAfterDeactivateFilters(project, true);
                }
            }
            if (allFilters.isEmpty() && oldFiltersSelection == filtersSelection) {
                return resultKind;
            }
            Map<IPath, List<FilterDescription>> newAutoFilters = ResourceFilters.applyFilters(project, allFilters, (IProgressMonitor)new NullProgressMonitor(), FiltersSelectionType.BOTH);
            if (project.isAccessible()) {
                INSTANCE.refreshChangedResources(project, oldAutoFilters, newAutoFilters);
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return resultKind;
    }

    public FiltersSelectionType getActiveFiltersSelection(IProject project) {
        boolean hasFirstLevelFilters = FirstLevelFiltersManager.INSTANCE.hasFirstLevelFilters(project);
        boolean hasAutoFilters = AutoFiltersManager.INSTANCE.hasAutoFilters(project);
        if (hasFirstLevelFilters && hasAutoFilters) {
            return FiltersSelectionType.BOTH;
        }
        if (hasFirstLevelFilters) {
            return FiltersSelectionType.FIRST_LEVEL;
        }
        if (hasAutoFilters) {
            return FiltersSelectionType.AUTO;
        }
        return FiltersSelectionType.NONE;
    }

    private void updateFilterTypes(ProjectDescription projectDescription, FiltersSelectionType newFiltersType) {
        if (projectDescription == null) {
            return;
        }
        HashMap filters = projectDescription.getFilters();
        if (filters == null) {
            return;
        }
        filters.entrySet().forEach(filter -> {
            LinkedList filterDescriptions = (LinkedList)filter.getValue();
            if (filterDescriptions == null) {
                return;
            }
            filterDescriptions.forEach(filterDescription -> {
                int updatedFilterType = filterDescription.getType();
                switch (newFiltersType) {
                    case BOTH: {
                        if (LazyResourcesModelManager.INSTANCE.isLazyFilter((FilterDescription)filterDescription) || !AutoFiltersManager.INSTANCE.isAutoFilter((FilterDescription)filterDescription)) break;
                        updatedFilterType |= 0x20;
                        filterDescription.setType(updatedFilterType |= 0x40);
                        break;
                    }
                }
            });
        });
    }

    protected static void addFiltersToMap(IProject project, List<ResourceFilters.CliFilter> filters, Map<IContainer, List<Filter>> filtersMap) {
        if (filters == null || filters.isEmpty()) {
            return;
        }
        for (ResourceFilters.CliFilter filter : filters) {
            if (filter.fimDescription == null) continue;
            try {
                for (IPath rootPath : filter.roots) {
                    IProject rootResource = rootPath == null || rootPath.isEmpty() ? project : project.getFolder(rootPath);
                    ((Resource)rootResource).checkValidPath(rootResource.getFullPath(), 6, true);
                    FilterDescription newFilter = new FilterDescription((IResource)rootResource, filter.getFlags(), filter.fimDescription);
                    newFilter.setId(System.currentTimeMillis());
                    if (!(rootResource instanceof IContainer)) continue;
                    IContainer container = (IContainer)rootResource;
                    if (!filtersMap.containsKey(container)) {
                        filtersMap.put(container, new ArrayList());
                    }
                    filtersMap.get(container).add(new Filter(project, newFilter));
                }
            }
            catch (CoreException e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    public void refreshResource(final IProject project, final IResource resource, final boolean refreshRecursively) {
        Job job = new Job("Refresh resource"){

            protected IStatus run(IProgressMonitor monitor) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                try {
                    workspace.run(pm -> {
                        ((Project)project).writeDescription(0);
                        resource.refreshLocal(refreshRecursively ? 2 : 1, monitor);
                    }, (ISchedulingRule)project, 1, monitor);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
                DVTResourceMonitor.resourceFiltersUpdated(true);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public <T> void refreshChangedResources(IProject project, T oldFilters, T newFilters) {
        Set<IResource> resourcesToBeRefreshed = this.computeResourcesToRefresh(project, oldFilters, newFilters);
        resourcesToBeRefreshed.forEach(resource -> this.refreshResource(project, (IResource)resource, true));
    }

    private <T> Set<IPath> computeFilterDifferences(T filterCollection1, T filterCollection2) {
        Set filterSet2;
        Set filterSet1;
        TreeSet<IPath> differences = new TreeSet<IPath>((path1, path2) -> path1.toOSString().compareTo(path2.toOSString()));
        if (filterCollection1 instanceof Map && filterCollection2 instanceof Map) {
            Map filterMap1 = (Map)filterCollection1;
            Map filterMap2 = (Map)filterCollection2;
            for (Map.Entry entry : filterMap1.entrySet()) {
                List newFilters;
                IPath path = (IPath)entry.getKey();
                if (differences.contains(path)) continue;
                if (!filterMap2.containsKey(path)) {
                    differences.add(path);
                    continue;
                }
                List oldFilters = (List)entry.getValue();
                if (this.sameFilterCollection(oldFilters, newFilters = (List)filterMap2.get(path))) continue;
                differences.add(path);
            }
            for (IPath path : filterMap2.keySet()) {
                if (differences.contains(path) || filterMap1.containsKey(path)) continue;
                differences.add(path);
            }
        } else if (filterCollection1 instanceof Set && filterCollection2 instanceof Set && !this.sameFilterCollection(filterSet1 = (Set)filterCollection1, filterSet2 = (Set)filterCollection2)) {
            differences.add((IPath)Path.EMPTY);
        }
        return differences;
    }

    private boolean sameFilterCollection(Collection<FilterDescription> filterList1, Collection<FilterDescription> filterList2) {
        if (filterList1 == null || filterList2 == null || filterList1.size() != filterList2.size()) {
            return false;
        }
        Iterator<FilterDescription> iterator1 = filterList1.iterator();
        Iterator<FilterDescription> iterator2 = filterList2.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            FilterDescription filter2;
            FilterDescription filter1 = iterator1.next();
            if (this.sameFilter(filter1, filter2 = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    protected boolean sameFilter(FilterDescription filter1, FilterDescription filter2) {
        return Objects.equals(filter1.getResource(), filter2.getResource()) && Objects.equals(filter1.getFileInfoMatcherDescription(), filter2.getFileInfoMatcherDescription()) && Objects.equals(filter1.getType(), filter2.getType());
    }

    private Set<IResource> computeResourcesToRefresh(IProject project, Object oldFilters, Object newFilters) {
        final HashSet<IResource> resourcesToRefresh = new HashSet<IResource>();
        final HashSet<IPath> pathsToRefresh = new HashSet<IPath>();
        IPath lastTopPath = null;
        Set<IPath> updatedPaths = this.computeFilterDifferences(oldFilters, newFilters);
        for (IPath path : updatedPaths) {
            if (lastTopPath != null && lastTopPath.isPrefixOf(path)) continue;
            pathsToRefresh.add(path);
            lastTopPath = path;
        }
        final IPath projectFullPath = project.getFullPath();
        try {
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    IPath resourcePath = proxy.requestFullPath();
                    IPath pathRelativeToProject = resourcePath.makeRelativeTo(projectFullPath);
                    if (pathsToRefresh.contains(pathRelativeToProject)) {
                        resourcesToRefresh.add(proxy.requestResource());
                        return false;
                    }
                    return true;
                }
            }, 2);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return resourcesToRefresh;
    }

    public static enum FiltersSelectionType {
        NONE,
        FIRST_LEVEL,
        AUTO,
        BOTH;

    }
}

