/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters.autofilters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ro.amiq.dvt.buildconfig.ActiveBuildConfig;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.persistence.PersistenceUtils;
import ro.amiq.dvt.resourcefilters.IFiltersManager;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFilters;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.AutoFiltersUtils;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.startup.cli.DVTCliException;
import ro.amiq.dvt.startup.cli.DVTCliHandlerV1;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum AutoFiltersManager implements IFiltersManager
{
    INSTANCE;

    public static final int AUTO_RESOURCES_FILTER_TYPE = 64;

    @Override
    public List<ResourceFilters.CliFilter> computeFirstLevelFilters(IProject project, List<ResourceFilters.CliFilter> autoFilters) {
        return Collections.emptyList();
    }

    @Override
    public Optional<List<ResourceFilters.CliFilter>> computeAutoFilters(IProject project, boolean autoFiltersFirstLevel, BuildConfigParseMode parseMode) {
        if (this.hasAutoFilters(project)) {
            return Optional.of(Collections.emptyList());
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return Optional.of(Collections.emptyList());
        }
        boolean forceBuildConfigParse = parseMode.isForceParse();
        if (parseMode.isCheckDirty() && (IFiltersManager.isDbOutOfSync(project) || BuildConfigManager.getInvocations(project) == null)) {
            boolean shouldRebuild = PersistenceUtils.openIncludeAutoDbOutOfSyncDialog();
            if (!shouldRebuild) {
                return Optional.empty();
            }
            forceBuildConfigParse = true;
        }
        List<String> buildConfigDirs = this.computeBuildConfigDirs(project, forceBuildConfigParse);
        return Optional.of(ResourceFilters.getAutoIncludeFilters(500, projectLocation, buildConfigDirs, autoFiltersFirstLevel));
    }

    public List<String> computeBuildConfigDirs(IProject project, boolean parseBuildConfig) {
        if (!parseBuildConfig) {
            return AutoFiltersUtils.INSTANCE.getBuildConfigDirs(project);
        }
        if (project.isAccessible()) {
            BuildConfigManager.parse(project, false);
            return AutoFiltersUtils.INSTANCE.getBuildConfigDirs(project);
        }
        ActiveBuildConfig buildConfig = BuildConfigManager.getBuildConfig(project);
        ArrayList<String> resourceFilters = new ArrayList<String>();
        try {
            JSONObject cliOutput = ResourceFilterUtils.runAutoFiltersHelperMain(project.getLocation(), buildConfig.getName(), Collections.emptyList(), new DVTCliHandlerV1.ResultBuilder());
            JSONArray jsonArr = (JSONArray)cliOutput.get("RESOURCE_FILTERS_KEY");
            int i = 0;
            while (i < jsonArr.length()) {
                resourceFilters.add((String)jsonArr.get(i));
                ++i;
            }
        }
        catch (JSONException | DVTCliException e) {
            DVTLogger.INSTANCE.logError(e);
        }
        return resourceFilters;
    }

    @Override
    public void deactivateFilters(IProject project, ResourceFiltersManager.FiltersSelectionType filterType, boolean updateAutoLinked) {
        if (!this.hasAutoFilters(project)) {
            return;
        }
        this.removeProjectDescriptionFilters(project, filterType);
    }

    protected boolean hasAutoFilters(List<FilterDescription> filters) {
        return filters != null && filters.stream().anyMatch(filter -> this.isAutoFilter((FilterDescription)filter));
    }

    public boolean isAutoFilter(FilterDescription filter) {
        return (filter.getType() & 0x40) != 0 && "ro.amiq.dvt.multiFilter".equals(filter.getFileInfoMatcherDescription().getId());
    }

    public boolean isAutoFilter(Filter filter) {
        return (filter.getType() & 0x40) != 0 && "ro.amiq.dvt.multiFilter".equals(filter.getId());
    }

    public boolean hasAutoFilters(IProject project) {
        ProjectDescription projectDescription = ResourceFilterUtils.getProjectDescription(project);
        if (projectDescription == null) {
            return false;
        }
        HashMap projectFilters = projectDescription.getFilters();
        if (projectFilters == null) {
            return false;
        }
        return projectFilters.values().stream().anyMatch(filterDescription -> this.hasAutoFilters((List<FilterDescription>)filterDescription));
    }
}

