/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters.autofilters;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;

public enum AutoFiltersUtils {
    INSTANCE;


    public List<String> getBuildConfigDirs(IProject project) {
        List<Invocation> invocations = BuildConfigManager.getInvocations(project);
        if (invocations == null) {
            return new ArrayList<String>();
        }
        TreeSet<IPath> result = new TreeSet<IPath>((path1, path2) -> {
            String p1 = path1.removeTrailingSeparator().toOSString();
            String p2 = path2.removeTrailingSeparator().toOSString();
            return p1.compareTo(p2);
        });
        List<BuildConfigProperty> hyperlinkedProps = BuildConfigManager.getHyperlinkedProperties(project);
        for (BuildConfigProperty hyperlinkedProp : hyperlinkedProps) {
            result.add(Path.fromOSString((String)hyperlinkedProp.getValue()).removeLastSegments(1));
        }
        for (Invocation invocation : invocations) {
            result.add(Path.fromOSString((String)invocation.getState().fCompilationRoot));
            List<String> incDirsList = BuildConfigManager.getIncdirs(project, invocation);
            for (String incDir : incDirsList) {
                result.add(Path.fromOSString((String)incDir));
            }
            List<BuildConfigProperty> libs = BuildConfigManager.getLibs(invocation);
            for (BuildConfigProperty lib : libs) {
                if (lib.getKind() == 4) {
                    result.add(Path.fromOSString((String)lib.getValue()));
                    continue;
                }
                if (lib.getKind() != 5) continue;
                result.add(Path.fromOSString((String)lib.getValue()).removeLastSegments(1));
            }
            List<String> specmanPaths = BuildConfigManager.getSpecmanPath(project, invocation, IBuildConfigParserConstants.SpecmanPathSource.SPECMAN_PATH, IBuildConfigParserConstants.SpecmanPathSource.DVT_SPECMAN_PATH, IBuildConfigParserConstants.SpecmanPathSource.COMPILATION_ROOT, IBuildConfigParserConstants.SpecmanPathSource.PERSPEC_PATH, IBuildConfigParserConstants.SpecmanPathSource.SVR_PATH);
            for (String specmanPath : specmanPaths) {
                result.add(Path.fromOSString((String)specmanPath));
            }
        }
        ArrayList<String> elements = new ArrayList<String>();
        result.forEach(path -> {
            boolean bl = elements.add(path.toOSString());
        });
        return elements;
    }
}

