/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters.autofilters;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.resourcefilters.FiltersManagerFactory;
import ro.amiq.dvt.resourcefilters.IFiltersManager;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFilters;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.AutoFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.resourcefilters.lazyfilters.FirstLevelFiltersManager;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ReapplyIncludeAutoFiltersJob
extends Job {
    private final IProject project;
    private BuildConfigParseMode parseMode;

    public ReapplyIncludeAutoFiltersJob(IProject project, BuildConfigParseMode parseMode) {
        super("Reapply Include Auto Filter");
        this.project = project;
        this.parseMode = parseMode;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!AutoFiltersManager.INSTANCE.hasAutoFilters(this.project)) {
            return Status.OK_STATUS;
        }
        Map<IPath, List<FilterDescription>> oldAutoFilters = ResourceFilterUtils.getActiveFilters(this.project, ResourceFiltersManager.FiltersSelectionType.AUTO);
        IFiltersManager autoManager = FiltersManagerFactory.INSTANCE.createManager(ResourceFiltersManager.FiltersSelectionType.AUTO);
        autoManager.deactivateFilters(this.project, ResourceFiltersManager.FiltersSelectionType.AUTO, true);
        boolean firstLevel = FirstLevelFiltersManager.INSTANCE.hasFirstLevelFilters(this.project);
        Optional<List<ResourceFilters.CliFilter>> autoFiltersOptional = autoManager.computeAutoFilters(this.project, firstLevel, this.parseMode);
        List<ResourceFilters.CliFilter> filters = autoFiltersOptional.isPresent() ? autoFiltersOptional.get() : Collections.emptyList();
        try {
            Map<IPath, List<FilterDescription>> newAutoFilters = ResourceFilters.applyFilters(this.project, filters, monitor, ResourceFiltersManager.FiltersSelectionType.AUTO);
            ResourceFiltersManager.INSTANCE.refreshChangedResources(this.project, oldAutoFilters, newAutoFilters);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

