/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters.lazyfilters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.resourcefilters.IFiltersManager;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.resourcefilters.ResourceFilters;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModelManager;

public enum FirstLevelFiltersManager implements IFiltersManager
{
    INSTANCE;


    @Override
    public List<ResourceFilters.CliFilter> computeFirstLevelFilters(IProject project, List<ResourceFilters.CliFilter> autoFilters) {
        if (INSTANCE.hasFirstLevelFilters(project)) {
            return Collections.emptyList();
        }
        return ResourceFilters.computeFirstLevelFilters(project);
    }

    @Override
    public Optional<List<ResourceFilters.CliFilter>> computeAutoFilters(IProject project, boolean autoFiltersFirstLevel, BuildConfigParseMode parseMode) {
        return Optional.of(Collections.emptyList());
    }

    @Override
    public void deactivateFilters(IProject project, ResourceFiltersManager.FiltersSelectionType filterType, boolean updateAutoLinked) {
        if (!INSTANCE.hasFirstLevelFilters(project)) {
            return;
        }
        this.removeProjectDescriptionFilters(project, ResourceFiltersManager.FiltersSelectionType.FIRST_LEVEL);
    }

    public boolean hasFirstLevelFilters(IProject project) {
        if (project == null) {
            return false;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            projectDescription = ResourceFilterUtils.getProjectDescription(project);
        }
        if (projectDescription == null) {
            return false;
        }
        HashMap projectFilters = projectDescription.getFilters();
        if (projectFilters == null) {
            return false;
        }
        return projectFilters.values().stream().anyMatch(filterDescription -> LazyResourcesModelManager.INSTANCE.hasLazyFilters((List<FilterDescription>)filterDescription));
    }
}

