/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters.lazyfilters;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import ro.amiq.dvt.buildconfig.IBuildConfigChangeListener;
import ro.amiq.dvt.resourcefilters.lazyfilters.LBRLevel;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModelManager;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesType;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;

public enum LazyResourcesListener implements IBuildConfigChangeListener
{
    INSTANCE;


    @Override
    public void buildConfigListenerChanged(IProject project, String oldConfigName, String newConfigName) {
        String root;
        IResource resource;
        if (!Utils.isAccessibleDVTProject(project)) {
            return;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return;
        }
        if (!LazyResourcesModelManager.INSTANCE.hasLazyFilters(projectDescription.getFilter(project.getProjectRelativePath()))) {
            return;
        }
        LazyResourcesModelManager.INSTANCE.initProject(project);
        List<String> oldBCLazyResources = LazyResourcesModelManager.INSTANCE.getLazyResources(project, oldConfigName, LazyResourcesType.ACTIVE_BC);
        List<String> newBCLazyResources = LazyResourcesModelManager.INSTANCE.getLazyResources(project, newConfigName, LazyResourcesType.ACTIVE_BC);
        Collections.sort(newBCLazyResources, Comparator.comparing(String::length));
        for (String oldBCLazyResource : oldBCLazyResources) {
            if (newBCLazyResources.contains(oldBCLazyResource) || (resource = project.findMember(root = oldBCLazyResource.substring(oldBCLazyResource.indexOf("root=") + "root=".length()))) == null) continue;
            LazyResourcesModelManager.INSTANCE.removeFilter(project, resource, false);
        }
        for (String newBCLazyResource : newBCLazyResources) {
            if (oldBCLazyResources.contains(newBCLazyResource) || (resource = project.findMember(root = newBCLazyResource.substring(newBCLazyResource.indexOf("root=") + "root=".length()))) == null) continue;
            LazyResourcesModelManager.INSTANCE.addFilter(project, resource, false, this.expandType(newBCLazyResource));
        }
        ObjectionManager.getInstance().clear(Objection.LAZY_RESOURCES);
    }

    private LBRLevel expandType(String filter) {
        if (!filter.contains("applies=")) {
            return LBRLevel.ALL;
        }
        String appliesStrategy = filter.substring(filter.indexOf("applies=") + "applies=".length());
        if ((appliesStrategy = DVTStringUtil.split(DVTStringUtil.COMMA, appliesStrategy)[0]).contains("r")) {
            return LBRLevel.ALL;
        }
        return LBRLevel.SINGLE;
    }
}

