/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters.lazyfilters;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModelManager;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesType;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesWrapper;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.utils.DVTStringUtil;

public class LazyResourcesModel {
    private Map<String, List<LazyResourcesWrapper>> perSectionModel = new LinkedHashMap<String, List<LazyResourcesWrapper>>();
    private int currentOffset = LazyResourcesModelManager.START_OFFSET;
    private int fileLength;
    private IFile file;

    public LazyResourcesModel(List<String> buildConfigs) {
        this.perSectionModel.put("All", new LinkedList());
        for (String buildConfig : buildConfigs) {
            this.perSectionModel.put(buildConfig, new LinkedList());
        }
    }

    protected void setOffset(int offset) {
        this.currentOffset = offset;
    }

    protected void setFileLength(int fileLength) {
        this.fileLength = fileLength;
    }

    protected IFile getFile() {
        return this.file;
    }

    protected void setFile(IFile file) {
        this.file = file;
    }

    private void addBuildConfig(String newBuildConfig) {
        this.perSectionModel.put(newBuildConfig, new LinkedList());
    }

    public Set<String> getAvailableBuildConfigs() {
        return new LinkedHashSet<String>(this.perSectionModel.keySet());
    }

    protected void addFilter(String filter, String rootDirectory) {
        this.perSectionModel.get("All").add(new LazyResourcesWrapper(filter, this.currentOffset, rootDirectory));
        this.insert(this.currentOffset, String.valueOf(filter) + DVTStringUtil.LINE_SEPARATOR);
        this.updateFilters(filter, this.currentOffset, 1);
        this.currentOffset += filter.length() + LazyResourcesModelManager.NEW_LINE_LENGTH;
    }

    protected void addFilter(String buildConfig, String filter, int offset) {
        int rootIndex;
        if (!this.perSectionModel.containsKey(buildConfig)) {
            return;
        }
        if ("All".equals(buildConfig) && offset > 0) {
            this.currentOffset = offset + filter.length() + LazyResourcesModelManager.NEW_LINE_LENGTH;
        }
        if ((rootIndex = filter.indexOf("root=")) == -1) {
            return;
        }
        String rootDirectory = filter.substring(rootIndex + "root=".length());
        this.perSectionModel.get(buildConfig).add(new LazyResourcesWrapper(filter, offset, rootDirectory));
    }

    protected void removeFilters(String activeBuildConfig, String rootDirectory, LazyResourcesType lazyResourceType) {
        if (LazyResourcesType.ALL.equals((Object)lazyResourceType)) {
            this.removeFilters("All", rootDirectory);
        }
        this.removeFilters(activeBuildConfig, rootDirectory);
    }

    private void removeFilters(String activeBuildConfig, String rootDirectory) {
        LinkedList<LazyResourcesWrapper> filtersToRemove = new LinkedList<LazyResourcesWrapper>();
        List<LazyResourcesWrapper> wrapperList = this.perSectionModel.get(activeBuildConfig);
        if (wrapperList == null) {
            return;
        }
        for (LazyResourcesWrapper resource : wrapperList) {
            int offset;
            String resourceRootDirectory;
            String resourceFilter = resource.getFilter();
            if (resourceFilter == null || (resourceRootDirectory = resource.getRootDirectory()) == null || !resourceRootDirectory.startsWith(rootDirectory) || (offset = resource.getOffset()) < 0) continue;
            filtersToRemove.add(resource);
            this.updateFilters(resource.getFilter(), offset, -1);
            this.delete(offset, String.valueOf(resource.getFilter()) + DVTStringUtil.LINE_SEPARATOR);
            if (!"All".equals(activeBuildConfig)) continue;
            this.currentOffset -= resource.getFilter().length() + LazyResourcesModelManager.NEW_LINE_LENGTH;
        }
        wrapperList.removeAll(filtersToRemove);
    }

    public List<LazyResourcesWrapper> getFilters(String activeBuildConfig) {
        List<LazyResourcesWrapper> lazyResWrappersList = this.perSectionModel.get(activeBuildConfig);
        if (lazyResWrappersList == null) {
            return Collections.emptyList();
        }
        return lazyResWrappersList;
    }

    private void updateFilters(String filter, int offset, int op) {
        for (List<LazyResourcesWrapper> value : this.perSectionModel.values()) {
            for (LazyResourcesWrapper lazyResourceWrapper : value) {
                if (lazyResourceWrapper.getOffset() <= offset) continue;
                lazyResourceWrapper.updateOffset(op * (filter.length() + LazyResourcesModelManager.NEW_LINE_LENGTH));
            }
        }
    }

    protected void addNewBuildConfig(String newBuildConfigName) {
        StringBuilder sb = new StringBuilder();
        int offset = 0;
        if (!"All".equals(newBuildConfigName)) {
            sb.append(DVTStringUtil.LINE_SEPARATOR);
            offset = this.fileLength;
        }
        sb.append(newBuildConfigName).append(":");
        sb.append(DVTStringUtil.LINE_SEPARATOR);
        this.insert(offset, sb.toString());
        this.addBuildConfig(newBuildConfigName);
    }

    private void insert(int offset, String filter) {
        if (this.file == null) {
            return;
        }
        InsertEdit insertEdit = new InsertEdit(offset, filter);
        DVTTextFileChange fe = new DVTTextFileChange(this.file.getName(), this.file);
        fe.setEdit((TextEdit)new MultiTextEdit());
        fe.addEdit((TextEdit)insertEdit, (IRegion)new Region(offset, filter.length()));
        try {
            fe.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        fe.dispose();
        this.fileLength += filter.length();
    }

    private void delete(int offset, String filter) {
        if (this.file == null) {
            return;
        }
        int length = filter.length();
        if (offset + length > this.fileLength && offset < this.fileLength) {
            length = this.fileLength - offset;
        }
        DeleteEdit replaceEdit = new DeleteEdit(offset, length);
        DVTTextFileChange fe = new DVTTextFileChange(this.file.getName(), this.file);
        fe.setEdit((TextEdit)new MultiTextEdit());
        fe.addEdit((TextEdit)replaceEdit, (IRegion)new Region(offset, length));
        try {
            fe.perform((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        fe.dispose();
        this.fileLength -= length;
    }
}

