/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcefilters.lazyfilters;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.internal.resources.FilterDescription;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.model.floatingwidgets.FLazyResourcesNotificationTracker;
import ro.amiq.dvt.resourcefilters.ResourceFiltersManager;
import ro.amiq.dvt.resourcefilters.lazyfilters.LBRLevel;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesModel;
import ro.amiq.dvt.resourcefilters.lazyfilters.LazyResourcesType;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.settings.DVTSConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public enum LazyResourcesModelManager {
    INSTANCE;

    public static final int LAZY_RESOURCES_FILTER_TYPE = 32;
    public static final String FIRST_LEVEL_FILTER;
    public static final String NEXT_LEVEL_FILTER_PREFIX = "  -include *,applies=fd,lazy,root=";
    public static final String RECURSIVE_LEVEL_FILTER_PREFIX = "  -include *,lazy,root=";
    public static final String LAZY_RESOURCE_FILTER_DESCRIPTION = "1.0-name-matches-true-false-*";
    public static final String LAZY_FILTER_PROPERTY = ",lazy";
    public static final String ALL_BUILD_CONFIGS = "All";
    public static final String BUILD_CONFIG_SUFFIX = ":";
    private static final Pattern BUILD_CONFIG_LINE;
    public static final int NEW_LINE_LENGTH;
    public static final int START_OFFSET;
    public static final String LAZY_RESOURCES_DIRECTORY = "lazy_resources";
    private static final String CONFIG_EXTENSION = "_config.yaml";
    private static final int USER_SETTINGS_REFRESH_DEPTH = 2;
    protected static final String APPLIES_RECURSIVE = "r";
    private static final String LOG_VIEWER_DIRECTORY_FILTER = ".dvt.*";
    private static final Pattern LOG_VIEWER_DIRECTORY_PATTERN;
    private Map<IProject, LazyResourcesModel> lazyResourceFiltersCache = new LinkedHashMap<IProject, LazyResourcesModel>();

    static {
        FIRST_LEVEL_FILTER = "projectRelativePath_regex=[^" + File.separator + "]+,lazy";
        BUILD_CONFIG_LINE = Pattern.compile("(?m)^(.+):");
        NEW_LINE_LENGTH = DVTStringUtil.LINE_SEPARATOR.length();
        START_OFFSET = ALL_BUILD_CONFIGS.length() + BUILD_CONFIG_SUFFIX.length() + NEW_LINE_LENGTH;
        LOG_VIEWER_DIRECTORY_PATTERN = Pattern.compile("\\.dvt\\..*");
    }

    public void initProject(IProject project) {
        FLazyResourcesNotificationTracker.INSTANCE.init(project);
        LazyResourcesModel lazyResourceModel = new LazyResourcesModel(BuildConfigManager.getAvailableBuildConfigs(project));
        this.lazyResourceFiltersCache.put(project, lazyResourceModel);
        this.initFilterFile(project);
        lazyResourceModel.setFile(this.getConfigurationFile(project));
        this.readFilters(project);
    }

    private void initFilterFile(IProject project) {
        if (DVTSConstants.DVT_USER_SETTINGS == null) {
            return;
        }
        File directory = new File(DVTSConstants.DVT_USER_SETTINGS, LAZY_RESOURCES_DIRECTORY);
        if (!directory.exists() && !directory.mkdir()) {
            return;
        }
        File configFile = new File(directory, this.getConfigurationFileName(project));
        if (configFile.exists()) {
            return;
        }
        LazyResourcesModel lazyResourcesModel = this.lazyResourceFiltersCache.get(project);
        StringBuilder sb = new StringBuilder();
        Set<String> availableBuildConfigs = lazyResourcesModel.getAvailableBuildConfigs();
        for (String buildConfigName : availableBuildConfigs) {
            sb.append(buildConfigName).append(BUILD_CONFIG_SUFFIX);
            sb.append(DVTStringUtil.LINE_SEPARATOR).append(DVTStringUtil.LINE_SEPARATOR);
        }
        DVTFileUtils.getInstance().writeStringToFile(configFile, sb.toString(), false);
        lazyResourcesModel.setFileLength(sb.length());
        lazyResourcesModel.setOffset(START_OFFSET);
        lazyResourcesModel.setFile(this.getConfigurationFile(project));
    }

    private void readFilters(IProject project) {
        if (DVTSConstants.DVT_USER_SETTINGS == null) {
            return;
        }
        this.readFiltersFromFile(project, DVTSConstants.DVT_USER_SETTINGS, true);
        if (DVTSConstants.DVT_COMMON_SETTINGS == null) {
            return;
        }
        String[] stringArray = DVTSConstants.DVT_COMMON_SETTINGS;
        int n = DVTSConstants.DVT_COMMON_SETTINGS.length;
        int n2 = 0;
        while (n2 < n) {
            String directory = stringArray[n2];
            this.readFiltersFromFile(project, directory, false);
            ++n2;
        }
    }

    private void readFiltersFromFile(IProject project, String directory, boolean shouldAddOffset) {
        String[] lines;
        File lazyResourcesDirectory = new File(directory, LAZY_RESOURCES_DIRECTORY);
        if (!lazyResourcesDirectory.exists()) {
            return;
        }
        File configFile = new File(lazyResourcesDirectory, INSTANCE.getConfigurationFileName(project));
        if (!configFile.exists()) {
            return;
        }
        LazyResourcesModel lazyResourcesModel = this.lazyResourceFiltersCache.get(project);
        Set<String> buildConfigs = lazyResourcesModel.getAvailableBuildConfigs();
        int offset = shouldAddOffset ? 0 : -1;
        String fileContent = DVTFileUtils.getInstance().readFileContent(configFile);
        String buildConfigName = ALL_BUILD_CONFIGS;
        String[] stringArray = lines = DVTStringUtil.split(DVTStringUtil.LINE_SEPARATOR, fileContent);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (DVTStringUtil.matches(BUILD_CONFIG_LINE, line)) {
                buildConfigName = line.replace(BUILD_CONFIG_SUFFIX, "");
                buildConfigs.remove(buildConfigName);
            } else if (line.trim().startsWith("-include")) {
                lazyResourcesModel.addFilter(buildConfigName, line, offset);
            }
            if (shouldAddOffset) {
                offset += line.length() + NEW_LINE_LENGTH;
            }
            ++n2;
        }
        lazyResourcesModel.setFileLength(fileContent.length());
        for (String buildConfig : buildConfigs) {
            lazyResourcesModel.addNewBuildConfig(buildConfig);
        }
    }

    private void removeLazyResources(IProject project, IResource resource) {
        LazyResourcesModel lazyResourcesModel;
        IFile configFile;
        if (project == null || resource == null) {
            return;
        }
        String root = resource.getProjectRelativePath().toPortableString();
        if (!this.lazyResourceFiltersCache.containsKey(project)) {
            this.initProject(project);
        }
        if ((configFile = (lazyResourcesModel = this.lazyResourceFiltersCache.get(project)).getFile()) == null) {
            return;
        }
        if (!configFile.exists()) {
            this.initFilterFile(project);
        }
        lazyResourcesModel.removeFilters(BuildConfigManager.getActiveBuildConfigName(project), root, LazyResourcesType.ALL);
        FLazyResourcesNotificationTracker.INSTANCE.removeDirtyResource(project, resource);
    }

    public List<String> getLazyResources(IProject project, String activeBuildConfigName, LazyResourcesType lazyResourcesType) {
        if (LazyResourcesType.ALL.equals((Object)lazyResourcesType)) {
            LinkedList<String> lazyResources = new LinkedList<String>();
            lazyResources.addAll(this.computeExceptions(project.getLocation(), LAZY_FILTER_PROPERTY));
            lazyResources.addAll(this.getLazyResources(project, activeBuildConfigName));
            lazyResources.addAll(this.getLazyResources(project, ALL_BUILD_CONFIGS));
            return lazyResources;
        }
        return this.getLazyResources(project, activeBuildConfigName);
    }

    private List<String> getLazyResources(IProject project, String buildConfigName) {
        if (!this.lazyResourceFiltersCache.containsKey(project)) {
            return Collections.emptyList();
        }
        IFile configFile = this.lazyResourceFiltersCache.get(project).getFile();
        if (configFile == null) {
            return Collections.emptyList();
        }
        if (!configFile.exists()) {
            this.initFilterFile(project);
        }
        return this.lazyResourceFiltersCache.get(project).getFilters(buildConfigName).stream().map(filter -> filter.getFilter().trim().substring("-include".length()).trim()).collect(Collectors.toList());
    }

    public IFile getConfigurationFile(IProject project) {
        if (DVTSConstants.DVT_USER_SETTINGS == null) {
            return null;
        }
        if (project == null) {
            return null;
        }
        IProject settingsProject = ResourcesPlugin.getWorkspace().getRoot().getProject("DVT-Settings");
        if (settingsProject == null) {
            return null;
        }
        IFolder userSettings = settingsProject.getFolder("user");
        if (userSettings == null) {
            return null;
        }
        try {
            userSettings.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        IFolder lazyResourcesDirectory = userSettings.getFolder(LAZY_RESOURCES_DIRECTORY);
        if (lazyResourcesDirectory == null) {
            return null;
        }
        return lazyResourcesDirectory.getFile(this.getConfigurationFileName(project));
    }

    public String getConfigurationFileName(IProject project) {
        if (project == null) {
            return "";
        }
        return String.valueOf(project.getName()) + CONFIG_EXTENSION;
    }

    private void expandNode(IResource resource, boolean expand) {
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        IViewPart view = activePage.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (view == null) {
            return;
        }
        if (!(view instanceof ProjectExplorer)) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            CommonViewer viewer = ((ProjectExplorer)view).getCommonViewer();
            if (viewer.isExpandable((Object)resource)) {
                viewer.setExpandedState((Object)resource, expand);
            }
        });
    }

    protected void removeFilter(IProject project, IResource resource, boolean updateCache) {
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return;
        }
        FilterDescription filter = this.getFilter(projectDescription, resource);
        if (filter == null) {
            return;
        }
        IPath path = resource.getProjectRelativePath();
        this.expandNode(resource, false);
        projectDescription.removeFilter(path, filter);
        ResourceFiltersManager.INSTANCE.refreshResource(project, resource, false);
        if (updateCache) {
            this.removeLazyResources(project, resource);
        }
    }

    protected void addFilter(IProject project, IResource resource, boolean buildConfigChanged, LBRLevel expandType) {
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return;
        }
        if (this.getFilter(projectDescription, resource) != null) {
            return;
        }
        FileInfoMatcherDescription filter = new FileInfoMatcherDescription("ro.amiq.dvt.multiFilter", (Object)LAZY_RESOURCE_FILTER_DESCRIPTION);
        int lazyFilterType = 45;
        if (ResourceFiltersManager.INSTANCE.getActiveFiltersSelection(project) == ResourceFiltersManager.FiltersSelectionType.BOTH) {
            lazyFilterType |= 0x40;
        }
        if (expandType == LBRLevel.ALL) {
            lazyFilterType |= 0x10;
        }
        FilterDescription filterDesc = new FilterDescription(resource, lazyFilterType, filter);
        filterDesc.setId(System.currentTimeMillis());
        projectDescription.addFilter(resource.getProjectRelativePath(), filterDesc);
        ResourceFiltersManager.INSTANCE.refreshResource(project, resource, !buildConfigChanged);
        if (buildConfigChanged) {
            this.expandNode(resource, true);
            this.addLazyResource(project, resource, expandType);
        }
    }

    private void addLazyResource(IProject project, IResource resource, LBRLevel expandType) {
        LazyResourcesModel lazyResourcesModel;
        IFile configFile;
        if (project == null || resource == null) {
            return;
        }
        if (!this.lazyResourceFiltersCache.containsKey(project)) {
            this.initProject(project);
        }
        if ((configFile = (lazyResourcesModel = this.lazyResourceFiltersCache.get(project)).getFile()) == null) {
            return;
        }
        if (!configFile.exists()) {
            this.initFilterFile(project);
        }
        String root = resource.getProjectRelativePath().toPortableString();
        String filter = String.valueOf(expandType == LBRLevel.ALL ? RECURSIVE_LEVEL_FILTER_PREFIX : NEXT_LEVEL_FILTER_PREFIX) + root;
        lazyResourcesModel.addFilter(filter, root);
        FLazyResourcesNotificationTracker.INSTANCE.addDirtyResource(project, resource.getLocation().toOSString());
    }

    public IStatus addLazyFilter(IResource resource, LBRLevel expandLevelType) {
        return this.addLazyFilter(resource, expandLevelType, true);
    }

    public IStatus addLazyFilter(IResource resource, LBRLevel expandLevelType, boolean serializeFilter) {
        if (resource == null) {
            return Status.CANCEL_STATUS;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return Status.CANCEL_STATUS;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return Status.CANCEL_STATUS;
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return Status.CANCEL_STATUS;
        }
        INSTANCE.addFilter(project, resource, serializeFilter, expandLevelType);
        INSTANCE.dirtyAutoLinkFirstLevel(project, location, expandLevelType);
        return Status.OK_STATUS;
    }

    private FilterDescription getFilter(ProjectDescription projectDescription, IResource resource) {
        IPath path = resource.getProjectRelativePath();
        LinkedList filters = projectDescription.getFilter(path);
        String filterDescription = LAZY_RESOURCE_FILTER_DESCRIPTION;
        if (filters == null) {
            return null;
        }
        for (FilterDescription filter : filters) {
            if (!filterDescription.equals(filter.getFileInfoMatcherDescription().getArguments()) || !this.isLazyFilter(filter)) continue;
            return filter;
        }
        return null;
    }

    public boolean isLazyFilter(FilterDescription filter) {
        return (filter.getType() & 0x20) != 0 && "ro.amiq.dvt.multiFilter".equals(filter.getFileInfoMatcherDescription().getId());
    }

    public Set<String> computeExceptions(IPath projectPath, String autoOrLazyString) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(".dvt,applies=fd" + autoOrLazyString);
        result.add("*,root=.dvt" + autoOrLazyString);
        result.add(".settings,applies=fd" + autoOrLazyString);
        result.add("*,root=.settings" + autoOrLazyString);
        result.add(".dvt.*,applies=fd" + autoOrLazyString);
        result.addAll(this.computeCostumNameExceptions(projectPath, autoOrLazyString));
        return result;
    }

    private Set<String> computeCostumNameExceptions(IPath projectPath, String autoOrLazyString) {
        String[] children;
        if (projectPath == null) {
            return Collections.emptySet();
        }
        File projectDirectory = projectPath.toFile();
        if (projectDirectory == null || !projectDirectory.isDirectory()) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        String[] stringArray = children = projectDirectory.list();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            if (DVTStringUtil.matches(LOG_VIEWER_DIRECTORY_PATTERN, child)) {
                result.add("*,root=" + child + autoOrLazyString);
            }
            ++n2;
        }
        return result;
    }

    public boolean canInclude(IResource resource) {
        if (resource == null) {
            return false;
        }
        if (!(resource instanceof IFolder)) {
            return false;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return false;
        }
        File file = location.toFile();
        if (file == null) {
            return false;
        }
        File[] listFiles = file.listFiles();
        if (listFiles == null || listFiles.length == 0) {
            return false;
        }
        try {
            IResource[] members = ((IFolder)resource).members();
            if (members.length > 0) {
                return false;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
        return this.hasNextLevelOfResources(resource, false);
    }

    public boolean canBeClosed(IFolder resource) {
        if (resource == null) {
            return false;
        }
        return this.hasNextLevelOfResources((IResource)resource, true);
    }

    private boolean hasNextLevelOfResources(IResource resource, boolean filterShouldExist) {
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        IContainer parent = resource.getParent();
        if (parent == null) {
            return false;
        }
        ProjectDescription projectDescription = ((Project)project).internalGetDescription();
        if (projectDescription == null) {
            return false;
        }
        HashMap filtersMap = projectDescription.getFilters();
        if (filtersMap == null) {
            return false;
        }
        LinkedList projectFilters = (LinkedList)filtersMap.get(project.getProjectRelativePath());
        LinkedList parentFilters = (LinkedList)filtersMap.get(parent.getProjectRelativePath());
        if (projectFilters == null && parentFilters == null) {
            return false;
        }
        if (!this.hasLazyFilters(projectFilters) && !this.hasLazyFilters(parentFilters)) {
            return false;
        }
        List filters = (List)filtersMap.get(resource.getProjectRelativePath());
        if (this.hasLazyFilters(filters)) {
            return filterShouldExist;
        }
        return !filterShouldExist;
    }

    public boolean hasLazyFilters(List<FilterDescription> filters) {
        return filters != null && filters.stream().anyMatch(filter -> INSTANCE.isLazyFilter((FilterDescription)filter));
    }

    public void restoreAutoLink(final IContainer root, final IProject project) {
        try {
            final Map<String, AutoLinkRoot> autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
            DVTAutoLinkManager.getInstance().startWorkspaceOperation(project, true);
            DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

                @Override
                public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                    this.createAutoLink(root, cachedLinksMap);
                }

                private void createAutoLink(IContainer folder, Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                    IResource[] members = folder.members(true);
                    if (members == null) {
                        return;
                    }
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        IPath location = resource.getLocation();
                        if (location != null) {
                            if (resource instanceof IFile && PropertiesManager.getSessionProperty(resource, PropertyTypes.QN_IMPORTED_FILE) != null && !BuildConfigManager.isSkip(resource)) {
                                DVTAutoLinkManager.getInstance().createAutoLink(project, location, autoLinkedRoots, cachedLinksMap, false);
                            } else if (resource instanceof IFolder) {
                                this.createAutoLink((IContainer)((IFolder)resource), cachedLinksMap);
                            }
                        }
                        ++n2;
                    }
                }
            };
            DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, "Auto Link Manager", op, false);
            DVTAutoLinkManager.getInstance().endWorkspaceOperation(project, false);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void dirtyAutoLinkFirstLevel(IProject project, IPath path, LBRLevel expandLevelType) {
        IFolder directory = project.getFolder("DVT Auto-Linked");
        if (directory == null || !directory.exists()) {
            return;
        }
        Map<String, AutoLinkRoot> autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
        AutoLinkRoot autoLinkRootForFile = DVTFileUtils.getInstance().autoLinkRootForFile(path, autoLinkedRoots);
        String relativePath = path.toOSString();
        if (autoLinkRootForFile != null) {
            relativePath = DVTStringUtil.replace(relativePath, autoLinkRootForFile.getExpandedPath().toOSString(), autoLinkRootForFile.getAlias(), true);
        }
        if ((directory = directory.getFolder(relativePath)) == null || !directory.exists()) {
            return;
        }
        try {
            if (expandLevelType == LBRLevel.SINGLE) {
                IResource[] members = directory.members();
                if (members == null) {
                    return;
                }
                IResource[] iResourceArray = members;
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.updateDirtyAutoLinkFile(member);
                    ++n2;
                }
                return;
            }
            directory.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    LazyResourcesModelManager.this.updateDirtyAutoLinkFile(resource);
                    return true;
                }
            });
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void updateDirtyAutoLinkFile(IResource member) throws CoreException {
        if (!(member instanceof IFile)) {
            return;
        }
        member.setSessionProperty(DVTAutoLinkManager.QN_DIRTY_AUTOLINKED_FILE, (Object)true);
        IPath memberLocation = member.getLocation();
        if (memberLocation == null) {
            return;
        }
        DVTAutoLinkManager.getInstance().removeFileInfo(memberLocation);
    }
}

