/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcemonitor;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Filter;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.floatingwidgets.FMonitorDirtyResource;
import ro.amiq.dvt.model.floatingwidgets.FMonitorNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.resourcefilters.ResourceFilterUtils;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetFactory;
import ro.amiq.dvt.ui.editor.floatingwidgets.FWidgetType;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class DVTResourceMonitor
extends Job {
    private int SLEEP_PER_VISIT = 40;
    private static final int RESCHEDULE_DELAY = 60000;
    private static final int DELTA_UP_LIMIT = 1200;
    private static final int DELTA_BOTTOM_LIMIT = 800;
    private static final int DESIRED_RES_PER_SEC = 20;
    private long startScanWindowTimestamp;
    private int resourceCounter;
    private static final String PROPERTY_PREFIX = "ro.amiq.dvt.RESOURCE_MONITOR";
    private static final DVTResourceMonitor INSTANCE = new DVTResourceMonitor();
    private static boolean isEnabled = DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.RESOURCE_MONITOR_ENABLE");
    private static int threshold = DVTPlugin.getDefault().getPreferenceStore().getInt("ro.amiq.dvt.RESOURCE_MONITOR_THRESHOLD");
    private static long timeoutMs = (long)DVTPlugin.getDefault().getPreferenceStore().getInt("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT") * 1000L;
    private static boolean isTimeoutEnabled = DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT_ENABLE");
    private PrintStream debugStream;
    public static final String DEBUG_ENV_VAR = "DVT_RESOURCE_MONITOR_DEBUG";
    private boolean isDebug;
    protected static final Set<String> SOURCE_FILE_EXTENSIONS = new HashSet<String>();
    protected static final Set<String> EXCEPTION_DIRECTORIES = new HashSet<String>(Arrays.asList(".dvt"));

    static {
        SOURCE_FILE_EXTENSIONS.addAll(Arrays.asList(IBuildConfigParserConstants.VERILOG_EXTENSIONS));
        SOURCE_FILE_EXTENSIONS.addAll(Arrays.asList(IBuildConfigParserConstants.VERILOG_AMS_EXTENSION));
        SOURCE_FILE_EXTENSIONS.addAll(Arrays.asList(IBuildConfigParserConstants.SYSTEMVERILOG_AMS_EXTENSION));
        SOURCE_FILE_EXTENSIONS.addAll(Arrays.asList(IBuildConfigParserConstants.VHDL_EXTENSIONS));
        SOURCE_FILE_EXTENSIONS.addAll(Arrays.asList(IBuildConfigParserConstants.E_EXTENSIONS));
        SOURCE_FILE_EXTENSIONS.addAll(Arrays.asList(".buildpath", ".classpath", ".cproject", ".project", ".pydevproject", ".settings"));
        IPropertyChangeListener propertyChangeListener = event -> {
            if (!event.getProperty().startsWith(PROPERTY_PREFIX)) {
                return;
            }
            Object newValue = event.getNewValue();
            switch (event.getProperty()) {
                case "ro.amiq.dvt.RESOURCE_MONITOR_ENABLE": {
                    if (newValue instanceof String) {
                        isEnabled = Boolean.parseBoolean((String)newValue);
                    } else if (newValue instanceof Boolean) {
                        isEnabled = (Boolean)newValue;
                    }
                    if (isEnabled) {
                        DVTResourceMonitor.reset(false);
                        break;
                    }
                    DVTResourceMonitor.stop(true, false);
                    break;
                }
                case "ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT": {
                    timeoutMs = (long)Integer.parseInt((String)newValue) * 1000L;
                    DVTResourceMonitor.reset(false);
                    break;
                }
                case "ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT_ENABLE": {
                    if (newValue instanceof String) {
                        isTimeoutEnabled = Boolean.parseBoolean((String)newValue);
                    } else if (newValue instanceof Boolean) {
                        isTimeoutEnabled = (Boolean)newValue;
                    }
                    DVTResourceMonitor.reset(false);
                    break;
                }
                case "ro.amiq.dvt.RESOURCE_MONITOR_THRESHOLD": {
                    threshold = Integer.parseInt((String)newValue);
                    DVTResourceMonitor.reset(false);
                    break;
                }
            }
        };
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(propertyChangeListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(event -> {
            try {
                IResourceDelta delta = event.getDelta();
                if (delta == null) {
                    return;
                }
                delta.accept(d -> {
                    IResource resource = d.getResource();
                    if ((resource.getType() & 8) != 0) {
                        return true;
                    }
                    if (DVTFileUtils.getInstance().isProjectAdded(d, resource) || DVTFileUtils.getInstance().isProjectChanged(d, resource) || DVTFileUtils.getInstance().isProjectRemoved(d, resource)) {
                        DVTResourceMonitor.reset(false);
                    }
                    return false;
                });
            }
            catch (CoreException coreException) {}
        });
        if (isEnabled) {
            INSTANCE.schedule(60000L);
        } else {
            INSTANCE.logDebug("Will not be scheduled at start-up: RM is not enabled.");
        }
    }

    private void initDebugStream() {
        if (!this.isDebug) {
            return;
        }
        try {
            String userHome = System.getProperty("user.home");
            if (userHome == null) {
                userHome = new File(".").getAbsolutePath();
            }
            File logFile = new File(userHome, ".dvt/dvt_resource_monitor_" + System.currentTimeMillis() + ".log");
            this.debugStream = new PrintStream(logFile);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void start() {
    }

    public static synchronized void stop(boolean clear, boolean waitToStop) {
        INSTANCE.logDebug("Stopping the DVT Resource Monitor...");
        INSTANCE.cancel();
        try {
            if (waitToStop) {
                INSTANCE.join();
            }
        }
        catch (InterruptedException interruptedException) {}
        if (clear) {
            FMonitorNotificationTracker.INSTANCE.clear();
        }
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.RESOURCE_MONITOR));
    }

    private static synchronized void reset(boolean waitForStop) {
        INSTANCE.logDebug("Resetting the DVT Resource Monitor...");
        INSTANCE.cancel();
        try {
            if (waitForStop) {
                INSTANCE.join();
            }
        }
        catch (InterruptedException interruptedException) {}
        FMonitorNotificationTracker.INSTANCE.clear();
        if (isEnabled) {
            INSTANCE.schedule(60000L);
        } else {
            INSTANCE.logDebug("Will not be rescheduled after reset: RM is not enabled.");
        }
        Display.getDefault().asyncExec(() -> FWidgetFactory.INSTANCE.disposeAll(FWidgetType.RESOURCE_MONITOR));
    }

    private DVTResourceMonitor() {
        super("DVT Resource Monitor");
        this.setSystem(true);
        this.setPriority(50);
        this.isDebug = Boolean.parseBoolean(System.getenv(DEBUG_ENV_VAR));
        this.initDebugStream();
    }

    /*
     * Exception decompiling
     */
    protected IStatus run(IProgressMonitor pm) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void logFilters(Map<IContainer, List<Filter>> eclipseFilters) {
        if (!this.isDebug || eclipseFilters == null || eclipseFilters.isEmpty()) {
            return;
        }
        eclipseFilters.entrySet().forEach(e -> {
            this.logDebug("\t" + ((IContainer)e.getKey()).getRawLocation().toOSString() + ":");
            ((List)e.getValue()).forEach(f2 -> this.logDebug("\t\t" + f2.getArguments()));
        });
    }

    private void logFoundDirtyDirectories() {
        if (!this.isDebug) {
            return;
        }
        Map<IProject, Set<FMonitorDirtyResource>> map = FMonitorNotificationTracker.INSTANCE.getAllDirtyResources();
        this.logDebug("Found the following aggregated problematic directories:");
        map.entrySet().forEach(e -> {
            this.logDebug("\t" + ((IProject)e.getKey()).getName() + ":");
            ((Set)e.getValue()).forEach(dr -> this.logDebug("\t\t" + dr.getPath()));
        });
    }

    private void processProjectLinks(IProject project, Path projectPath, Map<IContainer, List<Filter>> eclipseFilters, IProgressMonitor pm, boolean hasIncludeFilters) throws Exception {
        ProjectDescription projectDescription = ResourceFilterUtils.getProjectDescription(projectPath.toString());
        if (projectDescription == null) {
            return;
        }
        HashMap links = projectDescription.getLinks();
        if (links == null || links.isEmpty()) {
            return;
        }
        if (pm.isCanceled()) {
            return;
        }
        this.logDebug("Processing links for project " + project.getName() + "...");
        long start = System.currentTimeMillis();
        for (LinkDescription link : links.values()) {
            String uriStr;
            File translatedFile;
            IPath path;
            if (pm.isCanceled()) {
                this.logDebug("Processing links for project " + project.getName() + " has been interruted (canceled).");
                return;
            }
            URI locationURI = link.getLocationURI();
            if (locationURI == null || locationURI.toString().startsWith("virtual:/virtual") || (path = URIUtil.toPath((URI)locationURI)) == null || !(translatedFile = new File(DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(uriStr = ResourceFilterUtils.expandDvtEnvVars(path.toOSString()), DVTUtilsCommon.ReplaceSysvarsPolicy.LEAVE_UNREPLACED, null))).isDirectory()) continue;
            this.recursiveCheckPath(translatedFile.toPath(), translatedFile.getParentFile().toPath(), eclipseFilters, project, pm, hasIncludeFilters);
        }
        this.logDebug("Done processing links for project " + project.getName() + ". Total time: " + (float)(System.currentTimeMillis() - start) / 1000.0f + " seconds.");
    }

    private void adaptSpeed() {
        ++this.resourceCounter;
        if (this.resourceCounter == 20) {
            long currentTimeMillis = System.currentTimeMillis();
            if (currentTimeMillis - this.startScanWindowTimestamp > 1200L && this.SLEEP_PER_VISIT > 0) {
                --this.SLEEP_PER_VISIT;
            } else if (currentTimeMillis - this.startScanWindowTimestamp < 800L) {
                ++this.SLEEP_PER_VISIT;
            }
            this.startScanWindowTimestamp = currentTimeMillis;
            this.resourceCounter = 0;
        }
    }

    private DirectoryScanWrapper recursiveCheckPath(Path path, Path pathToRelativizeTo, Map<IContainer, List<Filter>> eclipseFilters, IProject project, IProgressMonitor pm, boolean hasIncludeFilters) throws IOException {
        DirectoryScanWrapper currentWrapper = new DirectoryScanWrapper();
        currentWrapper.hasSourceFiles = pathToRelativizeTo.equals(path);
        if (path == null || pm.isCanceled()) {
            return currentWrapper;
        }
        String pathString = path.toString();
        for (String exceptionDir : EXCEPTION_DIRECTORIES) {
            if (!pathString.endsWith(exceptionDir)) continue;
            currentWrapper.hasSourceFiles = true;
            return currentWrapper;
        }
        if (project == null || project.getLocation() == null) {
            return currentWrapper;
        }
        if (!pathString.equals(project.getLocation().toOSString()) && ResourceFilterUtils.isFiltered(path.toFile(), eclipseFilters, hasIncludeFilters)) {
            return currentWrapper;
        }
        long[] startTime = new long[]{System.currentTimeMillis()};
        MonitorFileVisitor visitor = new MonitorFileVisitor(this, pathToRelativizeTo, startTime, pm, currentWrapper, eclipseFilters, project, hasIncludeFilters);
        Files.walkFileTree(path, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, visitor);
        currentWrapper.scanTime = System.currentTimeMillis() - startTime[0];
        if (pm.isCanceled()) {
            return currentWrapper;
        }
        if (currentWrapper.isProblematic()) {
            this.logDebug("Found problematic path: " + path);
            String projectRelativePath = path.subpath(pathToRelativizeTo.getNameCount(), path.getNameCount()).toString();
            FMonitorDirtyResource dirtyResource = new FMonitorDirtyResource(path, projectRelativePath, currentWrapper.getProblematicReason(), currentWrapper.getProblematicValue());
            FMonitorNotificationTracker.INSTANCE.addDirtyResource(project, dirtyResource);
        }
        if (currentWrapper.hasSourceFiles && currentWrapper.isProblematic()) {
            this.logDebug("Found possible problematic path with source files: " + path);
        }
        return currentWrapper;
    }

    public static void resourceFiltersUpdated(boolean waitForStop) {
        DVTResourceMonitor.reset(waitForStop);
    }

    private void logDebug(String message) {
        if (!this.isDebug || this.debugStream == null) {
            return;
        }
        try {
            this.debugStream.println(new Timestamp(System.currentTimeMillis()) + "\t\t" + message);
            this.debugStream.flush();
        }
        catch (Exception exception) {}
    }

    private static /* synthetic */ boolean lambda$5(List filterList) {
        return filterList.stream().anyMatch(filter -> filter.isIncludeOnly());
    }

    private static /* synthetic */ void lambda$7() {
        FWidgetFactory.INSTANCE.disposeAll(FWidgetType.RESOURCE_MONITOR);
    }

    private static class DirectoryScanWrapper {
        private boolean hasSourceFiles;
        private int childrenCount;
        private float scanTime;

        private DirectoryScanWrapper() {
        }

        public void merge(DirectoryScanWrapper childWrapper) {
            this.hasSourceFiles |= childWrapper.hasSourceFiles;
            this.childrenCount += childWrapper.childrenCount;
        }

        public boolean isProblematic() {
            return !this.hasSourceFiles && (this.childrenCount >= threshold || isTimeoutEnabled && this.scanTime >= (float)timeoutMs);
        }

        public String toString() {
            return "source files: " + this.hasSourceFiles + ", non-source childrenCount: " + this.childrenCount + ", time: " + this.scanTime + "ms.";
        }

        public FNotificationDirtyReason getProblematicReason() {
            return this.childrenCount >= threshold ? FNotificationDirtyReason.DIRECTORY_CHILDREN_COUNT : FNotificationDirtyReason.DIRECTORY_TIMEOUT;
        }

        public float getProblematicValue() {
            return this.childrenCount >= threshold ? (float)this.childrenCount : this.scanTime / 1000.0f;
        }
    }

    private static class MonitorFileVisitor
    implements FileVisitor<Path> {
        private DVTResourceMonitor monitor;
        private final Path pathToRelativizeTo;
        private final long[] startTime;
        private final IProgressMonitor pm;
        private final DirectoryScanWrapper currentWrapper;
        private final Map<IContainer, List<Filter>> eclipseFilters;
        private final IProject project;
        private final boolean hasIncludeFilters;

        private MonitorFileVisitor(DVTResourceMonitor monitor, Path pathToRelativizeTo, long[] startTime, IProgressMonitor pm, DirectoryScanWrapper currentWrapper, Map<IContainer, List<Filter>> eclipseFilters, IProject project, boolean hasIncludeFilters) {
            this.monitor = monitor;
            this.pathToRelativizeTo = pathToRelativizeTo;
            this.startTime = startTime;
            this.pm = pm;
            this.currentWrapper = currentWrapper;
            this.eclipseFilters = eclipseFilters;
            this.project = project;
            this.hasIncludeFilters = hasIncludeFilters;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this.pm.isCanceled()) {
                return FileVisitResult.TERMINATE;
            }
            try {
                Thread.sleep(this.monitor.SLEEP_PER_VISIT);
                this.startTime[0] = this.startTime[0] + (long)this.monitor.SLEEP_PER_VISIT;
            }
            catch (InterruptedException interruptedException) {}
            if (file == null) {
                return FileVisitResult.CONTINUE;
            }
            if (attrs.isDirectory()) {
                DirectoryScanWrapper childWrapper = this.monitor.recursiveCheckPath(file, this.pathToRelativizeTo, this.eclipseFilters, this.project, this.pm, this.hasIncludeFilters);
                this.currentWrapper.merge(childWrapper);
                ++this.currentWrapper.childrenCount;
                return FileVisitResult.CONTINUE;
            }
            this.monitor.adaptSpeed();
            if (!this.currentWrapper.hasSourceFiles && this.isSourceFile(file)) {
                this.currentWrapper.hasSourceFiles = true;
            } else {
                ++this.currentWrapper.childrenCount;
            }
            return FileVisitResult.CONTINUE;
        }

        private boolean isSourceFile(Path f2) {
            String filename = f2.toString();
            for (String ext : SOURCE_FILE_EXTENSIONS) {
                if (!filename.endsWith(ext)) continue;
                return true;
            }
            return false;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            this.monitor.adaptSpeed();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

