/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resourcemonitor.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import ro.amiq.dvt.DVTPlugin;

public class ResourceMonitorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "ro.amiq.dvt.ResourceMonitorPreferencePage";
    private Button fResourceMonitorDirectoryTimeoutButton;
    private Combo fResourceMonitorDirectoryTimeout;
    private Combo fResourceMonitorThreshold;
    private Button fResourceMonitorEnableButton;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(DVTPlugin.getDefault().getPreferenceStore());
        this.setDescription("DVT Resource Monitor Settings");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        GridDataFactory.fillDefaults().hint(parent.computeSize(-1, -1)).applyTo((Control)composite);
        this.fResourceMonitorEnableButton = new Button(composite, 32);
        this.fResourceMonitorEnableButton.setFont(parent.getFont());
        this.fResourceMonitorEnableButton.setText("Enable the Resource Monitor");
        this.fResourceMonitorEnableButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.RESOURCE_MONITOR_ENABLE"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).span(3, 1).grab(false, false).applyTo((Control)this.fResourceMonitorEnableButton);
        this.fResourceMonitorEnableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResourceMonitorPreferencePage.this.fResourceMonitorDirectoryTimeout.setEnabled(ResourceMonitorPreferencePage.this.fResourceMonitorEnableButton.getSelection() && ResourceMonitorPreferencePage.this.fResourceMonitorDirectoryTimeoutButton.getSelection());
                ResourceMonitorPreferencePage.this.fResourceMonitorThreshold.setEnabled(ResourceMonitorPreferencePage.this.fResourceMonitorEnableButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fResourceMonitorDirectoryTimeoutButton = new Button(composite, 32);
        this.fResourceMonitorDirectoryTimeoutButton.setFont(parent.getFont());
        this.fResourceMonitorDirectoryTimeoutButton.setText("Timeout scanning a directory after: ");
        this.fResourceMonitorDirectoryTimeoutButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getBoolean("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT_ENABLE"));
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)this.fResourceMonitorDirectoryTimeoutButton);
        this.fResourceMonitorDirectoryTimeout = new Combo(composite, 2048);
        this.fResourceMonitorDirectoryTimeout.setFont(parent.getFont());
        this.fResourceMonitorDirectoryTimeout.setEnabled(this.fResourceMonitorDirectoryTimeoutButton.getSelection());
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).hint(65, -1).applyTo((Control)this.fResourceMonitorDirectoryTimeout);
        this.fResourceMonitorDirectoryTimeoutButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ResourceMonitorPreferencePage.this.fResourceMonitorDirectoryTimeout.setEnabled(ResourceMonitorPreferencePage.this.fResourceMonitorEnableButton.getSelection() && ResourceMonitorPreferencePage.this.fResourceMonitorDirectoryTimeoutButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fResourceMonitorDirectoryTimeout.setItems(new String[]{"1", "2", "3", "4", "5", "10"});
        this.fResourceMonitorDirectoryTimeout.setText(DVTPlugin.getDefault().getPreferenceStore().getString("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT"));
        this.fResourceMonitorDirectoryTimeout.setTextLimit(3);
        this.fResourceMonitorDirectoryTimeout.addModifyListener(e -> {
            this.setValid(true);
            this.setErrorMessage(null);
            String resourceMonitorTimeout = this.fResourceMonitorDirectoryTimeout.getText();
            try {
                int value = Integer.parseInt(resourceMonitorTimeout);
                if (value < 1) {
                    this.setErrorMessage("Resource monitor timeout must be a valid, positive number!");
                    this.setValid(false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("'" + resourceMonitorTimeout + "' is not a valid number!");
                this.setValid(false);
            }
        });
        Label resourceMonitorTimeoutLabel = new Label(composite, 0);
        resourceMonitorTimeoutLabel.setFont(parent.getFont());
        resourceMonitorTimeoutLabel.setText("seconds.");
        Label infoLabel4 = new Label(composite, 0);
        infoLabel4.setFont(parent.getFont());
        infoLabel4.setText("Directory children count threshold:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)infoLabel4);
        this.fResourceMonitorThreshold = new Combo(composite, 2048);
        this.fResourceMonitorThreshold.setFont(parent.getFont());
        this.fResourceMonitorThreshold.setEnabled(true);
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).hint(65, -1).applyTo((Control)this.fResourceMonitorThreshold);
        this.fResourceMonitorThreshold.setItems(new String[]{"10", "20", "30", "40", "50", "100", "200", "500", "1000"});
        this.fResourceMonitorThreshold.setText(DVTPlugin.getDefault().getPreferenceStore().getString("ro.amiq.dvt.RESOURCE_MONITOR_THRESHOLD"));
        this.fResourceMonitorThreshold.setTextLimit(5);
        this.fResourceMonitorThreshold.addModifyListener(e -> {
            this.setValid(true);
            this.setErrorMessage(null);
            String resourceMonitorThreshold = this.fResourceMonitorThreshold.getText();
            try {
                int value = Integer.parseInt(resourceMonitorThreshold);
                if (value < 1) {
                    this.setErrorMessage("Resource monitor threshold must be a valid, positive number!");
                    this.setValid(false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setErrorMessage("'" + resourceMonitorThreshold + "' is not a valid number!");
                this.setValid(false);
            }
        });
        Label resourceMonitorFilesLabel = new Label(composite, 0);
        resourceMonitorFilesLabel.setFont(parent.getFont());
        resourceMonitorFilesLabel.setText("files.");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.fResourceMonitorEnableButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ro.amiq.dvt.RESOURCE_MONITOR_ENABLE"));
        this.fResourceMonitorDirectoryTimeoutButton.setSelection(DVTPlugin.getDefault().getPreferenceStore().getDefaultBoolean("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT_ENABLE"));
        this.fResourceMonitorDirectoryTimeout.setEnabled(this.fResourceMonitorEnableButton.getSelection() && this.fResourceMonitorDirectoryTimeoutButton.getSelection());
        this.fResourceMonitorDirectoryTimeout.setText("" + DVTPlugin.getDefault().getPreferenceStore().getDefaultInt("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT"));
        this.fResourceMonitorThreshold.setText("" + DVTPlugin.getDefault().getPreferenceStore().getDefaultInt("ro.amiq.dvt.RESOURCE_MONITOR_THRESHOLD"));
        this.fResourceMonitorThreshold.setEnabled(this.fResourceMonitorEnableButton.getSelection());
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("ro.amiq.dvt.RESOURCE_MONITOR_ENABLE", this.fResourceMonitorEnableButton.getSelection());
        this.getPreferenceStore().setValue("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT_ENABLE", this.fResourceMonitorDirectoryTimeoutButton.getSelection());
        this.getPreferenceStore().setValue("ro.amiq.dvt.RESOURCE_MONITOR_TIMEOUT", this.fResourceMonitorDirectoryTimeout.getText());
        this.getPreferenceStore().setValue("ro.amiq.dvt.RESOURCE_MONITOR_THRESHOLD", this.fResourceMonitorThreshold.getText());
        DVTPlugin.getDefault().savePreferences();
        return true;
    }
}

