/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resources.properties;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public enum LazyPersistentPropertiesManager {
    INSTANCE;

    private static final String LAZY_PERSISTENT_PROPERTIES = "lazy_persistent_properties";
    private static final long SAVE_DELAY_MS = 5000L;
    private static final long SAVE_INTERVAL_MS = 1000L;
    private Timer fTimer = new Timer();
    private TimerTask fTTimerTask = new TimerTask(){

        @Override
        public void run() {
            if (BuildConfigManager.isBatchMode()) {
                return;
            }
            Iterator<IProject> it = LazyPersistentPropertiesManager.this.fPropertiesByProject.keySet().iterator();
            while (it.hasNext()) {
                IProject project = it.next();
                if (!project.isAccessible()) {
                    it.remove();
                    continue;
                }
                ProjectProperties projectProperties = LazyPersistentPropertiesManager.this.fPropertiesByProject.get(project);
                if (projectProperties.nextSave == 0L || projectProperties.nextSave >= System.currentTimeMillis()) continue;
                projectProperties.nextSave = 0L;
                projectProperties.save(project);
            }
        }
    };
    private Map<IProject, ProjectProperties> fPropertiesByProject;

    private LazyPersistentPropertiesManager() {
        this.fTimer.schedule(this.fTTimerTask, 1000L, 1000L);
        this.fPropertiesByProject = new ConcurrentHashMap<IProject, ProjectProperties>();
    }

    public synchronized void reload(IProject project) {
        this.fPropertiesByProject.remove(project);
    }

    public void removeProperties(IProject project) {
        try {
            this.fPropertiesByProject.put(project, new ProjectProperties());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private ProjectProperties getProjectProperties(IProject project) {
        if (this.fPropertiesByProject.get(project) == null) {
            ProjectProperties properties;
            block6: {
                properties = null;
                ObjectInputStream ois = null;
                try {
                    try {
                        String location = BuildConfigManager.getModelPersistenceLocation(project, LAZY_PERSISTENT_PROPERTIES, true, BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                        ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(location)));
                        properties = (ProjectProperties)ois.readObject();
                    }
                    catch (Exception exception) {
                        properties = new ProjectProperties();
                        DVTUtilsCommon.INSTANCE.closeClosable(ois);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    DVTUtilsCommon.INSTANCE.closeClosable(ois);
                    throw throwable;
                }
                DVTUtilsCommon.INSTANCE.closeClosable(ois);
            }
            this.fPropertiesByProject.put(project, properties);
        }
        return this.fPropertiesByProject.get(project);
    }

    public boolean isRestored(IProject project) {
        return this.fPropertiesByProject.get(project) != null;
    }

    protected synchronized void addParser2ResourceMapProperty(IProject project, String parserPath, String resourcePath) {
        IPropertyValue oldResource;
        if (parserPath == null || resourcePath == null) {
            return;
        }
        ResourcePathProperty resourcePropertyPath = new ResourcePathProperty(resourcePath);
        ParserPathProperty parserPropertyPath = new ParserPathProperty(parserPath);
        IPropertyValue oldParser = this.getProperty((IResource)project, resourcePropertyPath);
        if (oldParser != null) {
            this.addProperty((IResource)project, new ParserPathProperty(oldParser.value()), null);
        }
        if ((oldResource = this.getProperty((IResource)project, parserPropertyPath)) != null) {
            this.addProperty((IResource)project, new ParserPathProperty(oldResource.value()), null);
        }
        this.addProperty((IResource)project, parserPropertyPath, resourcePropertyPath);
        this.addProperty((IResource)project, resourcePropertyPath, parserPropertyPath);
    }

    protected synchronized void addSessionProperty(IResource resource, String propertyKind, String propertyValue) {
        this.addProperty(resource, new PropertyKind(propertyKind), new PropertyValue(propertyValue));
    }

    public synchronized IPropertyValue getProperty(IResource resource, IPropertyKind qName) {
        if (resource == null || qName == null || qName.value() == null) {
            return null;
        }
        IProject project = resource.getProject();
        if (project == null) {
            return null;
        }
        ProjectProperties projectProperties = this.getProjectProperties(project);
        IPath projectRelativePath = resource.getProjectRelativePath();
        if ("DVT Auto-Linked".equals(projectRelativePath.segment(0))) {
            IPropertyValue result = projectProperties.getProperty(projectRelativePath.toOSString(), qName);
            if (result != null) {
                return result;
            }
            IPath location = resource.getLocation();
            if (location == null) {
                return null;
            }
            projectRelativePath = location.makeRelativeTo(project.getLocation());
            if (projectRelativePath == null) {
                return null;
            }
        }
        return projectProperties.getProperty(projectRelativePath.toOSString(), qName);
    }

    public synchronized void cleanForDebug(IProject project) {
        Map<IPropertyKind, IPropertyValue> map = this.getProjectProperties(project).getProperties(project.getProjectRelativePath().toOSString());
        if (map == null) {
            return;
        }
        map.clear();
        this.getProjectProperties(project).save(project);
    }

    private void addProperty(IResource resource, IPropertyKind qName, IPropertyValue value) {
        if (resource == null || resource.getProject() == null) {
            return;
        }
        if (value == null || value.value() == null) {
            value = null;
        }
        this.getProjectProperties(resource.getProject()).putProperty(resource.getProjectRelativePath().toOSString(), qName, value);
    }

    public void updateProjectResourcePathMapping(IProject project, Map<IResource, IResource> resourcePathChanges) {
        ProjectProperties pp = this.getProjectProperties(project);
        if (pp == null) {
            return;
        }
        pp.updateProjectResourcePathMapping(project, resourcePathChanges);
    }

    public void accept(IProject project, IPathMappingVisitor visitor) {
        if (visitor == null) {
            return;
        }
        ProjectProperties pp = this.getProjectProperties(project);
        if (pp == null) {
            return;
        }
        pp.accept(project, visitor);
    }

    public static interface IPathMappingVisitor {
        public String visit(String var1, String var2);
    }

    private static interface IProperty
    extends Serializable {
        public String value();
    }

    public static interface IPropertyKind
    extends IProperty {
    }

    public static interface IPropertyValue
    extends IProperty {
    }

    public static class ParserPathProperty
    extends Property
    implements IPropertyKind,
    IPropertyValue {
        private static final long serialVersionUID = 21115L;

        public ParserPathProperty(String value) {
            super(value);
        }

        @Override
        public String toString() {
            return "parser path: " + this.value();
        }
    }

    private static class ProjectProperties
    implements Serializable {
        private static final long serialVersionUID = 21115L;
        private transient long nextSave;
        private Map<String, Map<IPropertyKind, IPropertyValue>> fPropertiesByResourcePath = new LinkedHashMap<String, Map<IPropertyKind, IPropertyValue>>();

        private ProjectProperties() {
        }

        private IPropertyValue getProperty(String projectRelativePath, IPropertyKind qName) {
            if (qName == null) {
                return null;
            }
            Map<IPropertyKind, IPropertyValue> resourceProperties = this.fPropertiesByResourcePath.get(projectRelativePath);
            if (resourceProperties == null) {
                return null;
            }
            IPropertyValue property = resourceProperties.get(qName);
            return property;
        }

        private Map<IPropertyKind, IPropertyValue> getProperties(String projectRelativePath) {
            return this.fPropertiesByResourcePath.get(projectRelativePath);
        }

        private void putProperty(String projectRelativePath, IPropertyKind qName, IPropertyValue value) {
            if (qName == null) {
                return;
            }
            Map<IPropertyKind, IPropertyValue> resourceProperties = this.fPropertiesByResourcePath.get(projectRelativePath);
            if (resourceProperties == null) {
                resourceProperties = new LinkedHashMap<IPropertyKind, IPropertyValue>();
                this.fPropertiesByResourcePath.put(projectRelativePath, resourceProperties);
            }
            if (value == null) {
                resourceProperties.remove(qName);
            } else {
                resourceProperties.put(qName, value);
            }
            this.scheduleSave();
        }

        private void scheduleSave() {
            this.nextSave = System.currentTimeMillis() + 5000L;
        }

        private synchronized void save(IProject project) {
            block14: {
                String location;
                ObjectOutputStream oos;
                block13: {
                    Map<IPropertyKind, IPropertyValue> map;
                    block12: {
                        oos = null;
                        map = this.getProperties(project.getProjectRelativePath().toOSString());
                        if (map != null) break block12;
                        DVTUtilsCommon.INSTANCE.closeClosable(oos);
                        return;
                    }
                    Iterator<IPropertyKind> it = map.keySet().iterator();
                    while (it.hasNext()) {
                        IPropertyKind key = it.next();
                        String resourcePath = null;
                        if (key instanceof ResourcePathProperty) {
                            resourcePath = key.value();
                        } else {
                            if (!(key instanceof ParserPathProperty)) continue;
                            resourcePath = map.get(key).value();
                        }
                        if (BuildConfigManager.isBatchMode() || project.getFile(resourcePath).exists()) continue;
                        it.remove();
                    }
                    location = BuildConfigManager.getModelPersistenceLocation(project, LazyPersistentPropertiesManager.LAZY_PERSISTENT_PROPERTIES, false, BuildConfigManagerCommon.PersistenceModeWrapper.regular());
                    if (location != null) break block13;
                    DVTUtilsCommon.INSTANCE.closeClosable(oos);
                    return;
                }
                try {
                    oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(location)));
                    oos.writeObject(this);
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    this.scheduleSave();
                    DVTUtilsCommon.INSTANCE.closeClosable(oos);
                    break block14;
                }
                catch (Exception e) {
                    try {
                        DVTLogger.INSTANCE.logError((Throwable)e);
                        break block14;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        DVTUtilsCommon.INSTANCE.closeClosable(oos);
                    }
                }
                DVTUtilsCommon.INSTANCE.closeClosable(oos);
            }
        }

        private void updateProjectResourcePathMapping(IProject project, Map<IResource, IResource> resourcePathChanges) {
            if (!resourcePathChanges.isEmpty()) {
                Map<IPropertyKind, IPropertyValue> map = this.fPropertiesByResourcePath.get("");
                if (map == null) {
                    return;
                }
                for (Map.Entry<IResource, IResource> entry : resourcePathChanges.entrySet()) {
                    Map<IPropertyKind, IPropertyValue> oldvalue;
                    IResource oldResource = entry.getKey();
                    ResourcePathProperty oldResourceRelativePath = new ResourcePathProperty(oldResource.getProjectRelativePath().toOSString());
                    IPropertyValue parserPath = map.get(oldResourceRelativePath);
                    if (!(parserPath instanceof ParserPathProperty)) continue;
                    IResource newResource = entry.getValue();
                    ResourcePathProperty newResourceRelativePath = new ResourcePathProperty(newResource.getProjectRelativePath().toOSString());
                    map.put((ParserPathProperty)parserPath, newResourceRelativePath);
                    map.put(newResourceRelativePath, parserPath);
                    if (!newResourceRelativePath.equals(oldResourceRelativePath)) {
                        map.remove(oldResourceRelativePath);
                    }
                    if ((oldvalue = this.fPropertiesByResourcePath.remove(oldResourceRelativePath.value())) == null) continue;
                    this.fPropertiesByResourcePath.put(newResourceRelativePath.value(), oldvalue);
                }
            }
        }

        private void accept(IProject project, IPathMappingVisitor visitor) {
            Map<IPropertyKind, IPropertyValue> map = this.fPropertiesByResourcePath.get("");
            if (map == null) {
                return;
            }
            Iterator<IPropertyKind> it = map.keySet().iterator();
            while (it.hasNext()) {
                IPropertyKind key = it.next();
                String resourcePath = null;
                String fileSystemPath = null;
                if (key instanceof ResourcePathProperty) {
                    resourcePath = key.value();
                    fileSystemPath = map.get(key).value();
                } else {
                    if (!(key instanceof ParserPathProperty)) continue;
                    resourcePath = map.get(key).value();
                    fileSystemPath = key.value();
                }
                if (visitor != null) {
                    visitor.visit(fileSystemPath, resourcePath);
                }
                if (BuildConfigManager.isBatchMode() || project.getFile(resourcePath).exists()) continue;
                it.remove();
            }
        }
    }

    private static abstract class Property
    implements IProperty {
        private static final long serialVersionUID = 21115L;
        private String fValue;

        public Property(String value) {
            this.fValue = value;
        }

        @Override
        public String value() {
            return this.fValue;
        }

        public abstract String toString();

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IProperty)) {
                return false;
            }
            return this.toString().equals(obj.toString());
        }
    }

    public static class PropertyKind
    extends Property
    implements IPropertyKind {
        private static final long serialVersionUID = 21115L;

        public PropertyKind(String value) {
            super(value);
        }

        @Override
        public String toString() {
            return "property kind: " + this.value();
        }
    }

    public static class PropertyValue
    extends Property
    implements IPropertyValue {
        private static final long serialVersionUID = 21115L;

        public PropertyValue(String value) {
            super(value);
        }

        @Override
        public String toString() {
            return "property value: " + this.value();
        }
    }

    public static class ResourcePathProperty
    extends Property
    implements IPropertyKind,
    IPropertyValue {
        private static final long serialVersionUID = 21115L;

        public ResourcePathProperty(String value) {
            super(value);
        }

        @Override
        public String toString() {
            return "resource path: " + this.value();
        }
    }
}

