/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.resources.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.resources.properties.LazyPersistentPropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;

public class PropertiesManager {
    public static void addImportedFile(ParserPath parserPath, String propertyValue) {
        if (propertyValue == null) {
            return;
        }
        IPath resourcePath = Path.fromOSString((String)parserPath.path);
        if (resourcePath.lastSegment().startsWith("__vlog__")) {
            return;
        }
        IProject project = RfMixedLangManager.getInstance().getProject();
        if (project == null) {
            return;
        }
        IFile resource = project.getFile(resourcePath);
        PropertiesManager.addSessionProperty((IResource)resource, PropertyTypes.QN_IMPORTED_FILE, propertyValue);
        IFile parent = resource;
        while ((parent = parent.getParent()) != null && PropertiesManager.getSessionProperty((IResource)parent, PropertyTypes.QN_IMPORTED_FILE) == null) {
            PropertiesManager.addSessionProperty((IResource)parent, PropertyTypes.QN_IMPORTED_FILE, propertyValue);
        }
        PropertiesManager.addParser2ResourceMapProperty(project, parserPath.path, resource.getProjectRelativePath().toOSString());
    }

    public static void addSessionProperty(IResource resource, String qName, String value) {
        LazyPersistentPropertiesManager.INSTANCE.addSessionProperty(resource, qName, value);
    }

    public static void addParser2ResourceMapProperty(IProject project, String parserPath, String resourcePath) {
        LazyPersistentPropertiesManager.INSTANCE.addParser2ResourceMapProperty(project, parserPath, resourcePath);
    }

    public static String getSessionProperty(IResource resource, String qName) {
        LazyPersistentPropertiesManager.IPropertyValue result = LazyPersistentPropertiesManager.INSTANCE.getProperty(resource, new LazyPersistentPropertiesManager.PropertyKind(qName));
        if (result == null) {
            return null;
        }
        return result.value();
    }
}

